/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryFieldValueListWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJsonResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.gax.paging.Page;
import shaded.bqjdbc.com.google.cloud.Tuple;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQuery;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQueryException;
import shaded.bqjdbc.com.google.cloud.bigquery.Dataset;
import shaded.bqjdbc.com.google.cloud.bigquery.DatasetId;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldList;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValue;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValueList;
import shaded.bqjdbc.com.google.cloud.bigquery.Routine;
import shaded.bqjdbc.com.google.cloud.bigquery.RoutineArgument;
import shaded.bqjdbc.com.google.cloud.bigquery.RoutineId;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLDataType;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLField;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTableType;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTypeName;
import shaded.bqjdbc.com.google.cloud.bigquery.Table;
import shaded.bqjdbc.com.google.cloud.bigquery.TableDefinition;
import shaded.bqjdbc.com.google.cloud.bigquery.TableId;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcException;

class BigQueryDatabaseMetaData
implements DatabaseMetaData {
    final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private static final String DATABASE_PRODUCT_NAME = "Google BigQuery";
    private static final String DATABASE_PRODUCT_VERSION = "2.0";
    private static final String DRIVER_NAME = "GoogleJDBCDriverForGoogleBigQuery";
    private static final String DRIVER_DEFAULT_VERSION = "0.0.0";
    private static final String SCHEMA_TERM = "Dataset";
    private static final String CATALOG_TERM = "Project";
    private static final String PROCEDURE_TERM = "Procedure";
    private static final String GET_PRIMARY_KEYS_SQL = "DatabaseMetaData_GetPrimaryKeys.sql";
    private static final String GET_IMPORTED_KEYS_SQL = "DatabaseMetaData_GetImportedKeys.sql";
    private static final String GET_EXPORTED_KEYS_SQL = "DatabaseMetaData_GetExportedKeys.sql";
    private static final String GET_CROSS_REFERENCE_SQL = "DatabaseMetaData_GetCrossReference.sql";
    private static final int API_EXECUTOR_POOL_SIZE = 50;
    private static final int DEFAULT_PAGE_SIZE = 500;
    private static final int DEFAULT_QUEUE_CAPACITY = 5000;
    static final String GOOGLE_SQL_QUOTED_IDENTIFIER = "`";
    static final String GOOGLE_SQL_RESERVED_KEYWORDS = "ASC,ASSERT_ROWS_MODIFIED,DESC,ENUM,EXCLUDE,FOLLOWING,HASH,IF,IGNORE,LIMIT,LOOKUP,NULLS,PRECEDING,PROTO,QUALIFY,RESPECT,STRUCT,UNBOUNDED";
    static final String GOOGLE_SQL_NUMERIC_FNS = "ABS,ACOS,ACOSH,ASIN,ASINH,ATAN,ATAN2,ATANH,CBRT,CEIL,CEILING,COS,COSH,COSINE_DISTANCE,COT,COTH,CSC,CSCH,DIV,EXP,EUCLIDEAN_DISTANCE,FLOOR,GREATEST,IS_INF,LEAST,LN,LOG,LOG10,MOD,POW,RAND,RANGE_BUCKET,ROUND,,SAFE_ADD,SAFE_DIVIDE,SAFE_MULTIPLY,SAFE_NEGATE,SAFE_SUBTRACT,SEC,SECH,SIGN,SIN,SINH,SQRT,TAN,TANH,TRUNC";
    static final String GOOGLE_SQL_STRING_FNS = "ASCII,BYTE_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,CODE_POINTS_TO_BYTES,CODE_POINTS_TO_STRING,COLLATE,CONCAT,CONTAINS_SUBSTR,EDIT_DISTANCE,ENDS_WITH,FORMAT,FROM_BASE32,FROM_BASE64,FROM_HEX,INITCAP,INSTR,LEFT,LENGTH,LOWER,LPAD,LTRIM,NORMALIZ,NORMALIZE_AND_CASEFOLD,OCTET_LENGTH,REGEXP_CONTAINS,REGEXP_EXTRACT,REGEXP_EXTRACT_ALL,REGEXP_INSTR,REGEXP_REPLACE,REGEXP_SUBSTR,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SAFE_CONVERT_BYTES_TO_STRING,SOUNDEX,SPLIT,STARTS_WITH,STRPOS,SUBSTR,SUBSTRING,TO_BASE32,TO_BASE64,TO_CODE_POINTS,TO_HEX,TRANSLATE,TRIMunicode,UNICODE,UPPER";
    static final String GOOGLE_SQL_TIME_DATE_FNS = "DATE,DATE_ADD,DATE_BUCKET,DATE_DIFF,DATE_FROM_UNIX_DATE,DATE_SUB,DATE_TRUNC,DATETIME,DATETIME_ADD.,DATETIME_BUCKET,DATETIME_DIFF,DATETIME_SUB,DATETIME_TRUNC,CURRENT_DATE,CURRENT_DATETIME,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TIME,EXTRACT,FORMAT_TIME,PARSE_TIME,TIME,TIME_ADD,TIME_DIFF,TIME_SUB,TIME_TRUNC,CURRENT_TIMESTAMP,EXTRACT,FORMAT_TIMESTAMP,GENERATE_TIMESTAMP_ARRAY,PARSE_TIMESTAMP,TIMESTAMP,TIMESTAMP_ADD,TIMESTAMP_DIFF,TIMESTAMP_MICROS,TIMESTAMP_MILLIS,TIMESTAMP_SECONDS,TIMESTAMP_SUB,TIMESTAMP_TRUNC,UNIX_MICROS,UNIX_MILLIS,UNIX_SECONDS";
    static final String GOOGLE_SQL_ESCAPE = "\\";
    static final String GOOGLE_SQL_CATALOG_SEPARATOR = ".";
    static final int GOOGLE_SQL_MAX_COL_NAME_LEN = 300;
    static final int GOOGLE_SQL_MAX_COLS_PER_TABLE = 10000;
    String URL;
    BigQueryConnection connection;
    private final BigQueryStatement statement;
    private final BigQuery bigquery;
    private final int metadataFetchThreadCount;
    private static final AtomicReference<String> parsedDriverVersion = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> parsedDriverMajorVersion = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> parsedDriverMinorVersion = new AtomicReference<Object>(null);

    BigQueryDatabaseMetaData(BigQueryConnection connection) throws SQLException {
        this.URL = connection.getConnectionUrl();
        this.connection = connection;
        this.statement = connection.createStatement().unwrap(BigQueryStatement.class);
        this.bigquery = connection.getBigQuery();
        this.metadataFetchThreadCount = connection.getMetadataFetchThreadCount();
        this.loadDriverVersionProperties();
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.URL;
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return DATABASE_PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() {
        return DATABASE_PRODUCT_VERSION;
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() {
        return parsedDriverVersion.get() != null ? parsedDriverVersion.get() : DRIVER_DEFAULT_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return parsedDriverMajorVersion.get() != null ? parsedDriverMajorVersion.get() : 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return parsedDriverMinorVersion.get() != null ? parsedDriverMinorVersion.get() : 0;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return GOOGLE_SQL_QUOTED_IDENTIFIER;
    }

    @Override
    public String getSQLKeywords() {
        return GOOGLE_SQL_RESERVED_KEYWORDS;
    }

    @Override
    public String getNumericFunctions() {
        return GOOGLE_SQL_NUMERIC_FNS;
    }

    @Override
    public String getStringFunctions() {
        return GOOGLE_SQL_STRING_FNS;
    }

    @Override
    public String getSystemFunctions() {
        return null;
    }

    @Override
    public String getTimeDateFunctions() {
        return GOOGLE_SQL_TIME_DATE_FNS;
    }

    @Override
    public String getSearchStringEscape() {
        return GOOGLE_SQL_ESCAPE;
    }

    @Override
    public String getExtraNameCharacters() {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return SCHEMA_TERM;
    }

    @Override
    public String getProcedureTerm() {
        return PROCEDURE_TERM;
    }

    @Override
    public String getCatalogTerm() {
        return CATALOG_TERM;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return GOOGLE_SQL_CATALOG_SEPARATOR;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 300;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 10000;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 256;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 30;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 1000;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        if (catalog == null || catalog.isEmpty() || schemaPattern != null && schemaPattern.isEmpty() || procedureNamePattern != null && procedureNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet as catalog is null/empty or a pattern is empty.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getProcedures called for catalog: %s, schemaPattern: %s, procedureNamePattern: %s", catalog, schemaPattern, procedureNamePattern));
        Pattern schemaRegex = this.compileSqlLikePattern(schemaPattern);
        Pattern procedureNameRegex = this.compileSqlLikePattern(procedureNamePattern);
        Schema resultSchema = this.defineGetProceduresSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        ArrayList processingTaskFutures = new ArrayList();
        String catalogParam = catalog;
        Runnable procedureFetcher = () -> {
            List<Dataset> datasetsToScan;
            ArrayList<Future<List>> apiFutures;
            FieldList localResultSchemaFields;
            ExecutorService routineProcessorExecutor;
            ExecutorService apiExecutor;
            block19: {
                apiExecutor = null;
                routineProcessorExecutor = null;
                localResultSchemaFields = resultSchemaFields;
                apiFutures = new ArrayList<Future<List>>();
                datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaPattern, schemaRegex, this.LOG);
                if (!datasetsToScan.isEmpty()) break block19;
                this.LOG.info("Fetcher thread found no matching datasets. Finishing.");
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(routineProcessorExecutor);
                this.LOG.info("Procedure fetcher thread finished.");
                return;
            }
            try {
                apiExecutor = Executors.newFixedThreadPool(50);
                routineProcessorExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount);
                this.LOG.fine("Submitting parallel findMatchingRoutines tasks...");
                for (Dataset dataset : datasetsToScan) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Fetcher interrupted during dataset iteration submission.");
                        break;
                    }
                    DatasetId currentDatasetId = dataset.getDatasetId();
                    Callable<List> apiCallable = () -> this.findMatchingBigQueryObjects("Routine", () -> this.bigquery.listRoutines(currentDatasetId, BigQuery.RoutineListOption.pageSize(500L)), name -> this.bigquery.getRoutine(RoutineId.of(currentDatasetId.getProject(), currentDatasetId.getDataset(), name), new BigQuery.RoutineOption[0]), rt -> rt.getRoutineId().getRoutine(), procedureNamePattern, procedureNameRegex, this.LOG);
                    Future<List> apiFuture = apiExecutor.submit(apiCallable);
                    apiFutures.add(apiFuture);
                }
                this.LOG.fine("Finished submitting " + apiFutures.size() + " findMatchingRoutines tasks.");
                apiExecutor.shutdown();
                this.LOG.fine("Processing results from findMatchingRoutines tasks...");
                block10: for (Future future : apiFutures) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Fetcher interrupted while processing API futures.");
                        break;
                    }
                    try {
                        List routinesResult = (List)future.get();
                        if (routinesResult == null) continue;
                        for (Routine routine : routinesResult) {
                            if (Thread.currentThread().isInterrupted()) continue block10;
                            if ("PROCEDURE".equalsIgnoreCase(routine.getRoutineType())) {
                                this.LOG.fine("Submitting processing task for procedure: " + routine.getRoutineId());
                                Routine finalRoutine = routine;
                                Future<?> processFuture = routineProcessorExecutor.submit(() -> this.processProcedureInfo(finalRoutine, collectedResults, localResultSchemaFields));
                                processingTaskFutures.add(processFuture);
                                continue;
                            }
                            this.LOG.finer("Skipping non-procedure routine: " + routine.getRoutineId());
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.LOG.warning("Fetcher thread interrupted while waiting for API future result.");
                        break;
                    }
                    catch (ExecutionException e) {
                        this.LOG.warning("Error executing findMatchingRoutines task: " + e.getMessage() + ". Cause: " + e.getCause());
                    }
                    catch (CancellationException e) {
                        this.LOG.warning("A findMatchingRoutines task was cancelled.");
                    }
                }
                this.LOG.fine("Finished submitting " + processingTaskFutures.size() + " processProcedureInfo tasks.");
                if (Thread.currentThread().isInterrupted()) {
                    this.LOG.warning("Fetcher interrupted before waiting for processing tasks; cancelling remaining.");
                    processingTaskFutures.forEach(f -> f.cancel(true));
                } else {
                    this.LOG.fine("Waiting for processProcedureInfo tasks to complete...");
                    this.waitForTasksCompletion(processingTaskFutures);
                    this.LOG.fine("All processProcedureInfo tasks completed or handled.");
                }
                if (!Thread.currentThread().isInterrupted()) {
                    Comparator<FieldValueList> comparator = this.defineGetProceduresComparator(localResultSchemaFields);
                    this.sortResults(collectedResults, comparator, "getProcedures", this.LOG);
                }
                if (!Thread.currentThread().isInterrupted()) {
                    this.populateQueue(collectedResults, queue, localResultSchemaFields);
                }
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(routineProcessorExecutor);
            }
            catch (Throwable t2) {
                try {
                    this.LOG.severe("Unexpected error in procedure fetcher runnable: " + t2.getMessage());
                    apiFutures.forEach(f -> f.cancel(true));
                    processingTaskFutures.forEach(f -> f.cancel(true));
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(routineProcessorExecutor);
                }
                catch (Throwable throwable) {
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(routineProcessorExecutor);
                    this.LOG.info("Procedure fetcher thread finished.");
                    throw throwable;
                }
                this.LOG.info("Procedure fetcher thread finished.");
            }
            this.LOG.info("Procedure fetcher thread finished.");
        };
        Thread fetcherThread = new Thread(procedureFetcher, "getProcedures-fetcher-" + catalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getProcedures");
        return resultSet;
    }

    Schema defineGetProceduresSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(9);
        fields.add(Field.newBuilder("PROCEDURE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PROCEDURE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PROCEDURE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("reserved1", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("reserved2", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("reserved3", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PROCEDURE_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SPECIFIC_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    void processProcedureInfo(Routine routine, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        RoutineId routineId = routine.getRoutineId();
        this.LOG.fine("Processing procedure info for: " + routineId);
        try {
            if (!"PROCEDURE".equalsIgnoreCase(routine.getRoutineType())) {
                this.LOG.warning("processProcedureInfo called with non-procedure type: " + routine.getRoutineType() + " for " + routineId);
                return;
            }
            String catalogName = routineId.getProject();
            String schemaName = routineId.getDataset();
            String procedureName = routineId.getRoutine();
            String remarks = routine.getDescription();
            ArrayList<FieldValue> values = new ArrayList<FieldValue>(resultSchemaFields.size());
            values.add(this.createStringFieldValue(catalogName));
            values.add(this.createStringFieldValue(schemaName));
            values.add(this.createStringFieldValue(procedureName));
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createStringFieldValue(remarks));
            values.add(this.createLongFieldValue(0L));
            values.add(this.createStringFieldValue(procedureName));
            FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
            collectedResults.add(rowFvl);
            this.LOG.fine("Processed and added procedure info row for: " + routineId);
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Error processing procedure info for %s: %s. Skipping this procedure.", routineId, e.getMessage()));
        }
    }

    Comparator<FieldValueList> defineGetProceduresComparator(FieldList resultSchemaFields) {
        int PROC_CAT_IDX = resultSchemaFields.getIndex("PROCEDURE_CAT");
        int PROC_SCHEM_IDX = resultSchemaFields.getIndex("PROCEDURE_SCHEM");
        int PROC_NAME_IDX = resultSchemaFields.getIndex("PROCEDURE_NAME");
        int SPEC_NAME_IDX = resultSchemaFields.getIndex("SPECIFIC_NAME");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_CAT_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_SCHEM_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_NAME_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, SPEC_NAME_IDX), Comparator.nullsFirst(String::compareTo));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        if (catalog == null || catalog.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet because catalog (project) is null or empty.");
            return new BigQueryJsonResultSet();
        }
        if (schemaPattern != null && schemaPattern.isEmpty() || procedureNamePattern != null && procedureNamePattern.isEmpty() || columnNamePattern != null && columnNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet because an explicit empty pattern was provided.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getProcedureColumns called for catalog: %s, schemaPattern: %s, procedureNamePattern: %s, columnNamePattern: %s", catalog, schemaPattern, procedureNamePattern, columnNamePattern));
        Pattern schemaRegex = this.compileSqlLikePattern(schemaPattern);
        Pattern procedureNameRegex = this.compileSqlLikePattern(procedureNamePattern);
        Pattern columnNameRegex = this.compileSqlLikePattern(columnNamePattern);
        Schema resultSchema = this.defineGetProcedureColumnsSchema();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        ArrayList processingTaskFutures = new ArrayList();
        String catalogParam = catalog;
        Runnable procedureColumnFetcher = () -> {
            block35: {
                block33: {
                    List<Routine> fullRoutines;
                    String fetcherThreadNameSuffix;
                    ExecutorService processArgsExecutor;
                    ExecutorService getRoutineDetailsExecutor;
                    ExecutorService listRoutinesExecutor;
                    block31: {
                        block32: {
                            List<RoutineId> procedureIdsToGet;
                            block29: {
                                block30: {
                                    List<Dataset> datasetsToScan;
                                    block27: {
                                        block28: {
                                            listRoutinesExecutor = null;
                                            getRoutineDetailsExecutor = null;
                                            processArgsExecutor = null;
                                            fetcherThreadNameSuffix = "-" + catalogParam.substring(0, Math.min(10, catalogParam.length()));
                                            datasetsToScan = this.fetchMatchingDatasetsForProcedureColumns(catalogParam, schemaPattern, schemaRegex);
                                            if (!datasetsToScan.isEmpty() && !Thread.currentThread().isInterrupted()) break block27;
                                            this.LOG.info("Fetcher: No matching datasets or interrupted early. Catalog: " + catalogParam);
                                            this.signalEndOfData(queue, resultSchema.getFields());
                                            if (listRoutinesExecutor != null) {
                                                this.shutdownExecutor(listRoutinesExecutor);
                                            }
                                            if (getRoutineDetailsExecutor != null) {
                                                this.shutdownExecutor(getRoutineDetailsExecutor);
                                            }
                                            if (processArgsExecutor == null) break block28;
                                            this.shutdownExecutor(processArgsExecutor);
                                        }
                                        this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                                        return;
                                    }
                                    listRoutinesExecutor = Executors.newFixedThreadPool(50, runnable -> new Thread(runnable, "pcol-list-rout" + fetcherThreadNameSuffix));
                                    procedureIdsToGet = this.listMatchingProcedureIdsFromDatasets(datasetsToScan, procedureNamePattern, procedureNameRegex, listRoutinesExecutor, catalogParam, this.LOG);
                                    this.shutdownExecutor(listRoutinesExecutor);
                                    listRoutinesExecutor = null;
                                    if (!procedureIdsToGet.isEmpty() && !Thread.currentThread().isInterrupted()) break block29;
                                    this.LOG.info("Fetcher: No procedure IDs found or interrupted. Catalog: " + catalogParam);
                                    this.signalEndOfData(queue, resultSchema.getFields());
                                    if (listRoutinesExecutor != null) {
                                        this.shutdownExecutor(listRoutinesExecutor);
                                    }
                                    if (getRoutineDetailsExecutor != null) {
                                        this.shutdownExecutor(getRoutineDetailsExecutor);
                                    }
                                    if (processArgsExecutor == null) break block30;
                                    this.shutdownExecutor(processArgsExecutor);
                                }
                                this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                                return;
                            }
                            getRoutineDetailsExecutor = Executors.newFixedThreadPool(100, runnable -> new Thread(runnable, "pcol-get-details" + fetcherThreadNameSuffix));
                            fullRoutines = this.fetchFullRoutineDetailsForIds(procedureIdsToGet, getRoutineDetailsExecutor, this.LOG);
                            this.shutdownExecutor(getRoutineDetailsExecutor);
                            getRoutineDetailsExecutor = null;
                            if (!fullRoutines.isEmpty() && !Thread.currentThread().isInterrupted()) break block31;
                            this.LOG.info("Fetcher: No full routines fetched or interrupted. Catalog: " + catalogParam);
                            this.signalEndOfData(queue, resultSchema.getFields());
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processArgsExecutor == null) break block32;
                            this.shutdownExecutor(processArgsExecutor);
                        }
                        this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                        return;
                    }
                    try {
                        processArgsExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount, runnable -> new Thread(runnable, "pcol-proc-args" + fetcherThreadNameSuffix));
                        this.submitProcedureArgumentProcessingJobs(fullRoutines, columnNameRegex, collectedResults, resultSchema.getFields(), processArgsExecutor, processingTaskFutures, this.LOG);
                        if (Thread.currentThread().isInterrupted()) {
                            this.LOG.warning("Fetcher: Interrupted before waiting for argument processing. Catalog: " + catalogParam);
                            processingTaskFutures.forEach(f -> f.cancel(true));
                        } else {
                            this.LOG.fine("Fetcher: Waiting for " + processingTaskFutures.size() + " argument processing tasks. Catalog: " + catalogParam);
                            this.waitForTasksCompletion(processingTaskFutures);
                            this.LOG.fine("Fetcher: All argument processing tasks completed or handled. Catalog: " + catalogParam);
                        }
                        if (!Thread.currentThread().isInterrupted()) {
                            Comparator<FieldValueList> comparator = this.defineGetProcedureColumnsComparator(resultSchema.getFields());
                            this.sortResults(collectedResults, comparator, "getProcedureColumns", this.LOG);
                            this.populateQueue(collectedResults, queue, resultSchema.getFields());
                        }
                        this.signalEndOfData(queue, resultSchema.getFields());
                        if (listRoutinesExecutor != null) {
                            this.shutdownExecutor(listRoutinesExecutor);
                        }
                        if (getRoutineDetailsExecutor != null) {
                            this.shutdownExecutor(getRoutineDetailsExecutor);
                        }
                        if (processArgsExecutor == null) break block33;
                        this.shutdownExecutor(processArgsExecutor);
                    }
                    catch (InterruptedException e) {
                        block34: {
                            Thread.currentThread().interrupt();
                            this.LOG.warning("Fetcher: Interrupted in main try block for catalog " + catalogParam + ". Error: " + e.getMessage());
                            processingTaskFutures.forEach(f -> f.cancel(true));
                            this.signalEndOfData(queue, resultSchema.getFields());
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processArgsExecutor == null) break block34;
                            this.shutdownExecutor(processArgsExecutor);
                        }
                        this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                        break block35;
                    }
                    catch (Throwable t2) {
                        block36: {
                            this.LOG.severe("Fetcher: Unexpected error in main try block for catalog " + catalogParam + ". Error: " + t2.getMessage());
                            processingTaskFutures.forEach(f -> f.cancel(true));
                            this.signalEndOfData(queue, resultSchema.getFields());
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processArgsExecutor == null) break block36;
                            this.shutdownExecutor(processArgsExecutor);
                            {
                                catch (Throwable throwable) {
                                    this.signalEndOfData(queue, resultSchema.getFields());
                                    if (listRoutinesExecutor != null) {
                                        this.shutdownExecutor(listRoutinesExecutor);
                                    }
                                    if (getRoutineDetailsExecutor != null) {
                                        this.shutdownExecutor(getRoutineDetailsExecutor);
                                    }
                                    if (processArgsExecutor != null) {
                                        this.shutdownExecutor(processArgsExecutor);
                                    }
                                    this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                                    throw throwable;
                                }
                            }
                        }
                        this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
                    }
                }
                this.LOG.info("Procedure column fetcher thread finished for catalog: " + catalogParam);
            }
        };
        Thread fetcherThread = new Thread(procedureColumnFetcher, "getProcedureColumns-fetcher-" + catalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getProcedureColumns for catalog: " + catalog);
        return resultSet;
    }

    private List<Dataset> fetchMatchingDatasetsForProcedureColumns(String catalogParam, String schemaPattern, Pattern schemaRegex) throws InterruptedException {
        this.LOG.fine(String.format("Fetching matching datasets for catalog '%s', schemaPattern '%s'", catalogParam, schemaPattern));
        List<Dataset> datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaPattern, schemaRegex, this.LOG);
        this.LOG.info(String.format("Found %d datasets to scan for procedures in catalog '%s'.", datasetsToScan.size(), catalogParam));
        return datasetsToScan;
    }

    List<RoutineId> listMatchingProcedureIdsFromDatasets(List<Dataset> datasetsToScan, String procedureNamePattern, Pattern procedureNameRegex, ExecutorService listRoutinesExecutor, String catalogParam, BigQueryJdbcCustomLogger logger) throws InterruptedException {
        logger.fine(String.format("Listing matching procedure IDs from %d datasets for catalog '%s'.", datasetsToScan.size(), catalogParam));
        ArrayList<Future<List>> listRoutineFutures = new ArrayList<Future<List>>();
        List<RoutineId> procedureIdsToGet = Collections.synchronizedList(new ArrayList());
        for (Dataset dataset : datasetsToScan) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted during submission of routine listing tasks for catalog: " + catalogParam);
                throw new InterruptedException("Interrupted while listing routines");
            }
            DatasetId currentDatasetId = dataset.getDatasetId();
            Callable<List> listCallable = () -> this.findMatchingBigQueryObjects("Routine", () -> this.bigquery.listRoutines(currentDatasetId, BigQuery.RoutineListOption.pageSize(500L)), name -> this.bigquery.getRoutine(RoutineId.of(currentDatasetId.getProject(), currentDatasetId.getDataset(), name), new BigQuery.RoutineOption[0]), rt -> rt.getRoutineId().getRoutine(), procedureNamePattern, procedureNameRegex, logger);
            listRoutineFutures.add(listRoutinesExecutor.submit(listCallable));
        }
        logger.fine("Submitted " + listRoutineFutures.size() + " routine list tasks for catalog: " + catalogParam);
        for (Future future : listRoutineFutures) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted while collecting routine list results for catalog: " + catalogParam);
                listRoutineFutures.forEach(f -> f.cancel(true));
                throw new InterruptedException("Interrupted while collecting routine lists");
            }
            try {
                List listedRoutines = (List)future.get();
                if (listedRoutines == null) continue;
                for (Routine listedRoutine : listedRoutines) {
                    if (listedRoutine == null || !"PROCEDURE".equalsIgnoreCase(listedRoutine.getRoutineType())) continue;
                    if (listedRoutine.getRoutineId() != null) {
                        procedureIdsToGet.add(listedRoutine.getRoutineId());
                        continue;
                    }
                    logger.warning("Found a procedure type routine with a null ID during listing phase for catalog: " + catalogParam);
                }
            }
            catch (ExecutionException e) {
                logger.warning("Error getting routine list result for catalog " + catalogParam + ": " + e.getCause());
            }
            catch (CancellationException e) {
                logger.warning("Routine list task cancelled for catalog: " + catalogParam);
            }
        }
        logger.info(String.format("Found %d procedure IDs to fetch details for in catalog '%s'.", procedureIdsToGet.size(), catalogParam));
        return procedureIdsToGet;
    }

    List<Routine> fetchFullRoutineDetailsForIds(List<RoutineId> procedureIdsToGet, ExecutorService getRoutineDetailsExecutor, BigQueryJdbcCustomLogger logger) throws InterruptedException {
        logger.fine(String.format("Fetching full details for %d procedure IDs.", procedureIdsToGet.size()));
        ArrayList<Future<Routine>> getRoutineFutures = new ArrayList<Future<Routine>>();
        List<Routine> fullRoutines = Collections.synchronizedList(new ArrayList());
        for (RoutineId routineId : procedureIdsToGet) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted during submission of getRoutine detail tasks.");
                throw new InterruptedException("Interrupted while submitting getRoutine tasks");
            }
            RoutineId currentProcId = routineId;
            Callable<Routine> getCallable = () -> {
                try {
                    return this.bigquery.getRoutine(currentProcId, new BigQuery.RoutineOption[0]);
                }
                catch (Exception e) {
                    logger.warning("Failed to get full details for routine " + currentProcId + ": " + e.getMessage());
                    return null;
                }
            };
            getRoutineFutures.add(getRoutineDetailsExecutor.submit(getCallable));
        }
        logger.fine("Submitted " + getRoutineFutures.size() + " getRoutine detail tasks.");
        for (Future future : getRoutineFutures) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted while collecting getRoutine detail results.");
                getRoutineFutures.forEach(f -> f.cancel(true));
                throw new InterruptedException("Interrupted while collecting Routine details");
            }
            try {
                Routine fullRoutine = (Routine)future.get();
                if (fullRoutine == null) continue;
                fullRoutines.add(fullRoutine);
            }
            catch (ExecutionException e) {
                logger.warning("Error processing getRoutine future result: " + e.getCause());
            }
            catch (CancellationException e) {
                logger.warning("getRoutine detail task cancelled.");
            }
        }
        logger.info(String.format("Successfully fetched full details for %d routines.", fullRoutines.size()));
        return fullRoutines;
    }

    void submitProcedureArgumentProcessingJobs(List<Routine> fullRoutines, Pattern columnNameRegex, List<FieldValueList> collectedResults, FieldList resultSchemaFields, ExecutorService processArgsExecutor, List<Future<?>> outArgumentProcessingFutures, BigQueryJdbcCustomLogger logger) throws InterruptedException {
        logger.fine(String.format("Submitting argument processing jobs for %d routines.", fullRoutines.size()));
        for (Routine fullRoutine : fullRoutines) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted during submission of argument processing tasks.");
                throw new InterruptedException("Interrupted while submitting argument processing jobs");
            }
            if (fullRoutine == null) continue;
            if ("PROCEDURE".equalsIgnoreCase(fullRoutine.getRoutineType())) {
                Routine finalFullRoutine = fullRoutine;
                Future<?> processFuture = processArgsExecutor.submit(() -> this.processProcedureArguments(finalFullRoutine, columnNameRegex, collectedResults, resultSchemaFields));
                outArgumentProcessingFutures.add(processFuture);
                continue;
            }
            logger.warning("Routine " + (fullRoutine.getRoutineId() != null ? fullRoutine.getRoutineId().toString() : "UNKNOWN_ID") + " fetched via getRoutine was not of type PROCEDURE (Type: " + fullRoutine.getRoutineType() + "). Skipping argument processing.");
        }
        logger.fine("Finished submitting " + outArgumentProcessingFutures.size() + " processProcedureArguments tasks.");
    }

    Schema defineGetProcedureColumnsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(20);
        fields.add(Field.newBuilder("PROCEDURE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PROCEDURE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PROCEDURE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("PRECISION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCALE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NULLABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("COLUMN_DEF", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATETIME_SUB", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CHAR_OCTET_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ORDINAL_POSITION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_NULLABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SPECIFIC_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    void processProcedureArguments(Routine routine, Pattern columnNameRegex, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        String procedureName;
        List<RoutineArgument> arguments;
        RoutineId routineId = routine.getRoutineId();
        try {
            arguments = routine.getArguments();
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Could not retrieve arguments list for procedure %s: %s. No arguments will be processed.", routineId, e.getMessage()));
            return;
        }
        if (arguments == null || arguments.isEmpty()) {
            this.LOG.fine("Procedure " + routineId + " has no arguments.");
            return;
        }
        String catalogName = routineId.getProject();
        String schemaName = routineId.getDataset();
        String specificName = procedureName = routineId.getRoutine();
        for (int i = 0; i < arguments.size(); ++i) {
            String argName;
            RoutineArgument arg;
            if (Thread.currentThread().isInterrupted()) {
                this.LOG.warning("Argument processing task interrupted for " + routineId);
                break;
            }
            int ordinalPosition = i + 1;
            try {
                arg = arguments.get(i);
                argName = arg.getName();
            }
            catch (Exception listAccessException) {
                this.LOG.warning(String.format("Exception during arguments.get(%d) for Proc: %s. Ordinal: %d. Message: %s. Generating fallback row.", i, routineId, ordinalPosition, listAccessException.getMessage()));
                argName = "arg_retrieval_err_" + ordinalPosition;
                arg = null;
            }
            if (columnNameRegex != null) {
                assert (argName != null);
                if (!argName.startsWith("arg_") && !columnNameRegex.matcher(argName).matches()) continue;
            }
            List<FieldValue> values = this.createProcedureColumnRow(catalogName, schemaName, procedureName, specificName, arg, ordinalPosition, argName);
            FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
            collectedResults.add(rowFvl);
        }
    }

    List<FieldValue> createProcedureColumnRow(String catalog, String schemaName, String procedureName, String specificName, @Nullable RoutineArgument argument, int ordinalPosition, String columnName) {
        ColumnTypeInfo typeInfo;
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(20);
        if (argument == null) {
            this.LOG.warning(String.format("Proc: %s, Arg: %s (Pos %d) - RoutineArgument object is null. Defaulting type to VARCHAR.", procedureName, columnName, ordinalPosition));
            typeInfo = new ColumnTypeInfo(12, "VARCHAR", null, null, null);
        } else {
            try {
                StandardSQLDataType argumentDataType = argument.getDataType();
                if (argumentDataType == null) {
                    this.LOG.warning(String.format("Proc: %s, Arg: %s (Pos %d) - argument.getDataType() returned null. Defaulting type to VARCHAR.", procedureName, columnName, ordinalPosition));
                    typeInfo = new ColumnTypeInfo(12, "VARCHAR", null, null, null);
                } else {
                    typeInfo = this.determineTypeInfoFromDataType(argumentDataType, procedureName, columnName, ordinalPosition);
                }
            }
            catch (Exception e) {
                this.LOG.warning(String.format("Proc: %s, Arg: %s (Pos %d) - Unexpected Exception during type processing. Defaulting type to VARCHAR. Error: %s", procedureName, columnName, ordinalPosition, e.getMessage()));
                typeInfo = new ColumnTypeInfo(12, "VARCHAR", null, null, null);
            }
        }
        String argumentModeStr = null;
        if (argument != null) {
            try {
                argumentModeStr = argument.getMode();
            }
            catch (Exception e) {
                this.LOG.warning(String.format("Proc: %s, Arg: %s (Pos %d) - Could not get argument mode. Error: %s", procedureName, columnName, ordinalPosition, e.getMessage()));
            }
        }
        values.add(this.createStringFieldValue(catalog));
        values.add(this.createStringFieldValue(schemaName));
        values.add(this.createStringFieldValue(procedureName));
        values.add(this.createStringFieldValue(columnName));
        long columnTypeJdbc = 0L;
        if ("IN".equalsIgnoreCase(argumentModeStr)) {
            columnTypeJdbc = 1L;
        } else if ("OUT".equalsIgnoreCase(argumentModeStr)) {
            columnTypeJdbc = 4L;
        } else if ("INOUT".equalsIgnoreCase(argumentModeStr)) {
            columnTypeJdbc = 2L;
        }
        values.add(this.createLongFieldValue(columnTypeJdbc));
        values.add(this.createLongFieldValue(Long.valueOf(typeInfo.jdbcType)));
        values.add(this.createStringFieldValue(typeInfo.typeName));
        values.add(this.createLongFieldValue(typeInfo.columnSize == null ? null : Long.valueOf(typeInfo.columnSize.longValue())));
        values.add(this.createNullFieldValue());
        values.add(this.createLongFieldValue(typeInfo.decimalDigits == null ? null : Long.valueOf(typeInfo.decimalDigits.longValue())));
        values.add(this.createLongFieldValue(typeInfo.numPrecRadix == null ? null : Long.valueOf(typeInfo.numPrecRadix.longValue())));
        values.add(this.createLongFieldValue(1L));
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createLongFieldValue(Long.valueOf(ordinalPosition)));
        values.add(this.createStringFieldValue("YES"));
        values.add(this.createStringFieldValue(specificName));
        return values;
    }

    ColumnTypeInfo determineTypeInfoFromDataType(StandardSQLDataType argumentDataType, String procedureName, String columnName, int ordinalPosition) {
        ColumnTypeInfo defaultVarcharTypeInfo = new ColumnTypeInfo(12, "VARCHAR", null, null, null);
        try {
            String typeKind = argumentDataType.getTypeKind();
            if (typeKind != null && !typeKind.isEmpty()) {
                if ("ARRAY".equalsIgnoreCase(typeKind)) {
                    return new ColumnTypeInfo(2003, "ARRAY", null, null, null);
                }
                StandardSQLTypeName determinedType = StandardSQLTypeName.valueOf(typeKind.toUpperCase());
                return this.getColumnTypeInfoForSqlType(determinedType);
            }
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Proc: %s, Arg: %s (Pos %d) - Caught an unexpected Exception during type determination. Defaulting type to VARCHAR. Error: %s", procedureName, columnName, ordinalPosition, e.getMessage()));
        }
        return defaultVarcharTypeInfo;
    }

    Comparator<FieldValueList> defineGetProcedureColumnsComparator(FieldList resultSchemaFields) {
        int PROC_CAT_IDX = resultSchemaFields.getIndex("PROCEDURE_CAT");
        int PROC_SCHEM_IDX = resultSchemaFields.getIndex("PROCEDURE_SCHEM");
        int PROC_NAME_IDX = resultSchemaFields.getIndex("PROCEDURE_NAME");
        int SPEC_NAME_IDX = resultSchemaFields.getIndex("SPECIFIC_NAME");
        int COL_NAME_IDX = resultSchemaFields.getIndex("COLUMN_NAME");
        if (PROC_CAT_IDX < 0 || PROC_SCHEM_IDX < 0 || PROC_NAME_IDX < 0 || SPEC_NAME_IDX < 0 || COL_NAME_IDX < 0) {
            this.LOG.severe("Could not find required columns (PROCEDURE_CAT, SCHEM, NAME, SPECIFIC_NAME, COLUMN_NAME) in getProcedureColumns schema for sorting. Returning null comparator.");
            return null;
        }
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_CAT_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_SCHEM_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, PROC_NAME_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, SPEC_NAME_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, COL_NAME_IDX), Comparator.nullsFirst(String::compareToIgnoreCase));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        Tuple<String, String> effectiveIdentifiers = this.determineEffectiveCatalogAndSchema(catalog, schemaPattern);
        String effectiveCatalog = effectiveIdentifiers.x();
        String effectiveSchemaPattern = effectiveIdentifiers.y();
        if (effectiveCatalog == null || effectiveCatalog.isEmpty() || effectiveSchemaPattern != null && effectiveSchemaPattern.isEmpty() || tableNamePattern != null && tableNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet as one or more patterns are empty or catalog is null.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getTables called for catalog: %s, schemaPattern: %s, tableNamePattern: %s, types: %s", effectiveCatalog, effectiveSchemaPattern, tableNamePattern, Arrays.toString(types)));
        Pattern schemaRegex = this.compileSqlLikePattern(effectiveSchemaPattern);
        Pattern tableNameRegex = this.compileSqlLikePattern(tableNamePattern);
        HashSet<String> requestedTypes = types == null || types.length == 0 ? null : new HashSet<String>(Arrays.asList(types));
        Schema resultSchema = this.defineGetTablesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        String catalogParam = effectiveCatalog;
        String schemaParam = effectiveSchemaPattern;
        Runnable tableFetcher = () -> {
            List<Dataset> datasetsToScan;
            ArrayList processingFutures;
            ArrayList<Future<List>> apiFutures;
            FieldList localResultSchemaFields;
            ExecutorService tableProcessorExecutor;
            ExecutorService apiExecutor;
            block18: {
                apiExecutor = null;
                tableProcessorExecutor = null;
                localResultSchemaFields = resultSchemaFields;
                apiFutures = new ArrayList<Future<List>>();
                processingFutures = new ArrayList();
                datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaParam, schemaRegex, this.LOG);
                if (!datasetsToScan.isEmpty()) break block18;
                this.LOG.info("Fetcher thread found no matching datasets. Returning empty resultset.");
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(tableProcessorExecutor);
                this.LOG.info("Table fetcher thread finished.");
                return;
            }
            try {
                apiExecutor = Executors.newFixedThreadPool(50);
                tableProcessorExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount);
                this.LOG.fine("Submitting parallel findMatchingTables tasks...");
                for (Dataset dataset : datasetsToScan) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Table fetcher interrupted during dataset iteration.");
                        break;
                    }
                    DatasetId currentDatasetId = dataset.getDatasetId();
                    Callable<List> apiCallable = () -> this.findMatchingBigQueryObjects("Table", () -> this.bigquery.listTables(currentDatasetId, BigQuery.TableListOption.pageSize(500L)), name -> this.bigquery.getTable(TableId.of(currentDatasetId.getProject(), currentDatasetId.getDataset(), name), new BigQuery.TableOption[0]), tbl -> tbl.getTableId().getTable(), tableNamePattern, tableNameRegex, this.LOG);
                    Future<List> apiFuture = apiExecutor.submit(apiCallable);
                    apiFutures.add(apiFuture);
                }
                this.LOG.fine("Finished submitting " + apiFutures.size() + " findMatchingTables tasks.");
                apiExecutor.shutdown();
                this.LOG.fine("Processing results from findMatchingTables tasks...");
                block10: for (Future future : apiFutures) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Table fetcher interrupted while processing API futures.");
                        break;
                    }
                    try {
                        List tablesResult = (List)future.get();
                        if (tablesResult == null) continue;
                        for (Table table : tablesResult) {
                            if (Thread.currentThread().isInterrupted()) continue block10;
                            Table currentTable = table;
                            Future<?> processFuture = tableProcessorExecutor.submit(() -> this.processTableInfo(currentTable, requestedTypes, collectedResults, localResultSchemaFields));
                            processingFutures.add(processFuture);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.LOG.warning("Fetcher thread interrupted while waiting for API future result.");
                        break;
                    }
                    catch (ExecutionException e) {
                        this.LOG.warning("Error executing findMatchingTables task: " + e.getMessage() + ". Cause: " + e.getCause());
                    }
                    catch (CancellationException e) {
                        this.LOG.warning("A findMatchingTables task was cancelled.");
                    }
                }
                this.LOG.fine("Finished submitting " + processingFutures.size() + " processTableInfo tasks.");
                if (Thread.currentThread().isInterrupted()) {
                    this.LOG.warning("Fetcher interrupted before waiting for processing tasks; cancelling remaining.");
                    processingFutures.forEach(f -> f.cancel(true));
                } else {
                    this.LOG.fine("Waiting for processTableInfo tasks to complete...");
                    this.waitForTasksCompletion(processingFutures);
                    this.LOG.fine("All processTableInfo tasks completed.");
                }
                if (!Thread.currentThread().isInterrupted()) {
                    Comparator<FieldValueList> comparator = this.defineGetTablesComparator(localResultSchemaFields);
                    this.sortResults(collectedResults, comparator, "getTables", this.LOG);
                }
                if (!Thread.currentThread().isInterrupted()) {
                    this.populateQueue(collectedResults, queue, localResultSchemaFields);
                }
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(tableProcessorExecutor);
            }
            catch (Throwable t2) {
                try {
                    this.LOG.severe("Unexpected error in table fetcher runnable: " + t2.getMessage());
                    apiFutures.forEach(f -> f.cancel(true));
                    processingFutures.forEach(f -> f.cancel(true));
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(tableProcessorExecutor);
                }
                catch (Throwable throwable) {
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(tableProcessorExecutor);
                    this.LOG.info("Table fetcher thread finished.");
                    throw throwable;
                }
                this.LOG.info("Table fetcher thread finished.");
            }
            this.LOG.info("Table fetcher thread finished.");
        };
        Thread fetcherThread = new Thread(tableFetcher, "getTables-fetcher-" + effectiveCatalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getTables");
        return resultSet;
    }

    Schema defineGetTablesSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TABLE_TYPE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SELF_REFERENCING_COL_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("REF_GENERATION", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    void processTableInfo(Table table, Set<String> requestedTypes, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        TableId tableId = table.getTableId();
        this.LOG.fine("Processing table info for: " + tableId);
        try {
            String catalogName = tableId.getProject();
            String schemaName = tableId.getDataset();
            String tableName = tableId.getTable();
            Object definition = table.getDefinition();
            String bqTableType = ((TableDefinition)definition).getType().toString();
            String remarks = table.getDescription();
            if (requestedTypes != null && !requestedTypes.contains(bqTableType)) {
                this.LOG.finer(String.format("Skipping table %s as its type '%s' is not in the requested types %s", tableId, bqTableType, requestedTypes));
                return;
            }
            ArrayList<FieldValue> values = new ArrayList<FieldValue>(resultSchemaFields.size());
            values.add(this.createStringFieldValue(catalogName));
            values.add(this.createStringFieldValue(schemaName));
            values.add(this.createStringFieldValue(tableName));
            values.add(this.createStringFieldValue(bqTableType));
            values.add(this.createStringFieldValue(remarks));
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
            collectedResults.add(rowFvl);
            this.LOG.fine("Processed and added table info row for: " + tableId);
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Error processing table info for %s: %s. Skipping this table.", tableId, e.getMessage()));
        }
    }

    Comparator<FieldValueList> defineGetTablesComparator(FieldList resultSchemaFields) {
        int TABLE_TYPE_IDX = resultSchemaFields.getIndex("TABLE_TYPE");
        int TABLE_CAT_IDX = resultSchemaFields.getIndex("TABLE_CAT");
        int TABLE_SCHEM_IDX = resultSchemaFields.getIndex("TABLE_SCHEM");
        int TABLE_NAME_IDX = resultSchemaFields.getIndex("TABLE_NAME");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_TYPE_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_CAT_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_SCHEM_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_NAME_IDX), Comparator.nullsFirst(String::compareTo));
    }

    @Override
    public ResultSet getSchemas() {
        this.LOG.info("getSchemas() called");
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() {
        this.LOG.info("getCatalogs() called");
        List<String> accessibleCatalogs = this.getAccessibleCatalogNames();
        Schema catalogsSchema = this.defineGetCatalogsSchema();
        FieldList schemaFields = catalogsSchema.getFields();
        List<FieldValueList> catalogRows = this.prepareGetCatalogsRows(schemaFields, accessibleCatalogs);
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(catalogRows.isEmpty() ? 1 : catalogRows.size() + 1);
        this.populateQueue(catalogRows, queue, schemaFields);
        this.signalEndOfData(queue, schemaFields);
        return BigQueryJsonResultSet.of(catalogsSchema, catalogRows.size(), queue, this.statement, new Thread[0]);
    }

    Schema defineGetCatalogsSchema() {
        return Schema.of(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
    }

    List<FieldValueList> prepareGetCatalogsRows(FieldList schemaFields, List<String> accessibleCatalogs) {
        ArrayList<FieldValueList> catalogRows = new ArrayList<FieldValueList>();
        for (String catalogName : accessibleCatalogs) {
            FieldValue fieldValue = FieldValue.of(FieldValue.Attribute.PRIMITIVE, catalogName);
            catalogRows.add(FieldValueList.of(Collections.singletonList(fieldValue), schemaFields));
        }
        return catalogRows;
    }

    @Override
    public ResultSet getTableTypes() {
        this.LOG.info("getTableTypes() called");
        Schema tableTypesSchema = BigQueryDatabaseMetaData.defineGetTableTypesSchema();
        List<FieldValueList> tableTypeRows = BigQueryDatabaseMetaData.prepareGetTableTypesRows(tableTypesSchema);
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(tableTypeRows.size() + 1);
        this.populateQueue(tableTypeRows, queue, tableTypesSchema.getFields());
        this.signalEndOfData(queue, tableTypesSchema.getFields());
        return BigQueryJsonResultSet.of(tableTypesSchema, tableTypeRows.size(), queue, this.statement, new Thread[0]);
    }

    static Schema defineGetTableTypesSchema() {
        return Schema.of(Field.newBuilder("TABLE_TYPE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
    }

    static List<FieldValueList> prepareGetTableTypesRows(Schema schema) {
        String[] tableTypes = new String[]{"EXTERNAL", "MATERIALIZED VIEW", "SNAPSHOT", "TABLE", "VIEW"};
        ArrayList<FieldValueList> rows = new ArrayList<FieldValueList>(tableTypes.length);
        FieldList schemaFields = schema.getFields();
        for (String typeName : tableTypes) {
            FieldValue fieldValue = FieldValue.of(FieldValue.Attribute.PRIMITIVE, typeName);
            rows.add(FieldValueList.of(Collections.singletonList(fieldValue), schemaFields));
        }
        return rows;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        Tuple<String, String> effectiveIdentifiers = this.determineEffectiveCatalogAndSchema(catalog, schemaPattern);
        String effectiveCatalog = effectiveIdentifiers.x();
        String effectiveSchemaPattern = effectiveIdentifiers.y();
        if (effectiveCatalog == null || effectiveCatalog.isEmpty() || effectiveSchemaPattern != null && effectiveSchemaPattern.isEmpty() || tableNamePattern != null && tableNamePattern.isEmpty() || columnNamePattern != null && columnNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet as one or more patterns are empty or catalog is null.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getColumns called for catalog: %s, schemaPattern: %s, tableNamePattern: %s, columnNamePattern: %s", effectiveCatalog, effectiveSchemaPattern, tableNamePattern, columnNamePattern));
        Pattern schemaRegex = this.compileSqlLikePattern(effectiveSchemaPattern);
        Pattern tableNameRegex = this.compileSqlLikePattern(tableNamePattern);
        Pattern columnNameRegex = this.compileSqlLikePattern(columnNamePattern);
        Schema resultSchema = this.defineGetColumnsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        String catalogParam = effectiveCatalog;
        String schemaParam = effectiveSchemaPattern;
        Runnable columnFetcher = () -> {
            List<Dataset> datasetsToScan;
            FieldList localResultSchemaFields;
            ArrayList taskFutures;
            ExecutorService columnExecutor;
            block11: {
                columnExecutor = null;
                taskFutures = new ArrayList();
                localResultSchemaFields = resultSchemaFields;
                datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaParam, schemaRegex, this.LOG);
                if (!datasetsToScan.isEmpty()) break block11;
                this.LOG.info("Fetcher thread found no matching datasets. Returning empty resultset.");
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(columnExecutor);
                this.LOG.info("Column fetcher thread finished.");
                return;
            }
            try {
                columnExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount);
                for (Dataset dataset : datasetsToScan) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Fetcher interrupted during dataset iteration.");
                        break;
                    }
                    DatasetId datasetId = dataset.getDatasetId();
                    this.LOG.info("Processing dataset: " + datasetId.getDataset());
                    List<Table> tablesToScan = this.findMatchingBigQueryObjects("Table", () -> this.bigquery.listTables(datasetId, BigQuery.TableListOption.pageSize(500L)), name -> this.bigquery.getTable(TableId.of(datasetId.getProject(), datasetId.getDataset(), name), new BigQuery.TableOption[0]), tbl -> tbl.getTableId().getTable(), tableNamePattern, tableNameRegex, this.LOG);
                    for (Table table : tablesToScan) {
                        if (Thread.currentThread().isInterrupted()) {
                            this.LOG.warning("Fetcher interrupted during table iteration for dataset " + datasetId.getDataset());
                            break;
                        }
                        TableId tableId = table.getTableId();
                        this.LOG.fine("Submitting task for table: " + tableId);
                        Table finalTable = table;
                        Future<?> future = columnExecutor.submit(() -> this.processTableColumns(finalTable, columnNameRegex, collectedResults, localResultSchemaFields));
                        taskFutures.add(future);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
                this.waitForTasksCompletion(taskFutures);
                if (!Thread.currentThread().isInterrupted()) {
                    Comparator<FieldValueList> comparator = this.defineGetColumnsComparator(localResultSchemaFields);
                    this.sortResults(collectedResults, comparator, "getColumns", this.LOG);
                }
                if (!Thread.currentThread().isInterrupted()) {
                    this.populateQueue(collectedResults, queue, localResultSchemaFields);
                }
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(columnExecutor);
            }
            catch (Throwable t2) {
                try {
                    this.LOG.severe("Unexpected error in column fetcher runnable: " + t2.getMessage());
                    taskFutures.forEach(f -> f.cancel(true));
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(columnExecutor);
                }
                catch (Throwable throwable) {
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(columnExecutor);
                    this.LOG.info("Column fetcher thread finished.");
                    throw throwable;
                }
                this.LOG.info("Column fetcher thread finished.");
            }
            this.LOG.info("Column fetcher thread finished.");
        };
        Thread fetcherThread = new Thread(columnFetcher, "getColumns-fetcher-" + effectiveCatalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, null, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getColumns");
        return resultSet;
    }

    private void processTableColumns(Table table, Pattern columnNameRegex, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        TableId tableId = table.getTableId();
        this.LOG.fine("Processing columns for table: " + tableId);
        Object definition = table.getDefinition();
        Schema tableSchema = definition != null ? ((TableDefinition)definition).getSchema() : null;
        try {
            if (tableSchema == null) {
                this.LOG.fine("Schema not included in table object for " + tableId + ", fetching full table details...");
                Table fullTable = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
                if (fullTable != null) {
                    definition = fullTable.getDefinition();
                    tableSchema = definition != null ? ((TableDefinition)definition).getSchema() : null;
                } else {
                    this.LOG.warning("Table " + tableId + " not found when fetching full details for columns. Skipping.");
                    return;
                }
            }
            if (tableSchema == null || tableSchema.getFields() == null || tableSchema.getFields().isEmpty()) {
                this.LOG.warning(String.format("Schema not found or fields are null for table %s (Type: %s). Skipping columns.", tableId, ((TableDefinition)definition).getType()));
                return;
            }
            FieldList fields = tableSchema.getFields();
            String catalogName = tableId.getProject();
            String schemaName = tableId.getDataset();
            String tableName = tableId.getTable();
            for (int i = 0; i < fields.size(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    this.LOG.warning("Task for table " + tableId + " interrupted during column iteration.");
                    break;
                }
                Field field = fields.get(i);
                String currentColumnName = field.getName();
                if (columnNameRegex != null && !columnNameRegex.matcher(currentColumnName).matches()) continue;
                List<FieldValue> values = this.createColumnRow(catalogName, schemaName, tableName, field, i + 1);
                FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
                collectedResults.add(rowFvl);
            }
            this.LOG.fine("Finished processing columns for table: " + tableId);
        }
        catch (BigQueryException e) {
            this.LOG.warning(String.format("BigQueryException processing table %s: %s (Code: %d)", tableId, e.getMessage(), e.getCode()));
        }
        catch (Exception e) {
            this.LOG.severe(String.format("Unexpected error processing table %s: %s", tableId, e.getMessage()));
        }
    }

    private Schema defineGetColumnsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(24);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_SIZE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("BUFFER_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("DECIMAL_DIGITS", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NUM_PREC_RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NULLABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("COLUMN_DEF", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATETIME_SUB", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CHAR_OCTET_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ORDINAL_POSITION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_NULLABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SCOPE_CATALOG", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCOPE_SCHEMA", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCOPE_TABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SOURCE_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("IS_AUTOINCREMENT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_GENERATEDCOLUMN", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    List<FieldValue> createColumnRow(String catalog, String schemaName, String tableName, Field field, int ordinalPosition) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(24);
        Field.Mode mode = field.getMode() == null ? Field.Mode.NULLABLE : field.getMode();
        ColumnTypeInfo typeInfo = this.mapBigQueryTypeToJdbc(field);
        values.add(this.createStringFieldValue(catalog));
        values.add(this.createStringFieldValue(schemaName));
        values.add(this.createStringFieldValue(tableName));
        values.add(this.createStringFieldValue(field.getName()));
        values.add(this.createLongFieldValue(Long.valueOf(typeInfo.jdbcType)));
        values.add(this.createStringFieldValue(typeInfo.typeName));
        values.add(this.createLongFieldValue(typeInfo.columnSize == null ? null : Long.valueOf(typeInfo.columnSize.longValue())));
        values.add(this.createNullFieldValue());
        values.add(this.createLongFieldValue(typeInfo.decimalDigits == null ? null : Long.valueOf(typeInfo.decimalDigits.longValue())));
        values.add(this.createLongFieldValue(typeInfo.numPrecRadix == null ? null : Long.valueOf(typeInfo.numPrecRadix.longValue())));
        int nullable = mode == Field.Mode.REQUIRED ? 0 : 1;
        values.add(this.createLongFieldValue(Long.valueOf(nullable)));
        values.add(this.createStringFieldValue(field.getDescription()));
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createLongFieldValue(Long.valueOf(ordinalPosition)));
        String isNullable = "";
        switch (mode) {
            case REQUIRED: {
                isNullable = "NO";
                break;
            }
            case NULLABLE: 
            case REPEATED: {
                isNullable = "YES";
            }
        }
        values.add(this.createStringFieldValue(isNullable));
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createNullFieldValue());
        values.add(this.createStringFieldValue("NO"));
        values.add(this.createStringFieldValue("NO"));
        return values;
    }

    ColumnTypeInfo mapBigQueryTypeToJdbc(Field field) {
        Field.Mode mode;
        Field.Mode mode2 = mode = field.getMode() == null ? Field.Mode.NULLABLE : field.getMode();
        if (mode == Field.Mode.REPEATED) {
            return new ColumnTypeInfo(2003, "ARRAY", null, null, null);
        }
        StandardSQLTypeName bqType = null;
        if (field.getType() != null && field.getType().getStandardType() != null) {
            bqType = field.getType().getStandardType();
        }
        return this.getColumnTypeInfoForSqlType(bqType);
    }

    private Comparator<FieldValueList> defineGetColumnsComparator(FieldList resultSchemaFields) {
        int TABLE_CAT_IDX = resultSchemaFields.getIndex("TABLE_CAT");
        int TABLE_SCHEM_IDX = resultSchemaFields.getIndex("TABLE_SCHEM");
        int TABLE_NAME_IDX = resultSchemaFields.getIndex("TABLE_NAME");
        int ORDINAL_POS_IDX = resultSchemaFields.getIndex("ORDINAL_POSITION");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_CAT_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_SCHEM_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_NAME_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getLongValueOrNull((FieldValueList)fvl, ORDINAL_POS_IDX), Comparator.nullsFirst(Long::compareTo));
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        this.LOG.info(String.format("getColumnPrivileges called for catalog: %s, schema: %s, table: %s, columnNamePattern: %s. BigQuery IAM model differs from SQL privileges; returning empty ResultSet.", catalog, schema, table, columnNamePattern));
        Schema resultSchema = this.defineGetColumnPrivilegesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetColumnPrivilegesSchema() {
        List<Field> fields = this.defineBasePrivilegeFields();
        Field columnNameField = Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build();
        fields.add(3, columnNameField);
        return Schema.of(fields);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        this.LOG.info(String.format("getTablePrivileges called for catalog: %s, schemaPattern: %s, tableNamePattern: %s. BigQuery IAM model differs from SQL privileges; returning empty ResultSet.", catalog, schemaPattern, tableNamePattern));
        Schema resultSchema = this.defineGetTablePrivilegesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetTablePrivilegesSchema() {
        List<Field> fields = this.defineBasePrivilegeFields();
        return Schema.of(fields);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        this.LOG.info(String.format("getBestRowIdentifier called for catalog: %s, schema: %s, table: %s, scope: %d, nullable: %s. BigQuery does not support best row identifiers; returning empty ResultSet.", catalog, schema, table, scope, nullable));
        Schema resultSchema = this.defineGetBestRowIdentifierSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetBestRowIdentifierSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(8);
        fields.add(Field.newBuilder("SCOPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_SIZE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("BUFFER_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("DECIMAL_DIGITS", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PSEUDO_COLUMN", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        this.LOG.info(String.format("getVersionColumns called for catalog: %s, schema: %s, table: %s. Automatic version columns not supported by BigQuery; returning empty ResultSet.", catalog, schema, table));
        Schema resultSchema = this.defineGetVersionColumnsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetVersionColumnsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(8);
        fields.add(Field.newBuilder("SCOPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_SIZE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("BUFFER_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DECIMAL_DIGITS", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PSEUDO_COLUMN", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sql = BigQueryDatabaseMetaData.readSqlFromFile(GET_PRIMARY_KEYS_SQL);
        try {
            String formattedSql = this.replaceSqlParameters(sql, catalog, schema, table);
            return this.statement.executeQuery(formattedSql);
        }
        catch (SQLException e) {
            throw new BigQueryJdbcException(e);
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String sql = BigQueryDatabaseMetaData.readSqlFromFile(GET_IMPORTED_KEYS_SQL);
        try {
            String formattedSql = this.replaceSqlParameters(sql, catalog, schema, table);
            return this.statement.executeQuery(formattedSql);
        }
        catch (SQLException e) {
            throw new BigQueryJdbcException(e);
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String sql = BigQueryDatabaseMetaData.readSqlFromFile(GET_EXPORTED_KEYS_SQL);
        try {
            String formattedSql = this.replaceSqlParameters(sql, catalog, schema, table);
            return this.statement.executeQuery(formattedSql);
        }
        catch (SQLException e) {
            throw new BigQueryJdbcException(e);
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String sql = BigQueryDatabaseMetaData.readSqlFromFile(GET_CROSS_REFERENCE_SQL);
        try {
            String formattedSql = this.replaceSqlParameters(sql, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            return this.statement.executeQuery(formattedSql);
        }
        catch (SQLException e) {
            throw new BigQueryJdbcException(e);
        }
    }

    @Override
    public ResultSet getTypeInfo() {
        this.LOG.info("getTypeInfo() called");
        Schema typeInfoSchema = this.defineGetTypeInfoSchema();
        FieldList schemaFields = typeInfoSchema.getFields();
        List<FieldValueList> typeInfoRows = this.prepareGetTypeInfoRows(schemaFields);
        Comparator<FieldValueList> comparator = this.defineGetTypeInfoComparator(schemaFields);
        this.sortResults(typeInfoRows, comparator, "getTypeInfo", this.LOG);
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(typeInfoRows.size() + 1);
        this.populateQueue(typeInfoRows, queue, schemaFields);
        this.signalEndOfData(queue, schemaFields);
        return BigQueryJsonResultSet.of(typeInfoSchema, typeInfoRows.size(), queue, this.statement, new Thread[0]);
    }

    Schema defineGetTypeInfoSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(18);
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("PRECISION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("LITERAL_PREFIX", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("LITERAL_SUFFIX", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CREATE_PARAMS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NULLABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("CASE_SENSITIVE", StandardSQLTypeName.BOOL, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SEARCHABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("UNSIGNED_ATTRIBUTE", StandardSQLTypeName.BOOL, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FIXED_PREC_SCALE", StandardSQLTypeName.BOOL, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("AUTO_INCREMENT", StandardSQLTypeName.BOOL, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("LOCAL_TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("MINIMUM_SCALE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("MAXIMUM_SCALE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATETIME_SUB", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NUM_PREC_RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    List<FieldValueList> prepareGetTypeInfoRows(FieldList schemaFields) {
        ArrayList<FieldValueList> rows = new ArrayList<FieldValueList>();
        Function<TypeInfoRowData, FieldValueList> createRow = data -> {
            ArrayList<FieldValue> values = new ArrayList<FieldValue>(18);
            values.add(this.createStringFieldValue(data.typeName));
            values.add(this.createLongFieldValue(Long.valueOf(data.jdbcType)));
            values.add(this.createLongFieldValue(data.precision));
            values.add(this.createStringFieldValue(data.literalPrefix));
            values.add(this.createStringFieldValue(data.literalSuffix));
            values.add(this.createStringFieldValue(data.createParams));
            values.add(this.createLongFieldValue(Long.valueOf(data.nullable)));
            values.add(this.createBooleanFieldValue(data.caseSensitive));
            values.add(this.createLongFieldValue(Long.valueOf(data.searchable)));
            values.add(this.createBooleanFieldValue(data.unsignedAttribute));
            values.add(this.createBooleanFieldValue(data.fixedPrecScale));
            values.add(this.createBooleanFieldValue(data.autoIncrement));
            values.add(this.createStringFieldValue(data.localTypeName));
            values.add(this.createLongFieldValue(data.minimumScale));
            values.add(this.createLongFieldValue(data.maximumScale));
            values.add(this.createNullFieldValue());
            values.add(this.createNullFieldValue());
            values.add(this.createLongFieldValue(data.numPrecRadix));
            return FieldValueList.of(values, schemaFields);
        };
        rows.add(createRow.apply(new TypeInfoRowData("INT64", -5, 19L, null, null, null, 1, false, 3, false, false, false, "INT64", 0L, 0L, 10L)));
        rows.add(createRow.apply(new TypeInfoRowData("BOOL", 16, 1L, null, null, null, 1, false, 2, false, false, false, "BOOL", 0L, 0L, null)));
        rows.add(createRow.apply(new TypeInfoRowData("FLOAT64", 8, 15L, null, null, null, 1, false, 3, false, false, false, "FLOAT64", null, null, 2L)));
        rows.add(createRow.apply(new TypeInfoRowData("NUMERIC", 2, 38L, null, null, "PRECISION,SCALE", 1, false, 3, false, true, false, "NUMERIC", 9L, 9L, 10L)));
        rows.add(createRow.apply(new TypeInfoRowData("BIGNUMERIC", 2, 77L, null, null, "PRECISION,SCALE", 1, false, 3, false, true, false, "BIGNUMERIC", 38L, 38L, 10L)));
        rows.add(createRow.apply(new TypeInfoRowData("STRING", -9, null, "'", "'", "LENGTH", 1, true, 3, false, false, false, "STRING", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("TIMESTAMP", 93, 29L, "'", "'", null, 1, false, 3, false, false, false, "TIMESTAMP", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("DATE", 91, 10L, "'", "'", null, 1, false, 3, false, false, false, "DATE", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("TIME", 92, 15L, "'", "'", null, 1, false, 3, false, false, false, "TIME", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("DATETIME", 93, 29L, "'", "'", null, 1, false, 3, false, false, false, "DATETIME", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("GEOGRAPHY", 1111, null, "'", "'", null, 1, false, 3, false, false, false, "GEOGRAPHY", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("JSON", 1111, null, "'", "'", null, 1, false, 3, false, false, false, "JSON", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("INTERVAL", 1111, null, "'", "'", null, 1, false, 3, false, false, false, "INTERVAL", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("BYTES", -3, null, "0x", null, "LENGTH", 1, false, 3, false, false, false, "BYTES", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("STRUCT", 2002, null, null, null, null, 1, false, 0, false, false, false, "STRUCT", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("ARRAY", 2003, null, null, null, null, 1, false, 0, false, false, false, "ARRAY", null, null, null)));
        rows.add(createRow.apply(new TypeInfoRowData("RANGE", 1111, null, null, null, null, 1, false, 3, false, false, false, "RANGE", null, null, null)));
        return rows;
    }

    Comparator<FieldValueList> defineGetTypeInfoComparator(FieldList schemaFields) {
        int DATA_TYPE_IDX = schemaFields.getIndex("DATA_TYPE");
        if (DATA_TYPE_IDX < 0) {
            this.LOG.severe("Could not find DATA_TYPE column in getTypeInfo schema for sorting. Returning null comparator.");
            return null;
        }
        Comparator<FieldValueList> comparator = Comparator.comparing(fvl -> this.getLongValueOrNull((FieldValueList)fvl, DATA_TYPE_IDX), Comparator.nullsFirst(Long::compareTo));
        return comparator;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        this.LOG.info(String.format("getIndexInfo called for catalog: %s, schema: %s, table: %s, unique: %s, approximate: %s. Traditional indexes not supported by BigQuery; returning empty ResultSet.", catalog, schema, table, unique, approximate));
        Schema resultSchema = this.defineGetIndexInfoSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetIndexInfoSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(13);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("NON_UNIQUE", StandardSQLTypeName.BOOL, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("INDEX_QUALIFIER", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("INDEX_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("ORDINAL_POSITION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ASC_OR_DESC", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CARDINALITY", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("PAGES", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FILTER_CONDITION", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        this.LOG.info(String.format("getUDTs called for catalog: %s, schemaPattern: %s, typeNamePattern: %s, types: %s. Feature not supported by BigQuery; returning empty ResultSet.", catalog, schemaPattern, typeNamePattern, types == null ? "null" : Arrays.toString(types)));
        Schema resultSchema = this.defineGetUDTsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetUDTsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(7);
        fields.add(Field.newBuilder("TYPE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("CLASS_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("BASE_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        this.LOG.info(String.format("getSuperTables called for catalog: %s, schemaPattern: %s, tableNamePattern: %s. BigQuery does not support super tables; returning empty ResultSet.", catalog, schemaPattern, tableNamePattern));
        Schema resultSchema = this.defineGetSuperTablesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetSuperTablesSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(4);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SUPERTABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        this.LOG.info(String.format("getSuperTypes called for catalog: %s, schemaPattern: %s, typeNamePattern: %s. BigQuery does not support user-defined type hierarchies; returning empty ResultSet.", catalog, schemaPattern, typeNamePattern));
        Schema resultSchema = this.defineGetSuperTypesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetSuperTypesSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(6);
        fields.add(Field.newBuilder("TYPE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SUPERTYPE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SUPERTYPE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SUPERTYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        this.LOG.info(String.format("getAttributes called for catalog: %s, schemaPattern: %s, typeNamePattern: %s, attributeNamePattern: %s. Feature not supported by BigQuery; returning empty ResultSet.", catalog, schemaPattern, typeNamePattern, attributeNamePattern));
        Schema resultSchema = this.defineGetAttributesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetAttributesSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(21);
        fields.add(Field.newBuilder("TYPE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("ATTR_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("ATTR_TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("ATTR_SIZE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("DECIMAL_DIGITS", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NUM_PREC_RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NULLABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ATTR_DEF", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SQL_DATETIME_SUB", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CHAR_OCTET_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ORDINAL_POSITION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_NULLABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SCOPE_CATALOG", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCOPE_SCHEMA", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCOPE_TABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SOURCE_DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 2;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        if (catalog != null && catalog.isEmpty() || schemaPattern != null && schemaPattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet as catalog or schemaPattern is an empty string.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getSchemas called for catalog: %s, schemaPattern: %s", catalog, schemaPattern));
        Pattern schemaRegex = this.compileSqlLikePattern(schemaPattern);
        Schema resultSchema = this.defineGetSchemasSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        String catalogParam = catalog;
        Runnable schemaFetcher = () -> {
            FieldList localResultSchemaFields = resultSchemaFields;
            ArrayList<String> projectsToScanList = new ArrayList<String>();
            if (catalogParam != null) {
                projectsToScanList.add(catalogParam);
            } else {
                projectsToScanList.addAll(this.getAccessibleCatalogNames());
            }
            if (projectsToScanList.isEmpty()) {
                this.LOG.info("No valid projects to scan (primary, specified, or additional). Returning empty resultset.");
                return;
            }
            try {
                block5: for (String currentProjectToScan : projectsToScanList) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Schema fetcher interrupted during project iteration for project: " + currentProjectToScan);
                        break;
                    }
                    this.LOG.info("Fetching schemas for project: " + currentProjectToScan);
                    List<Dataset> datasetsInProject = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(currentProjectToScan, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(currentProjectToScan, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaPattern, schemaRegex, this.LOG);
                    if (datasetsInProject.isEmpty() || Thread.currentThread().isInterrupted()) {
                        this.LOG.info("Fetcher thread found no matching datasets in project: " + currentProjectToScan);
                        continue;
                    }
                    this.LOG.fine("Processing found datasets for project: " + currentProjectToScan);
                    for (Dataset dataset : datasetsInProject) {
                        if (Thread.currentThread().isInterrupted()) {
                            this.LOG.warning("Schema fetcher interrupted during dataset iteration for project: " + currentProjectToScan);
                            continue block5;
                        }
                        this.processSchemaInfo(dataset, collectedResults, localResultSchemaFields);
                    }
                }
                if (!Thread.currentThread().isInterrupted()) {
                    Comparator<FieldValueList> comparator = this.defineGetSchemasComparator(localResultSchemaFields);
                    this.sortResults(collectedResults, comparator, "getSchemas", this.LOG);
                }
                if (!Thread.currentThread().isInterrupted()) {
                    this.populateQueue(collectedResults, queue, localResultSchemaFields);
                }
            }
            catch (Throwable t2) {
                this.LOG.severe("Unexpected error in schema fetcher runnable: " + t2.getMessage());
            }
            finally {
                this.signalEndOfData(queue, localResultSchemaFields);
                this.LOG.info("Schema fetcher thread finished.");
            }
        };
        Thread fetcherThread = new Thread(schemaFetcher, "getSchemas-fetcher-" + catalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getSchemas");
        return resultSet;
    }

    Schema defineGetSchemasSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TABLE_CATALOG", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    void processSchemaInfo(Dataset dataset, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        DatasetId datasetId = dataset.getDatasetId();
        this.LOG.finer("Processing schema info for dataset: " + datasetId);
        try {
            String schemaName = datasetId.getDataset();
            String catalogName = datasetId.getProject();
            ArrayList<FieldValue> values = new ArrayList<FieldValue>(resultSchemaFields.size());
            values.add(this.createStringFieldValue(schemaName));
            values.add(this.createStringFieldValue(catalogName));
            FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
            collectedResults.add(rowFvl);
            this.LOG.finer("Processed and added schema info row for: " + datasetId);
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Error processing schema info for dataset %s: %s. Skipping this schema.", datasetId, e.getMessage()));
        }
    }

    Comparator<FieldValueList> defineGetSchemasComparator(FieldList resultSchemaFields) {
        int TABLE_CATALOG_IDX = resultSchemaFields.getIndex("TABLE_CATALOG");
        int TABLE_SCHEM_IDX = resultSchemaFields.getIndex("TABLE_SCHEM");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_CATALOG_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, TABLE_SCHEM_IDX), Comparator.nullsFirst(String::compareTo));
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getClientInfoProperties() {
        this.LOG.info("getClientInfoProperties() called.");
        Schema resultSchema = this.defineGetClientInfoPropertiesSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(4);
        ArrayList<FieldValueList> collectedResults = new ArrayList<FieldValueList>(3);
        try {
            collectedResults.add(FieldValueList.of(Arrays.asList(this.createStringFieldValue("ApplicationName"), this.createLongFieldValue(25L), this.createNullFieldValue(), this.createStringFieldValue("The name of the application currently utilizing the connection.")), resultSchemaFields));
            collectedResults.add(FieldValueList.of(Arrays.asList(this.createStringFieldValue("ClientHostname"), this.createLongFieldValue(25L), this.createNullFieldValue(), this.createStringFieldValue("The hostname of the computer the application using the connection is running on.")), resultSchemaFields));
            collectedResults.add(FieldValueList.of(Arrays.asList(this.createStringFieldValue("ClientUser"), this.createLongFieldValue(25L), this.createNullFieldValue(), this.createStringFieldValue("The name of the user that the application using the connection is performing work for.")), resultSchemaFields));
            Comparator<FieldValueList> comparator = Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, resultSchemaFields.getIndex("NAME")), Comparator.nullsFirst(String::compareToIgnoreCase));
            this.sortResults(collectedResults, comparator, "getClientInfoProperties", this.LOG);
            this.populateQueue(collectedResults, queue, resultSchemaFields);
        }
        catch (Exception e) {
            this.LOG.warning("Unexpected error processing client info properties: " + e.getMessage());
            collectedResults.clear();
            queue.clear();
        }
        finally {
            this.signalEndOfData(queue, resultSchemaFields);
        }
        return BigQueryJsonResultSet.of(resultSchema, collectedResults.size(), queue, this.statement, new Thread[0]);
    }

    Schema defineGetClientInfoPropertiesSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(4);
        fields.add(Field.newBuilder("NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("MAX_LEN", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("DEFAULT_VALUE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("DESCRIPTION", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return Schema.of(fields);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        if (catalog == null || catalog.isEmpty() || schemaPattern != null && schemaPattern.isEmpty() || functionNamePattern != null && functionNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet as catalog is null/empty or a pattern is empty for getFunctions.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getFunctions called for catalog: %s, schemaPattern: %s, functionNamePattern: %s", catalog, schemaPattern, functionNamePattern));
        Pattern schemaRegex = this.compileSqlLikePattern(schemaPattern);
        Pattern functionNameRegex = this.compileSqlLikePattern(functionNamePattern);
        Schema resultSchema = this.defineGetFunctionsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        ArrayList processingTaskFutures = new ArrayList();
        String catalogParam = catalog;
        Runnable functionFetcher = () -> {
            List<Dataset> datasetsToScan;
            ArrayList<Future<List>> apiFutures;
            FieldList localResultSchemaFields;
            ExecutorService routineProcessorExecutor;
            ExecutorService apiExecutor;
            block13: {
                apiExecutor = null;
                routineProcessorExecutor = null;
                localResultSchemaFields = resultSchemaFields;
                apiFutures = new ArrayList<Future<List>>();
                datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaPattern, schemaRegex, this.LOG);
                if (!datasetsToScan.isEmpty()) break block13;
                this.LOG.info("Fetcher thread found no matching datasets. Returning empty resultset.");
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(routineProcessorExecutor);
                this.LOG.info("Function fetcher thread finished.");
                return;
            }
            try {
                apiExecutor = Executors.newFixedThreadPool(50);
                routineProcessorExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount);
                for (Dataset dataset : datasetsToScan) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Function fetcher interrupted during dataset iteration submission.");
                        break;
                    }
                    DatasetId currentDatasetId = dataset.getDatasetId();
                    Callable<List> apiCallable = () -> {
                        this.LOG.fine(String.format("Fetching all routines for dataset: %s, pattern: %s", currentDatasetId.getDataset(), functionNamePattern));
                        return this.findMatchingBigQueryObjects("Routine", () -> this.bigquery.listRoutines(currentDatasetId, BigQuery.RoutineListOption.pageSize(500L)), name -> this.bigquery.getRoutine(RoutineId.of(currentDatasetId.getProject(), currentDatasetId.getDataset(), name), new BigQuery.RoutineOption[0]), rt -> rt.getRoutineId().getRoutine(), functionNamePattern, functionNameRegex, this.LOG);
                    };
                    Future<List> apiFuture = apiExecutor.submit(apiCallable);
                    apiFutures.add(apiFuture);
                }
                this.LOG.fine("Finished submitting " + apiFutures.size() + " findMatchingRoutines (for functions) tasks.");
                apiExecutor.shutdown();
                block9: for (Future future : apiFutures) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.LOG.warning("Function fetcher interrupted while processing API futures.");
                        break;
                    }
                    try {
                        List routinesResult = (List)future.get();
                        if (routinesResult == null) continue;
                        for (Routine routine : routinesResult) {
                            if (Thread.currentThread().isInterrupted()) continue block9;
                            String routineType = routine.getRoutineType();
                            if (!"SCALAR_FUNCTION".equalsIgnoreCase(routineType) && !"TABLE_FUNCTION".equalsIgnoreCase(routineType)) continue;
                            this.LOG.fine("Submitting processing task for function: " + routine.getRoutineId() + " of type " + routineType);
                            Routine finalRoutine = routine;
                            Future<?> processFuture = routineProcessorExecutor.submit(() -> this.processFunctionInfo(finalRoutine, collectedResults, localResultSchemaFields));
                            processingTaskFutures.add(processFuture);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.LOG.warning("Function fetcher thread interrupted while waiting for API future result.");
                        break;
                    }
                    catch (CancellationException | ExecutionException e) {
                        this.LOG.warning("Error or cancellation in findMatchingRoutines (for functions) task: " + e.getMessage());
                    }
                }
                this.waitForTasksCompletion(processingTaskFutures);
                Comparator<FieldValueList> comparator = this.defineGetFunctionsComparator(localResultSchemaFields);
                this.sortResults(collectedResults, comparator, "getFunctions", this.LOG);
                this.populateQueue(collectedResults, queue, localResultSchemaFields);
                this.signalEndOfData(queue, localResultSchemaFields);
                this.shutdownExecutor(apiExecutor);
                this.shutdownExecutor(routineProcessorExecutor);
            }
            catch (Throwable t2) {
                try {
                    this.LOG.severe("Unexpected error in function fetcher runnable: " + t2.getMessage());
                    apiFutures.forEach(f -> f.cancel(true));
                    processingTaskFutures.forEach(f -> f.cancel(true));
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(routineProcessorExecutor);
                }
                catch (Throwable throwable) {
                    this.signalEndOfData(queue, localResultSchemaFields);
                    this.shutdownExecutor(apiExecutor);
                    this.shutdownExecutor(routineProcessorExecutor);
                    this.LOG.info("Function fetcher thread finished.");
                    throw throwable;
                }
                this.LOG.info("Function fetcher thread finished.");
            }
            this.LOG.info("Function fetcher thread finished.");
        };
        Thread fetcherThread = new Thread(functionFetcher, "getFunctions-fetcher-" + catalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getFunctions");
        return resultSet;
    }

    Schema defineGetFunctionsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(6);
        fields.add(Field.newBuilder("FUNCTION_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FUNCTION_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FUNCTION_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FUNCTION_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SPECIFIC_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    void processFunctionInfo(Routine routine, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        RoutineId routineId = routine.getRoutineId();
        this.LOG.fine("Processing function info for: " + routineId);
        try {
            String catalogName = routineId.getProject();
            String schemaName = routineId.getDataset();
            String functionName = routineId.getRoutine();
            String remarks = routine.getDescription();
            String specificName = functionName;
            String bqRoutineType = routine.getRoutineType();
            int functionType = "SCALAR_FUNCTION".equalsIgnoreCase(bqRoutineType) ? 0 : ("TABLE_FUNCTION".equalsIgnoreCase(bqRoutineType) ? 2 : 0);
            ArrayList<FieldValue> values = new ArrayList<FieldValue>(resultSchemaFields.size());
            values.add(this.createStringFieldValue(catalogName));
            values.add(this.createStringFieldValue(schemaName));
            values.add(this.createStringFieldValue(functionName));
            values.add(this.createStringFieldValue(remarks));
            values.add(this.createLongFieldValue(Long.valueOf(functionType)));
            values.add(this.createStringFieldValue(specificName));
            FieldValueList rowFvl = FieldValueList.of(values, resultSchemaFields);
            collectedResults.add(rowFvl);
            this.LOG.fine("Processed and added function info row for: " + routineId);
        }
        catch (Exception e) {
            this.LOG.warning(String.format("Error processing function info for %s: %s. Skipping this function.", routineId, e.getMessage()));
        }
    }

    Comparator<FieldValueList> defineGetFunctionsComparator(FieldList resultSchemaFields) {
        int FUNC_CAT_IDX = resultSchemaFields.getIndex("FUNCTION_CAT");
        int FUNC_SCHEM_IDX = resultSchemaFields.getIndex("FUNCTION_SCHEM");
        int FUNC_NAME_IDX = resultSchemaFields.getIndex("FUNCTION_NAME");
        int SPEC_NAME_IDX = resultSchemaFields.getIndex("SPECIFIC_NAME");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_CAT_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_SCHEM_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_NAME_IDX), Comparator.nullsFirst(String::compareTo)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, SPEC_NAME_IDX), Comparator.nullsFirst(String::compareTo));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        if (catalog == null || catalog.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet catalog (project) is null or empty.");
            return new BigQueryJsonResultSet();
        }
        if (schemaPattern != null && schemaPattern.isEmpty() || functionNamePattern != null && functionNamePattern.isEmpty() || columnNamePattern != null && columnNamePattern.isEmpty()) {
            this.LOG.warning("Returning empty ResultSet because an explicit empty pattern was provided.");
            return new BigQueryJsonResultSet();
        }
        this.LOG.info(String.format("getFunctionColumns called for catalog: %s, schemaPattern: %s, functionNamePattern: %s, columnNamePattern: %s", catalog, schemaPattern, functionNamePattern, columnNamePattern));
        Pattern schemaRegex = this.compileSqlLikePattern(schemaPattern);
        Pattern functionNameRegex = this.compileSqlLikePattern(functionNamePattern);
        Pattern columnNameRegex = this.compileSqlLikePattern(columnNamePattern);
        Schema resultSchema = this.defineGetFunctionColumnsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(5000);
        List collectedResults = Collections.synchronizedList(new ArrayList());
        ArrayList processingTaskFutures = new ArrayList();
        String catalogParam = catalog;
        Runnable functionColumnFetcher = () -> {
            block35: {
                block33: {
                    List<Routine> fullFunctions;
                    String fetcherThreadNameSuffix;
                    ExecutorService processParamsExecutor;
                    ExecutorService getRoutineDetailsExecutor;
                    ExecutorService listRoutinesExecutor;
                    block31: {
                        block32: {
                            List<RoutineId> functionIdsToGet;
                            block29: {
                                block30: {
                                    List<Dataset> datasetsToScan;
                                    block27: {
                                        block28: {
                                            listRoutinesExecutor = null;
                                            getRoutineDetailsExecutor = null;
                                            processParamsExecutor = null;
                                            fetcherThreadNameSuffix = "-" + catalogParam.substring(0, Math.min(10, catalogParam.length()));
                                            datasetsToScan = this.findMatchingBigQueryObjects(SCHEMA_TERM, () -> this.bigquery.listDatasets(catalogParam, BigQuery.DatasetListOption.pageSize(500L)), name -> this.bigquery.getDataset(DatasetId.of(catalogParam, name), new BigQuery.DatasetOption[0]), ds -> ds.getDatasetId().getDataset(), schemaPattern, schemaRegex, this.LOG);
                                            if (!datasetsToScan.isEmpty() && !Thread.currentThread().isInterrupted()) break block27;
                                            this.LOG.info("Fetcher: No matching datasets or interrupted early. Catalog: " + catalogParam);
                                            this.signalEndOfData(queue, resultSchemaFields);
                                            if (listRoutinesExecutor != null) {
                                                this.shutdownExecutor(listRoutinesExecutor);
                                            }
                                            if (getRoutineDetailsExecutor != null) {
                                                this.shutdownExecutor(getRoutineDetailsExecutor);
                                            }
                                            if (processParamsExecutor == null) break block28;
                                            this.shutdownExecutor(processParamsExecutor);
                                        }
                                        this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                                        return;
                                    }
                                    listRoutinesExecutor = Executors.newFixedThreadPool(50, runnable -> new Thread(runnable, "funcol-list-rout" + fetcherThreadNameSuffix));
                                    functionIdsToGet = this.listMatchingFunctionIdsFromDatasets(datasetsToScan, functionNamePattern, functionNameRegex, listRoutinesExecutor, catalogParam, this.LOG);
                                    this.shutdownExecutor(listRoutinesExecutor);
                                    listRoutinesExecutor = null;
                                    if (!functionIdsToGet.isEmpty() && !Thread.currentThread().isInterrupted()) break block29;
                                    this.LOG.info("Fetcher: No function IDs found or interrupted. Catalog: " + catalogParam);
                                    this.signalEndOfData(queue, resultSchemaFields);
                                    if (listRoutinesExecutor != null) {
                                        this.shutdownExecutor(listRoutinesExecutor);
                                    }
                                    if (getRoutineDetailsExecutor != null) {
                                        this.shutdownExecutor(getRoutineDetailsExecutor);
                                    }
                                    if (processParamsExecutor == null) break block30;
                                    this.shutdownExecutor(processParamsExecutor);
                                }
                                this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                                return;
                            }
                            getRoutineDetailsExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount, runnable -> new Thread(runnable, "funcol-get-details" + fetcherThreadNameSuffix));
                            fullFunctions = this.fetchFullRoutineDetailsForIds(functionIdsToGet, getRoutineDetailsExecutor, this.LOG);
                            this.shutdownExecutor(getRoutineDetailsExecutor);
                            getRoutineDetailsExecutor = null;
                            if (!fullFunctions.isEmpty() && !Thread.currentThread().isInterrupted()) break block31;
                            this.LOG.info("Fetcher: No full functions fetched or interrupted. Catalog: " + catalogParam);
                            this.signalEndOfData(queue, resultSchemaFields);
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processParamsExecutor == null) break block32;
                            this.shutdownExecutor(processParamsExecutor);
                        }
                        this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                        return;
                    }
                    try {
                        processParamsExecutor = Executors.newFixedThreadPool(this.metadataFetchThreadCount, runnable -> new Thread(runnable, "funcol-proc-params" + fetcherThreadNameSuffix));
                        this.submitFunctionParameterProcessingJobs(fullFunctions, columnNameRegex, collectedResults, resultSchemaFields, processParamsExecutor, processingTaskFutures, this.LOG);
                        if (Thread.currentThread().isInterrupted()) {
                            this.LOG.warning("Fetcher: Interrupted before waiting for parameter processing. Catalog: " + catalogParam);
                            processingTaskFutures.forEach(f -> f.cancel(true));
                        } else {
                            this.LOG.fine("Fetcher: Waiting for " + processingTaskFutures.size() + " parameter processing tasks. Catalog: " + catalogParam);
                            this.waitForTasksCompletion(processingTaskFutures);
                            this.LOG.fine("Fetcher: All parameter processing tasks completed or handled. Catalog: " + catalogParam);
                        }
                        if (!Thread.currentThread().isInterrupted()) {
                            Comparator<FieldValueList> comparator = this.defineGetFunctionColumnsComparator(resultSchemaFields);
                            this.sortResults(collectedResults, comparator, "getFunctionColumns", this.LOG);
                            this.populateQueue(collectedResults, queue, resultSchemaFields);
                        }
                        this.signalEndOfData(queue, resultSchemaFields);
                        if (listRoutinesExecutor != null) {
                            this.shutdownExecutor(listRoutinesExecutor);
                        }
                        if (getRoutineDetailsExecutor != null) {
                            this.shutdownExecutor(getRoutineDetailsExecutor);
                        }
                        if (processParamsExecutor == null) break block33;
                        this.shutdownExecutor(processParamsExecutor);
                    }
                    catch (InterruptedException e) {
                        block34: {
                            Thread.currentThread().interrupt();
                            this.LOG.warning("Fetcher: Interrupted in main try block for catalog " + catalogParam + ". Error: " + e.getMessage());
                            processingTaskFutures.forEach(f -> f.cancel(true));
                            this.signalEndOfData(queue, resultSchemaFields);
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processParamsExecutor == null) break block34;
                            this.shutdownExecutor(processParamsExecutor);
                        }
                        this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                        break block35;
                    }
                    catch (Throwable t2) {
                        block36: {
                            this.LOG.severe("Fetcher: Unexpected error in main try block for catalog " + catalogParam + ". Error: " + t2.getMessage());
                            processingTaskFutures.forEach(f -> f.cancel(true));
                            this.signalEndOfData(queue, resultSchemaFields);
                            if (listRoutinesExecutor != null) {
                                this.shutdownExecutor(listRoutinesExecutor);
                            }
                            if (getRoutineDetailsExecutor != null) {
                                this.shutdownExecutor(getRoutineDetailsExecutor);
                            }
                            if (processParamsExecutor == null) break block36;
                            this.shutdownExecutor(processParamsExecutor);
                            {
                                catch (Throwable throwable) {
                                    this.signalEndOfData(queue, resultSchemaFields);
                                    if (listRoutinesExecutor != null) {
                                        this.shutdownExecutor(listRoutinesExecutor);
                                    }
                                    if (getRoutineDetailsExecutor != null) {
                                        this.shutdownExecutor(getRoutineDetailsExecutor);
                                    }
                                    if (processParamsExecutor != null) {
                                        this.shutdownExecutor(processParamsExecutor);
                                    }
                                    this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                                    throw throwable;
                                }
                            }
                        }
                        this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
                    }
                }
                this.LOG.info("Function column fetcher thread finished for catalog: " + catalogParam);
            }
        };
        Thread fetcherThread = new Thread(functionColumnFetcher, "getFunctionColumns-fetcher-" + catalog);
        BigQueryJsonResultSet resultSet = BigQueryJsonResultSet.of(resultSchema, -1L, queue, this.statement, new Thread[]{fetcherThread});
        fetcherThread.start();
        this.LOG.info("Started background thread for getFunctionColumns for catalog: " + catalog);
        return resultSet;
    }

    Schema defineGetFunctionColumnsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(17);
        fields.add(Field.newBuilder("FUNCTION_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FUNCTION_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("FUNCTION_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("TYPE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("PRECISION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("SCALE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NULLABLE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CHAR_OCTET_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("ORDINAL_POSITION", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_NULLABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("SPECIFIC_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    List<RoutineId> listMatchingFunctionIdsFromDatasets(List<Dataset> datasetsToScan, String functionNamePattern, Pattern functionNameRegex, ExecutorService listRoutinesExecutor, String catalogParam, BigQueryJdbcCustomLogger logger) throws InterruptedException {
        logger.fine(String.format("Listing matching function IDs from %d datasets for catalog '%s'.", datasetsToScan.size(), catalogParam));
        ArrayList<Future<List>> listRoutineFutures = new ArrayList<Future<List>>();
        List<RoutineId> functionIdsToGet = Collections.synchronizedList(new ArrayList());
        for (Dataset dataset : datasetsToScan) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted during submission of routine (function) listing tasks for catalog: " + catalogParam);
                throw new InterruptedException("Interrupted while listing functions");
            }
            DatasetId currentDatasetId = dataset.getDatasetId();
            Callable<List> listCallable = () -> this.findMatchingBigQueryObjects("Routine", () -> this.bigquery.listRoutines(currentDatasetId, BigQuery.RoutineListOption.pageSize(500L)), name -> this.bigquery.getRoutine(RoutineId.of(currentDatasetId.getProject(), currentDatasetId.getDataset(), name), new BigQuery.RoutineOption[0]), rt -> rt.getRoutineId().getRoutine(), functionNamePattern, functionNameRegex, logger);
            listRoutineFutures.add(listRoutinesExecutor.submit(listCallable));
        }
        logger.fine("Submitted " + listRoutineFutures.size() + " routine (function) list tasks for catalog: " + catalogParam);
        for (Future future : listRoutineFutures) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted while collecting routine (function) list results for catalog: " + catalogParam);
                listRoutineFutures.forEach(f -> f.cancel(true));
                throw new InterruptedException("Interrupted while collecting function lists");
            }
            try {
                List listedRoutines = (List)future.get();
                if (listedRoutines == null) continue;
                for (Routine listedRoutine : listedRoutines) {
                    if (listedRoutine == null || !"SCALAR_FUNCTION".equalsIgnoreCase(listedRoutine.getRoutineType()) && !"TABLE_FUNCTION".equalsIgnoreCase(listedRoutine.getRoutineType())) continue;
                    if (listedRoutine.getRoutineId() != null) {
                        functionIdsToGet.add(listedRoutine.getRoutineId());
                        continue;
                    }
                    logger.warning("Found a function type routine with a null ID during listing phase for catalog: " + catalogParam);
                }
            }
            catch (ExecutionException e) {
                logger.warning("Error getting routine (function) list result for catalog " + catalogParam + ": " + e.getCause());
            }
            catch (CancellationException e) {
                logger.warning("Routine (function) list task cancelled for catalog: " + catalogParam);
            }
        }
        logger.info(String.format("Found %d function IDs to fetch details for in catalog '%s'.", functionIdsToGet.size(), catalogParam));
        return functionIdsToGet;
    }

    void submitFunctionParameterProcessingJobs(List<Routine> fullFunctions, Pattern columnNameRegex, List<FieldValueList> collectedResults, FieldList resultSchemaFields, ExecutorService processParamsExecutor, List<Future<?>> outParameterProcessingFutures, BigQueryJdbcCustomLogger logger) throws InterruptedException {
        logger.fine(String.format("Submitting parameter processing jobs for %d functions.", fullFunctions.size()));
        for (Routine fullFunction : fullFunctions) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warning("Interrupted during submission of function parameter processing tasks.");
                throw new InterruptedException("Interrupted while submitting function parameter processing jobs");
            }
            if (fullFunction == null) continue;
            String routineType = fullFunction.getRoutineType();
            if ("SCALAR_FUNCTION".equalsIgnoreCase(routineType) || "TABLE_FUNCTION".equalsIgnoreCase(routineType)) {
                Routine finalFullFunction = fullFunction;
                Future<?> processFuture = processParamsExecutor.submit(() -> this.processFunctionParametersAndReturnValue(finalFullFunction, columnNameRegex, collectedResults, resultSchemaFields));
                outParameterProcessingFutures.add(processFuture);
                continue;
            }
            logger.warning("Routine " + (fullFunction.getRoutineId() != null ? fullFunction.getRoutineId().toString() : "UNKNOWN_ID") + " fetched for getFunctionColumns was not of a function type (Type: " + routineType + "). Skipping parameter processing.");
        }
        logger.fine("Finished submitting " + outParameterProcessingFutures.size() + " processFunctionParametersAndReturnValue tasks.");
    }

    void processFunctionParametersAndReturnValue(Routine routine, Pattern columnNameRegex, List<FieldValueList> collectedResults, FieldList resultSchemaFields) {
        List<RoutineArgument> arguments;
        StandardSQLTableType returnTableType;
        String functionName;
        RoutineId routineId = routine.getRoutineId();
        if (routineId == null) {
            this.LOG.warning("Processing a routine with a null ID. Skipping.");
            return;
        }
        this.LOG.finer("Processing function parameters and return value for: " + routineId);
        String functionCatalog = routineId.getProject();
        String functionSchema = routineId.getDataset();
        String specificName = functionName = routineId.getRoutine();
        if (routine.getReturnTableType() != null && (returnTableType = routine.getReturnTableType()) != null && returnTableType.getColumns() != null) {
            List<StandardSQLField> tableColumns = returnTableType.getColumns();
            for (int i = 0; i < tableColumns.size(); ++i) {
                StandardSQLField tableColumn = tableColumns.get(i);
                String columnName = tableColumn.getName();
                if (columnNameRegex != null && (columnName == null || !columnNameRegex.matcher(columnName).matches())) continue;
                List<FieldValue> rowValues = this.createFunctionColumnRow(functionCatalog, functionSchema, functionName, specificName, columnName, 5, tableColumn.getDataType(), i + 1);
                collectedResults.add(FieldValueList.of(rowValues, resultSchemaFields));
            }
        }
        if ((arguments = routine.getArguments()) != null) {
            for (int i = 0; i < arguments.size(); ++i) {
                RoutineArgument arg = arguments.get(i);
                String argName = arg.getName();
                if (columnNameRegex != null && (argName == null || !columnNameRegex.matcher(argName).matches())) continue;
                String originalMode = arg.getMode();
                int columnType = "IN".equalsIgnoreCase(originalMode) ? 1 : ("OUT".equalsIgnoreCase(originalMode) ? 3 : ("INOUT".equalsIgnoreCase(originalMode) ? 2 : 0));
                List<FieldValue> rowValues = this.createFunctionColumnRow(functionCatalog, functionSchema, functionName, specificName, argName, columnType, arg.getDataType(), i + 1);
                collectedResults.add(FieldValueList.of(rowValues, resultSchemaFields));
            }
        }
    }

    List<FieldValue> createFunctionColumnRow(String functionCatalog, String functionSchema, String functionName, String specificName, String columnName, int columnType, StandardSQLDataType dataType, int ordinalPosition) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(17);
        ColumnTypeInfo typeInfo = this.determineTypeInfoFromDataType(dataType, functionName, columnName, ordinalPosition);
        values.add(this.createStringFieldValue(functionCatalog));
        values.add(this.createStringFieldValue(functionSchema));
        values.add(this.createStringFieldValue(functionName));
        values.add(this.createStringFieldValue(columnName));
        values.add(this.createLongFieldValue(Long.valueOf(columnType)));
        values.add(this.createLongFieldValue(Long.valueOf(typeInfo.jdbcType)));
        values.add(this.createStringFieldValue(typeInfo.typeName));
        values.add(this.createLongFieldValue(typeInfo.columnSize == null ? null : Long.valueOf(typeInfo.columnSize.longValue())));
        if (typeInfo.typeName != null && (typeInfo.typeName.equalsIgnoreCase("STRING") || typeInfo.typeName.equalsIgnoreCase("NVARCHAR") || typeInfo.typeName.equalsIgnoreCase("BYTES") || typeInfo.typeName.equalsIgnoreCase("VARBINARY"))) {
            values.add(this.createLongFieldValue(typeInfo.columnSize == null ? null : Long.valueOf(typeInfo.columnSize.longValue())));
            values.add(this.createLongFieldValue(typeInfo.decimalDigits == null ? null : Long.valueOf(typeInfo.decimalDigits.longValue())));
            values.add(this.createLongFieldValue(typeInfo.numPrecRadix == null ? null : Long.valueOf(typeInfo.numPrecRadix.longValue())));
            values.add(this.createLongFieldValue(2L));
            values.add(this.createStringFieldValue(null));
            values.add(this.createLongFieldValue(typeInfo.columnSize == null ? null : Long.valueOf(typeInfo.columnSize.longValue())));
        } else {
            values.add(this.createNullFieldValue());
            values.add(this.createLongFieldValue(typeInfo.decimalDigits == null ? null : Long.valueOf(typeInfo.decimalDigits.longValue())));
            values.add(this.createLongFieldValue(typeInfo.numPrecRadix == null ? null : Long.valueOf(typeInfo.numPrecRadix.longValue())));
            values.add(this.createLongFieldValue(2L));
            values.add(this.createStringFieldValue(null));
            values.add(this.createNullFieldValue());
        }
        values.add(this.createLongFieldValue(Long.valueOf(ordinalPosition)));
        values.add(this.createStringFieldValue(""));
        values.add(this.createStringFieldValue(specificName));
        return values;
    }

    Comparator<FieldValueList> defineGetFunctionColumnsComparator(FieldList resultSchemaFields) {
        int FUNC_CAT_IDX = resultSchemaFields.getIndex("FUNCTION_CAT");
        int FUNC_SCHEM_IDX = resultSchemaFields.getIndex("FUNCTION_SCHEM");
        int FUNC_NAME_IDX = resultSchemaFields.getIndex("FUNCTION_NAME");
        int SPEC_NAME_IDX = resultSchemaFields.getIndex("SPECIFIC_NAME");
        int ORDINAL_POS_IDX = resultSchemaFields.getIndex("ORDINAL_POSITION");
        return Comparator.comparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_CAT_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_SCHEM_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, FUNC_NAME_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getStringValueOrNull((FieldValueList)fvl, SPEC_NAME_IDX), Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(fvl -> this.getLongValueOrNull((FieldValueList)fvl, ORDINAL_POS_IDX), Comparator.nullsFirst(Long::compareTo));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        this.LOG.info(String.format("getPseudoColumns called for catalog: %s, schemaPattern: %s, tableNamePattern: %s, columnNamePattern: %s. Pseudo columns not supported by BigQuery; returning empty ResultSet.", catalog, schemaPattern, tableNamePattern, columnNamePattern));
        Schema resultSchema = this.defineGetPseudoColumnsSchema();
        FieldList resultSchemaFields = resultSchema.getFields();
        LinkedBlockingQueue<BigQueryFieldValueListWrapper> queue = new LinkedBlockingQueue<BigQueryFieldValueListWrapper>(1);
        this.signalEndOfData(queue, resultSchemaFields);
        return BigQueryJsonResultSet.of(resultSchema, 0L, queue, this.statement, null);
    }

    Schema defineGetPseudoColumnsSchema() {
        ArrayList<Field> fields = new ArrayList<Field>(12);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DATA_TYPE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("COLUMN_SIZE", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("DECIMAL_DIGITS", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("NUM_PREC_RADIX", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("COLUMN_USAGE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("REMARKS", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("CHAR_OCTET_LENGTH", StandardSQLTypeName.INT64, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("IS_NULLABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        return Schema.of(fields);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    private Tuple<String, String> determineEffectiveCatalogAndSchema(String catalog, String schemaPattern) {
        String effectiveCatalog = catalog;
        String effectiveSchemaPattern = schemaPattern;
        if (this.connection.isFilterTablesOnDefaultDataset() && this.connection.getDefaultDataset() != null && this.connection.getDefaultDataset().getDataset() != null && !this.connection.getDefaultDataset().getDataset().isEmpty()) {
            String defaultProjectFromConnection = this.connection.getCatalog();
            String defaultSchemaFromConnection = this.connection.getDefaultDataset().getDataset();
            boolean catalogIsNullOrEmptyOrWildcard = catalog == null || catalog.isEmpty() || catalog.equals("%");
            boolean schemaPatternIsNullOrEmptyOrWildcard = schemaPattern == null || schemaPattern.isEmpty() || schemaPattern.equals("%");
            String logPrefix = "FilterTablesOnDefaultDatasetTrue: ";
            if (catalogIsNullOrEmptyOrWildcard && schemaPatternIsNullOrEmptyOrWildcard) {
                effectiveCatalog = defaultProjectFromConnection;
                effectiveSchemaPattern = defaultSchemaFromConnection;
                this.LOG.info(String.format("FilterTablesOnDefaultDatasetTrue: Using default catalog '%s' and default dataset '%s'.", effectiveCatalog, effectiveSchemaPattern));
            } else if (catalogIsNullOrEmptyOrWildcard) {
                effectiveCatalog = defaultProjectFromConnection;
                this.LOG.info(String.format("FilterTablesOnDefaultDatasetTrue: Using default catalog '%s' with user dataset '%s'. Default dataset '%s' ignored.", effectiveCatalog, effectiveSchemaPattern, defaultSchemaFromConnection));
            } else if (schemaPatternIsNullOrEmptyOrWildcard) {
                effectiveSchemaPattern = defaultSchemaFromConnection;
                this.LOG.info(String.format("FilterTablesOnDefaultDatasetTrue: Using user catalog '%s' and default dataset '%s'.", effectiveCatalog, effectiveSchemaPattern));
            } else {
                this.LOG.info(String.format("FilterTablesOnDefaultDatasetTrue: Using user catalog '%s' and schema '%s'. Default dataset '%s' ignored.", effectiveCatalog, effectiveSchemaPattern, defaultSchemaFromConnection));
            }
        }
        return Tuple.of(effectiveCatalog, effectiveSchemaPattern);
    }

    private ColumnTypeInfo getColumnTypeInfoForSqlType(StandardSQLTypeName bqType) {
        if (bqType == null) {
            this.LOG.warning("Null BigQuery type encountered: " + bqType.name() + ". Mapping to VARCHAR.");
            return new ColumnTypeInfo(12, bqType.name(), null, null, null);
        }
        switch (bqType) {
            case INT64: {
                return new ColumnTypeInfo(-5, "BIGINT", 19, 0, 10);
            }
            case BOOL: {
                return new ColumnTypeInfo(16, "BOOLEAN", 1, null, null);
            }
            case FLOAT64: {
                return new ColumnTypeInfo(8, "DOUBLE", 15, null, 10);
            }
            case NUMERIC: {
                return new ColumnTypeInfo(2, "NUMERIC", 38, 9, 10);
            }
            case BIGNUMERIC: {
                return new ColumnTypeInfo(2, "NUMERIC", 77, 38, 10);
            }
            case STRING: {
                return new ColumnTypeInfo(-9, "NVARCHAR", null, null, null);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return new ColumnTypeInfo(93, "TIMESTAMP", 29, null, null);
            }
            case DATE: {
                return new ColumnTypeInfo(91, "DATE", 10, null, null);
            }
            case TIME: {
                return new ColumnTypeInfo(92, "TIME", 15, null, null);
            }
            case GEOGRAPHY: 
            case JSON: 
            case INTERVAL: {
                return new ColumnTypeInfo(12, "VARCHAR", null, null, null);
            }
            case BYTES: {
                return new ColumnTypeInfo(-3, "VARBINARY", null, null, null);
            }
            case STRUCT: {
                return new ColumnTypeInfo(2002, "STRUCT", null, null, null);
            }
        }
        this.LOG.warning("Unknown BigQuery type encountered: " + bqType.name() + ". Mapping to VARCHAR.");
        return new ColumnTypeInfo(12, bqType.name(), null, null, null);
    }

    <T> List<T> findMatchingBigQueryObjects(String objectTypeName, Supplier<Page<T>> listAllOperation, Function<String, T> getSpecificOperation, Function<T, String> nameExtractor, String pattern, Pattern regex, BigQueryJdbcCustomLogger logger) {
        boolean needsList = this.needsListing(pattern);
        ArrayList<T> resultList = new ArrayList<T>();
        try {
            Iterable<T> objects;
            if (needsList) {
                logger.info(String.format("Listing all %ss (pattern: %s)...", objectTypeName, pattern == null ? "<all>" : pattern));
                Page<T> firstPage = listAllOperation.get();
                objects = firstPage.iterateAll();
                logger.fine(String.format("Retrieved initial %s list, iterating & filtering if needed...", objectTypeName));
            } else {
                logger.info(String.format("Getting specific %s: '%s'", objectTypeName, pattern));
                T specificObject = getSpecificOperation.apply(pattern);
                Iterable iterable = objects = specificObject == null ? Collections.emptyList() : Collections.singletonList(specificObject);
                if (specificObject == null) {
                    logger.info(String.format("Specific %s not found: '%s'", objectTypeName, pattern));
                }
            }
            boolean wasListing = needsList;
            for (T obj : objects) {
                if (Thread.currentThread().isInterrupted()) {
                    logger.warning("Thread interrupted during " + objectTypeName + " processing loop.");
                    throw new InterruptedException("Interrupted during " + objectTypeName + " processing loop");
                }
                if (obj == null) continue;
                if (wasListing && regex != null) {
                    String name = nameExtractor.apply(obj);
                    if (name == null || !regex.matcher(name).matches()) continue;
                    resultList.add(obj);
                    continue;
                }
                resultList.add(obj);
            }
        }
        catch (BigQueryException e) {
            if (!needsList && e.getCode() == 404) {
                logger.info(String.format("%s '%s' not found (API error 404).", objectTypeName, pattern));
            } else {
                logger.warning(String.format("BigQueryException finding %ss for pattern '%s': %s (Code: %d)", objectTypeName, pattern, e.getMessage(), e.getCode()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warning("Interrupted while finding " + objectTypeName + "s.");
        }
        catch (Exception e) {
            logger.severe(String.format("Unexpected exception finding %ss for pattern '%s': %s", objectTypeName, pattern, e.getMessage()));
        }
        return resultList;
    }

    void sortResults(List<FieldValueList> collectedResults, Comparator<FieldValueList> comparator, String operationName, BigQueryJdbcCustomLogger logger) {
        if (collectedResults == null || collectedResults.isEmpty()) {
            logger.info(String.format("No results collected for %s, skipping sort.", operationName));
            return;
        }
        if (comparator == null) {
            logger.info(String.format("No comparator provided for %s, skipping sort.", operationName));
            return;
        }
        logger.info(String.format("Sorting %d collected %s results...", collectedResults.size(), operationName));
        try {
            collectedResults.sort(comparator);
            logger.info(String.format("%s result sorting completed.", operationName));
        }
        catch (Exception e) {
            logger.severe(String.format("Error during sorting %s results: %s", operationName, e.getMessage()));
        }
    }

    private List<Field> defineBasePrivilegeFields() {
        ArrayList<Field> fields = new ArrayList<Field>(7);
        fields.add(Field.newBuilder("TABLE_CAT", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_SCHEM", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("TABLE_NAME", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("GRANTOR", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        fields.add(Field.newBuilder("GRANTEE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("PRIVILEGE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.REQUIRED).build());
        fields.add(Field.newBuilder("IS_GRANTABLE", StandardSQLTypeName.STRING, new Field[0]).setMode(Field.Mode.NULLABLE).build());
        return fields;
    }

    Pattern compileSqlLikePattern(String sqlLikePattern) {
        if (sqlLikePattern == null) {
            return null;
        }
        if (sqlLikePattern.isEmpty()) {
            return Pattern.compile("(?!)");
        }
        StringBuilder regex = new StringBuilder(sqlLikePattern.length() * 2);
        regex.append('^');
        block5: for (int i = 0; i < sqlLikePattern.length(); ++i) {
            char c = sqlLikePattern.charAt(i);
            switch (c) {
                case '%': {
                    regex.append(".*");
                    continue block5;
                }
                case '_': {
                    regex.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regex.append('\\').append(c);
                    continue block5;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append('$');
        return Pattern.compile(regex.toString(), 2);
    }

    boolean needsListing(String pattern) {
        return pattern == null || pattern.contains("%") || pattern.contains("_");
    }

    FieldValue createStringFieldValue(String value) {
        return FieldValue.of(FieldValue.Attribute.PRIMITIVE, value);
    }

    FieldValue createLongFieldValue(Long value) {
        return value == null ? FieldValue.of(FieldValue.Attribute.PRIMITIVE, null) : FieldValue.of(FieldValue.Attribute.PRIMITIVE, String.valueOf(value));
    }

    FieldValue createNullFieldValue() {
        return FieldValue.of(FieldValue.Attribute.PRIMITIVE, null);
    }

    FieldValue createBooleanFieldValue(Boolean value) {
        return value == null ? FieldValue.of(FieldValue.Attribute.PRIMITIVE, null) : FieldValue.of(FieldValue.Attribute.PRIMITIVE, value != false ? "1" : "0");
    }

    private String getStringValueOrNull(FieldValueList fvl, int index) {
        if (fvl == null || index < 0 || index >= fvl.size()) {
            return null;
        }
        FieldValue fv = fvl.get(index);
        return fv == null || fv.isNull() ? null : fv.getStringValue();
    }

    private Long getLongValueOrNull(FieldValueList fvl, int index) {
        if (fvl == null || index < 0 || index >= fvl.size()) {
            return null;
        }
        FieldValue fv = fvl.get(index);
        try {
            return fv == null || fv.isNull() ? null : Long.valueOf(fv.getLongValue());
        }
        catch (NumberFormatException e) {
            this.LOG.warning("Could not parse Long value for index " + index);
            return null;
        }
    }

    private void waitForTasksCompletion(List<Future<?>> taskFutures) {
        this.LOG.info(String.format("Waiting for %d submitted tasks to complete...", taskFutures.size()));
        for (Future<?> future : taskFutures) {
            try {
                if (future.isCancelled()) continue;
                future.get();
            }
            catch (CancellationException e) {
                this.LOG.warning("A table processing task was cancelled.");
            }
            catch (ExecutionException e) {
                this.LOG.severe(String.format("Error executing table processing task: %s", e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.LOG.warning("Fetcher thread interrupted while waiting for tasks. Attempting to cancel remaining tasks.");
                taskFutures.forEach(f -> f.cancel(true));
                break;
            }
        }
        this.LOG.info("Finished waiting for tasks.");
    }

    private void populateQueue(List<FieldValueList> collectedResults, BlockingQueue<BigQueryFieldValueListWrapper> queue, FieldList resultSchemaFields) {
        this.LOG.info(String.format("Populating queue with %d results...", collectedResults.size()));
        try {
            for (FieldValueList sortedRow : collectedResults) {
                if (Thread.currentThread().isInterrupted()) {
                    this.LOG.warning("Interrupted during queue population.");
                    break;
                }
                queue.put(BigQueryFieldValueListWrapper.of(resultSchemaFields, sortedRow, new boolean[0]));
            }
            this.LOG.info("Finished populating queue.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.LOG.warning("Interrupted while putting row onto queue.");
        }
        catch (Exception e) {
            this.LOG.severe("Unexpected error populating queue: " + e.getMessage());
        }
    }

    private void signalEndOfData(BlockingQueue<BigQueryFieldValueListWrapper> queue, FieldList resultSchemaFields) {
        try {
            this.LOG.info("Adding end signal to queue.");
            queue.put(BigQueryFieldValueListWrapper.of(resultSchemaFields, null, true));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.LOG.warning("Interrupted while sending end signal to queue.");
        }
        catch (Exception e) {
            this.LOG.severe("Exception while sending end signal to queue: " + e.getMessage());
        }
    }

    private void shutdownExecutor(ExecutorService executor) {
        if (executor == null || executor.isShutdown()) {
            return;
        }
        this.LOG.info("Shutting down column executor service...");
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.LOG.warning("Executor did not terminate gracefully after 10s, forcing shutdownNow().");
                List<Runnable> droppedTasks = executor.shutdownNow();
                this.LOG.warning("Executor shutdownNow() initiated. Dropped tasks count: " + droppedTasks.size());
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.LOG.severe("Executor did not terminate even after shutdownNow().");
                }
            }
            this.LOG.info("Executor shutdown complete.");
        }
        catch (InterruptedException ie) {
            this.LOG.warning("Interrupted while waiting for executor termination. Forcing shutdownNow() again.");
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String getCurrentCatalogName() {
        return this.connection.getCatalog();
    }

    private List<String> getAccessibleCatalogNames() {
        List<String> additionalProjects;
        HashSet<String> accessibleCatalogs = new HashSet<String>();
        String primaryCatalog = this.getCurrentCatalogName();
        if (primaryCatalog != null && !primaryCatalog.isEmpty()) {
            accessibleCatalogs.add(primaryCatalog);
        }
        if ((additionalProjects = this.connection.getAdditionalProjects()) != null) {
            for (String project : additionalProjects) {
                if (project == null || project.isEmpty()) continue;
                accessibleCatalogs.add(project);
            }
        }
        ArrayList<String> sortedCatalogs = new ArrayList<String>(accessibleCatalogs);
        Collections.sort(sortedCatalogs);
        return sortedCatalogs;
    }

    static String readSqlFromFile(String filename) {
        InputStream in = BigQueryDatabaseMetaData.class.getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder builder = new StringBuilder();
        try (Scanner scanner = new Scanner(reader);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                builder.append(line).append("\n");
            }
        }
        return builder.toString();
    }

    String replaceSqlParameters(String sql, String ... params) throws SQLException {
        return String.format(sql, params);
    }

    private void loadDriverVersionProperties() {
        if (parsedDriverVersion.get() != null) {
            return;
        }
        Properties props = new Properties();
        try (InputStream input = this.getClass().getResourceAsStream("/com/google/cloud/bigquery/jdbc/dependencies.properties");){
            if (input == null) {
                String errorMessage = "Could not find dependencies.properties. Driver version information is unavailable.";
                this.LOG.severe(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            props.load(input);
            String versionString = props.getProperty("version.jdbc");
            if (versionString == null || versionString.trim().isEmpty()) {
                String errorMessage = "The property version.jdbc not found or empty in dependencies.properties.";
                this.LOG.severe(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            parsedDriverVersion.compareAndSet(null, versionString.trim());
            String[] parts = versionString.split("\\.");
            if (parts.length < 2) {
                return;
            }
            parsedDriverMajorVersion.compareAndSet(null, Integer.parseInt(parts[0]));
            String minorPart = parts[1];
            String numericMinor = minorPart.replaceAll("[^0-9].*", "");
            if (!numericMinor.isEmpty()) {
                parsedDriverMinorVersion.compareAndSet(null, Integer.parseInt(numericMinor));
            }
        }
        catch (IOException | NumberFormatException e) {
            String errorMessage = "Error reading dependencies.properties. Driver version information is unavailable. Error: " + e.getMessage();
            this.LOG.severe(errorMessage);
            throw new IllegalStateException(errorMessage, e);
        }
    }

    private static class TypeInfoRowData {
        String typeName;
        int jdbcType;
        Long precision;
        String literalPrefix;
        String literalSuffix;
        String createParams;
        int nullable;
        boolean caseSensitive;
        int searchable;
        boolean unsignedAttribute;
        boolean fixedPrecScale;
        boolean autoIncrement;
        String localTypeName;
        Long minimumScale;
        Long maximumScale;
        Long numPrecRadix;

        TypeInfoRowData(String typeName, int jdbcType, Long precision, String literalPrefix, String literalSuffix, String createParams, int nullable, boolean caseSensitive, int searchable, boolean unsignedAttribute, boolean fixedPrecScale, boolean autoIncrement, String localTypeName, Long minimumScale, Long maximumScale, Long numPrecRadix) {
            this.typeName = typeName;
            this.jdbcType = jdbcType;
            this.precision = precision;
            this.literalPrefix = literalPrefix;
            this.literalSuffix = literalSuffix;
            this.createParams = createParams;
            this.nullable = nullable;
            this.caseSensitive = caseSensitive;
            this.searchable = searchable;
            this.unsignedAttribute = unsignedAttribute;
            this.fixedPrecScale = fixedPrecScale;
            this.autoIncrement = autoIncrement;
            this.localTypeName = localTypeName;
            this.minimumScale = minimumScale;
            this.maximumScale = maximumScale;
            this.numPrecRadix = numPrecRadix;
        }
    }

    static class ColumnTypeInfo {
        final int jdbcType;
        final String typeName;
        final Integer columnSize;
        final Integer decimalDigits;
        final Integer numPrecRadix;

        ColumnTypeInfo(int jdbcType, String typeName, Integer columnSize, Integer decimalDigits, Integer numPrecRadix) {
            this.jdbcType = jdbcType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
        }
    }
}

