/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryConnectionProperty;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcOAuthUtility;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcRootLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcException;
import shaded.bqjdbc.io.grpc.LoadBalancerRegistry;
import shaded.bqjdbc.io.grpc.internal.PickFirstLoadBalancerProvider;

public class BigQueryDriver
implements Driver {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryDriver.class.getName());
    private static final int JDBC_MAJOR_VERSION = 0;
    private static final int JDBC_MINOR_VERSION = 1;
    static BigQueryDriver registeredBigqueryJdbcDriver;

    static void register() throws SQLException {
        LOG.finest("++enter++");
        if (BigQueryDriver.isRegistered()) {
            LOG.warning("Driver is already registered. It can only be registered once.");
        }
        DriverManager.registerDriver(LazyHolder.INSTANCE);
        registeredBigqueryJdbcDriver = LazyHolder.INSTANCE;
    }

    static boolean isRegistered() {
        LOG.finest("++enter++");
        return registeredBigqueryJdbcDriver != null;
    }

    public static BigQueryDriver getRegisteredDriver() throws IllegalStateException {
        LOG.finest("++enter++");
        if (BigQueryDriver.isRegistered()) {
            return registeredBigqueryJdbcDriver;
        }
        throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        LOG.finest("++enter++");
        try {
            if (this.acceptsURL(url)) {
                String connectionUri = BigQueryJdbcUrlUtility.appendPropertiesToURL(url.substring(5), this.toString(), info);
                String logLevelStr = BigQueryJdbcUrlUtility.parseUriProperty(connectionUri, "LogLevel");
                if (logLevelStr == null) {
                    logLevelStr = System.getenv("BIGQUERY_JDBC_LOG_LEVEL");
                }
                Level logLevel = BigQueryJdbcUrlUtility.parseLogLevel(logLevelStr);
                String logPath = BigQueryJdbcUrlUtility.parseUriProperty(connectionUri, "LogPath");
                if (logPath == null) {
                    logPath = System.getenv("BIGQUERY_JDBC_LOG_PATH");
                }
                if (logPath == null) {
                    logPath = "";
                }
                BigQueryJdbcRootLogger.setLevel(logLevel, logPath);
                BigQueryConnection connection = new BigQueryConnection(connectionUri);
                LOG.info(String.format("Driver info : { {Database Product Name : %s}, {Database Product Version : %s}, {Driver Name : %s}, {Driver Version : %s}, {LogLevel : %s}, {LogPath : %s}, {Driver Instance : %s} }", connection.getMetaData().getDatabaseProductName(), connection.getMetaData().getDatabaseProductVersion(), connection.getMetaData().getDriverName(), connection.getMetaData().getDriverVersion(), logLevel, logPath, this.toString()));
                return connection;
            }
            throw new IllegalArgumentException("Invalid URL provided, must start with \"jdbc:bigquery:\"");
        }
        catch (IOException e) {
            LOG.warning("Getting a warning: " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        LOG.finest("++enter++");
        if (url == null || url.isEmpty()) {
            throw new BigQueryJdbcException("Connection URL is null.");
        }
        return url.startsWith("jdbc:bigquery:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        LOG.finest("++enter++");
        String connectionUri = BigQueryJdbcUrlUtility.appendPropertiesToURL(url.substring(5), this.toString(), info);
        ArrayList<DriverPropertyInfo> propertyInfoList = new ArrayList<DriverPropertyInfo>();
        for (BigQueryConnectionProperty prop : BigQueryJdbcUrlUtility.VALID_PROPERTIES) {
            DriverPropertyInfo driverProperty = new DriverPropertyInfo(prop.getName(), BigQueryJdbcUrlUtility.parseUriProperty(connectionUri, prop.getName()));
            driverProperty.description = prop.getDescription();
            propertyInfoList.add(driverProperty);
        }
        Map<String, String> oAuthProperties = BigQueryJdbcOAuthUtility.parseOAuthProperties(url, this.toString());
        for (Map.Entry<String, String> authProperty : oAuthProperties.entrySet()) {
            propertyInfoList.add(new DriverPropertyInfo(authProperty.getKey(), authProperty.getValue()));
        }
        return propertyInfoList.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        LOG.finest("++enter++");
        return 0;
    }

    @Override
    public int getMinorVersion() {
        LOG.finest("++enter++");
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        LOG.finest("++enter++");
        return false;
    }

    @Override
    public Logger getParentLogger() {
        LOG.finest("++enter++");
        return BigQueryJdbcRootLogger.getRootLogger();
    }

    static {
        try {
            BigQueryDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError("Registering driver failed: " + e.getMessage());
        }
        LoadBalancerRegistry.getDefaultRegistry().register(new PickFirstLoadBalancerProvider());
    }

    private static class LazyHolder {
        static final BigQueryDriver INSTANCE = new BigQueryDriver();

        private LazyHolder() {
        }
    }
}

