/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import java.io.IOException;
import java.util.concurrent.Phaser;
import javax.annotation.concurrent.GuardedBy;
import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.core.ApiFutureCallback;
import shaded.bqjdbc.com.google.api.core.ApiFutures;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.Exceptions;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.TableName;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.WriteStream;
import shaded.bqjdbc.com.google.common.util.concurrent.MoreExecutors;
import shaded.bqjdbc.com.google.gson.JsonArray;
import shaded.bqjdbc.com.google.protobuf.Descriptors;

class BigQueryJdbcBulkInsertWriter {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private JsonStreamWriter jsonStreamWriter;
    private final Phaser openRequestCount = new Phaser(1);
    private final Object streamLock = new Object();
    @GuardedBy(value="lock")
    private RuntimeException error = null;

    BigQueryJdbcBulkInsertWriter() {
    }

    void initialize(TableName parentTable, BigQueryWriteClient client, RetrySettings retrySettings) throws IOException, Descriptors.DescriptorValidationException, InterruptedException {
        WriteStream stream = WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build();
        CreateWriteStreamRequest createWriteStreamRequest = CreateWriteStreamRequest.newBuilder().setParent(parentTable.toString()).setWriteStream(stream).build();
        WriteStream writeStream = client.createWriteStream(createWriteStreamRequest);
        JsonStreamWriter.Builder jsonStreamWriterBuilder = JsonStreamWriter.newBuilder(writeStream.getName(), writeStream.getTableSchema());
        if (retrySettings != null) {
            jsonStreamWriterBuilder.setRetrySettings(retrySettings);
        }
        this.jsonStreamWriter = jsonStreamWriterBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(JsonArray data, long offset) throws Descriptors.DescriptorValidationException, IOException {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.error != null) {
                throw this.error;
            }
        }
        ApiFuture<AppendRowsResponse> future = this.jsonStreamWriter.append(data, offset);
        ApiFutures.addCallback(future, new AppendCompleteCallback(this), MoreExecutors.directExecutor());
        this.openRequestCount.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long cleanup(BigQueryWriteClient client) {
        this.openRequestCount.arriveAndAwaitAdvance();
        this.jsonStreamWriter.close();
        Object object = this.streamLock;
        synchronized (object) {
            if (this.error != null) {
                throw this.error;
            }
        }
        FinalizeWriteStreamResponse finalizeResponse = client.finalizeWriteStream(this.jsonStreamWriter.getStreamName());
        this.LOG.finest("Rows written: " + finalizeResponse.getRowCount());
        return finalizeResponse.getRowCount();
    }

    String getStreamName() {
        return this.jsonStreamWriter.getStreamName();
    }

    static class AppendCompleteCallback
    implements ApiFutureCallback<AppendRowsResponse> {
        private final BigQueryJdbcBulkInsertWriter parent;

        AppendCompleteCallback(BigQueryJdbcBulkInsertWriter parent) {
            this.parent = parent;
        }

        @Override
        public void onSuccess(AppendRowsResponse response) {
            this.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable throwable) {
            Object object = this.parent.streamLock;
            synchronized (object) {
                if (this.parent.error == null) {
                    Exceptions.StorageException storageException = Exceptions.toStorageException(throwable);
                    this.parent.error = storageException != null ? storageException : new RuntimeException(throwable);
                }
            }
            this.done();
        }

        private void done() {
            this.parent.openRequestCount.arriveAndDeregister();
        }
    }
}

