/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Map;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTypeName;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.com.google.gson.JsonObject;

@InternalApi
class BigQueryJdbcTypeMappings {
    static final Map<StandardSQLTypeName, Class<?>> standardSQLToJavaTypeMapping = ImmutableMap.ofEntries(BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.INT64, Long.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BOOL, Boolean.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.FLOAT64, Double.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.NUMERIC, BigDecimal.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BIGNUMERIC, BigDecimal.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.STRING, String.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.TIMESTAMP, Timestamp.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.DATE, Date.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.TIME, Time.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.DATETIME, Timestamp.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.GEOGRAPHY, String.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.JSON, String.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.INTERVAL, String.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.RANGE, String.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BYTES, byte[].class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.STRUCT, Struct.class), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.ARRAY, Array.class));
    static final Map<StandardSQLTypeName, Integer> standardSQLToJavaSqlTypesMapping = ImmutableMap.ofEntries(BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.INT64, -5), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BOOL, 16), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.FLOAT64, 8), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.NUMERIC, 2), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BIGNUMERIC, 2), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.STRING, -9), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.TIMESTAMP, 93), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.DATE, 91), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.TIME, 92), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.DATETIME, 93), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.GEOGRAPHY, 1111), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.JSON, 1111), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.INTERVAL, 1111), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.RANGE, 1111), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.BYTES, -3), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.STRUCT, 2002), BigQueryJdbcTypeMappings.entry(StandardSQLTypeName.ARRAY, 2003));
    static final Map<Integer, Class<?>> javaSQLToJavaTypeMapping = ImmutableMap.ofEntries(BigQueryJdbcTypeMappings.entry(-5, Long.class), BigQueryJdbcTypeMappings.entry(4, Integer.class), BigQueryJdbcTypeMappings.entry(16, Boolean.class), BigQueryJdbcTypeMappings.entry(8, Double.class), BigQueryJdbcTypeMappings.entry(6, Float.class), BigQueryJdbcTypeMappings.entry(2, BigDecimal.class), BigQueryJdbcTypeMappings.entry(12, String.class), BigQueryJdbcTypeMappings.entry(-9, String.class), BigQueryJdbcTypeMappings.entry(93, Timestamp.class), BigQueryJdbcTypeMappings.entry(91, Date.class), BigQueryJdbcTypeMappings.entry(92, Time.class), BigQueryJdbcTypeMappings.entry(1111, String.class), BigQueryJdbcTypeMappings.entry(-2, byte[].class), BigQueryJdbcTypeMappings.entry(-3, byte[].class), BigQueryJdbcTypeMappings.entry(2002, Struct.class), BigQueryJdbcTypeMappings.entry(-7, Boolean.class), BigQueryJdbcTypeMappings.entry(2003, Array.class));

    BigQueryJdbcTypeMappings() {
    }

    static StandardSQLTypeName classToType(Class type) throws BigQueryJdbcSqlFeatureNotSupportedException {
        if (Boolean.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BOOL;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.STRING;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.GEOGRAPHY;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.DATETIME;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Long.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Double.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (Float.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.NUMERIC;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BIGNUMERIC;
        }
        if (Date.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.DATE;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.TIMESTAMP;
        }
        if (Time.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.TIME;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.JSON;
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.JSON;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BYTES;
        }
        if (Array.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.ARRAY;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.STRUCT;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BYTES;
        }
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported object type for QueryParameter: " + type);
    }

    static Class<?> getJavaType(int javaSQLType) throws BigQueryJdbcSqlFeatureNotSupportedException {
        if (!javaSQLToJavaTypeMapping.containsKey(javaSQLType)) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported Java type for SQL type: " + javaSQLType);
        }
        Class<?> javaType = javaSQLToJavaTypeMapping.get(javaSQLType);
        if (javaType == null) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported Java type for SQL type: " + javaSQLType);
        }
        return javaType;
    }

    private static <K, V> AbstractMap.SimpleEntry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

