/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryFieldValueListWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJsonResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryJsonStruct;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercionUtility;
import java.sql.ResultSet;
import java.util.List;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.cloud.Tuple;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldList;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValue;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;

@InternalApi
class BigQueryJsonArray
extends BigQueryBaseArray {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryJsonArray.class.getName());
    private static final BigQueryTypeCoercer BIGQUERY_TYPE_COERCER = BigQueryTypeCoercionUtility.INSTANCE;
    private List<FieldValue> values;

    BigQueryJsonArray(Field schema, FieldValue values) {
        super(schema);
        this.values = values == null || values.isNull() ? null : values.getRepeatedValue();
    }

    @Override
    public Object getArray() {
        this.ensureValid();
        LOG.finest("++enter++");
        if (this.values == null) {
            return null;
        }
        return this.getArrayInternal(0, this.values.size());
    }

    @Override
    public Object getArray(long index, int count) {
        this.ensureValid();
        LOG.finest("++enter++");
        if (this.values == null) {
            return null;
        }
        Tuple<Integer, Integer> range = this.createRange(index, count, this.values.size());
        return this.getArrayInternal(range.x(), range.y());
    }

    @Override
    public ResultSet getResultSet() {
        this.ensureValid();
        LOG.finest("++enter++");
        if (this.values == null) {
            return new BigQueryJsonResultSet();
        }
        BigQueryFieldValueListWrapper bigQueryFieldValueListWrapper = BigQueryFieldValueListWrapper.getNestedFieldValueListWrapper(FieldList.of(this.singleElementSchema()), this.values, new boolean[0]);
        return BigQueryJsonResultSet.getNestedResultSet(Schema.of(this.schema), bigQueryFieldValueListWrapper, 0, this.values.size());
    }

    @Override
    public ResultSet getResultSet(long index, int count) {
        this.ensureValid();
        LOG.finest("++enter++");
        if (this.values == null) {
            return new BigQueryJsonResultSet();
        }
        Tuple<Integer, Integer> range = this.createRange(index, count, this.values.size());
        BigQueryFieldValueListWrapper bigQueryFieldValueListWrapper = BigQueryFieldValueListWrapper.getNestedFieldValueListWrapper(FieldList.of(this.singleElementSchema()), this.values, new boolean[0]);
        return BigQueryJsonResultSet.getNestedResultSet(Schema.of(this.schema), bigQueryFieldValueListWrapper, range.x(), range.y());
    }

    @Override
    public void free() {
        this.values = null;
        this.markInvalid();
    }

    @Override
    Object getCoercedValue(int index) {
        FieldValue fieldValue = this.values.get(index);
        return this.arrayOfStruct ? new BigQueryJsonStruct(this.schema.getSubFields(), fieldValue) : BIGQUERY_TYPE_COERCER.coerceTo(this.getTargetClass(), fieldValue);
    }
}

