/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryBaseResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryBaseStruct;
import com.google.cloud.bigquery.jdbc.BigQueryFieldValueListWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import com.google.cloud.bigquery.jdbc.BigQueryJsonArray;
import com.google.cloud.bigquery.jdbc.BigQueryJsonStruct;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQuery;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValue;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;

class BigQueryJsonResultSet
extends BigQueryBaseResultSet {
    private final long totalRows;
    private final BlockingQueue<BigQueryFieldValueListWrapper> buffer;
    private boolean hasReachedEnd = false;
    private BigQueryFieldValueListWrapper cursor;
    private int nestedRowIndex;
    private long rowCnt = 0L;
    private boolean afterLast = false;
    private final int fromIndex;
    private final int toIndexExclusive;
    private final Thread[] ownedThreads;

    private BigQueryJsonResultSet(Schema schema, long totalRows, BlockingQueue<BigQueryFieldValueListWrapper> buffer, BigQueryStatement statement, boolean isNested, BigQueryFieldValueListWrapper cursor, int fromIndex, int toIndexExclusive, Thread[] ownedThreads, BigQuery bigQuery) {
        super(bigQuery, statement, schema, isNested);
        this.totalRows = totalRows;
        this.buffer = buffer;
        this.cursor = cursor;
        this.fromIndex = fromIndex;
        this.toIndexExclusive = toIndexExclusive;
        this.nestedRowIndex = fromIndex - 1;
        this.ownedThreads = ownedThreads;
    }

    static BigQueryJsonResultSet of(Schema schema, long totalRows, BlockingQueue<BigQueryFieldValueListWrapper> buffer, BigQueryStatement statement, Thread[] ownedThreads, BigQuery bigQuery) {
        return new BigQueryJsonResultSet(schema, totalRows, buffer, statement, false, null, -1, -1, ownedThreads, bigQuery);
    }

    static BigQueryJsonResultSet of(Schema schema, long totalRows, BlockingQueue<BigQueryFieldValueListWrapper> buffer, BigQueryStatement statement, Thread[] ownedThreads) {
        return new BigQueryJsonResultSet(schema, totalRows, buffer, statement, false, null, -1, -1, ownedThreads, null);
    }

    BigQueryJsonResultSet() {
        super(null, null, null, false);
        this.totalRows = 0L;
        this.buffer = null;
        this.fromIndex = 0;
        this.ownedThreads = new Thread[0];
        this.toIndexExclusive = 0;
    }

    static BigQueryJsonResultSet getNestedResultSet(Schema schema, BigQueryFieldValueListWrapper cursor, int fromIndex, int toIndexExclusive) {
        return new BigQueryJsonResultSet(schema, -1L, null, null, true, cursor, fromIndex, toIndexExclusive, null, null);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.isNested) {
            if (this.cursor == null || this.cursor.getArrayFieldValueList() == null) {
                throw new IllegalStateException("Cursor/ArrayFieldValueList can not be null working with the nested record");
            }
            if (this.nestedRowIndex < this.toIndexExclusive - 1) {
                ++this.nestedRowIndex;
                return true;
            }
            this.afterLast = true;
            return false;
        }
        if (this.hasReachedEnd || this.isLast()) {
            this.afterLast = true;
            return false;
        }
        try {
            this.cursor = this.buffer.take();
            ++this.rowCnt;
            if (this.cursor.isLast()) {
                this.cursor = null;
                this.hasReachedEnd = true;
                return false;
            }
            return true;
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException("Error occurred while advancing the cursor. This could happen when connection is closed while we call the next method", ex);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.LOG.finest("++enter++");
        FieldValue value = this.getObjectInternal(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        if (this.isNested && columnIndex == 1) {
            return this.bigQueryTypeCoercer.coerceTo(Integer.class, value);
        }
        if (this.isNested && columnIndex == 2) {
            Field arrayField = this.schema.getFields().get(0);
            if (BigQueryBaseStruct.isStruct(arrayField)) {
                return new BigQueryJsonStruct(arrayField.getSubFields(), value);
            }
            Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)arrayField.getType().getStandardType());
            return this.bigQueryTypeCoercer.coerceTo(targetClass, value);
        }
        int extraIndex = this.isNested ? 2 : 1;
        Field fieldSchema = this.schemaFieldList.get(columnIndex - extraIndex);
        if (BigQueryBaseArray.isArray(fieldSchema)) {
            return new BigQueryJsonArray(fieldSchema, value);
        }
        if (BigQueryBaseStruct.isStruct(fieldSchema)) {
            return new BigQueryJsonStruct(fieldSchema.getSubFields(), value);
        }
        Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)fieldSchema.getType().getStandardType());
        return this.bigQueryTypeCoercer.coerceTo(targetClass, value);
    }

    private FieldValue getObjectInternal(int columnIndex) throws SQLException {
        FieldValue value;
        this.checkClosed();
        this.LOG.finest("++enter++");
        if (this.isNested) {
            boolean validIndexForNestedResultSet;
            boolean bl = validIndexForNestedResultSet = columnIndex == 1 || columnIndex == 2;
            if (!validIndexForNestedResultSet) {
                throw new IllegalArgumentException("Column index is required to be 1 or 2 for the nested arrays");
            }
            if (this.cursor.getArrayFieldValueList() == null || this.cursor.getArrayFieldValueList().get(this.nestedRowIndex) == null) {
                throw new IllegalStateException("ArrayFieldValueList cannot be null");
            }
            if (columnIndex == 1) {
                return FieldValue.of(FieldValue.Attribute.PRIMITIVE, Integer.toString(this.nestedRowIndex + 1));
            }
            value = this.cursor.getArrayFieldValueList().get(this.nestedRowIndex);
        } else {
            value = this.cursor.getFieldValueList().get(columnIndex - 1);
        }
        this.setWasNull(value.getValue());
        return value;
    }

    @Override
    public void close() {
        this.LOG.fine(String.format("Closing BigqueryJsonResultSet %s.", this));
        this.isClosed = true;
        if (this.ownedThreads != null) {
            for (Thread ownedThread : this.ownedThreads) {
                if (ownedThread.isInterrupted()) continue;
                ownedThread.interrupt();
            }
        }
        super.close();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        this.LOG.finest("++enter++");
        if (this.isNested) {
            return this.nestedRowIndex < this.fromIndex;
        }
        return this.cursor == null && this.rowCnt == 0L;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        this.LOG.finest("++enter++");
        return this.afterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        this.LOG.finest("++enter++");
        if (this.isNested) {
            return this.nestedRowIndex == this.fromIndex;
        }
        return this.rowCnt == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        this.LOG.finest("++enter++");
        if (this.isNested) {
            return this.nestedRowIndex == this.toIndexExclusive - 1;
        }
        return this.rowCnt == this.totalRows;
    }
}

