/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryBaseStruct;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import com.google.cloud.bigquery.jdbc.BigQueryJsonArray;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercionUtility;
import java.lang.reflect.Array;
import java.util.List;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldList;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValue;

@InternalApi
class BigQueryJsonStruct
extends BigQueryBaseStruct {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryJsonStruct.class.getName());
    private static final BigQueryTypeCoercer BIGQUERY_TYPE_COERCER = BigQueryTypeCoercionUtility.INSTANCE;
    private final FieldList schema;
    private final List<FieldValue> values;

    public BigQueryJsonStruct(FieldList schema, FieldValue values) {
        this.schema = schema;
        this.values = values == null || values.isNull() ? null : values.getRecordValue();
    }

    @Override
    FieldList getSchema() {
        return this.schema;
    }

    @Override
    public Object[] getAttributes() {
        LOG.finest("++enter++");
        int size = this.schema.size();
        Object[] attributes = (Object[])Array.newInstance(Object.class, size);
        for (int index = 0; index < size; ++index) {
            Field currentSchema = this.schema.get(index);
            FieldValue currentValue = this.values == null ? null : this.values.get(index);
            Object coercedValue = this.getValue(currentSchema, currentValue);
            Array.set(attributes, index, coercedValue);
        }
        return attributes;
    }

    private Object getValue(Field currentSchema, FieldValue currentValue) {
        LOG.finest("++enter++");
        if (BigQueryBaseArray.isArray(currentSchema)) {
            return new BigQueryJsonArray(currentSchema, currentValue);
        }
        if (BigQueryJsonStruct.isStruct(currentSchema)) {
            return new BigQueryJsonStruct(currentSchema.getSubFields(), currentValue);
        }
        Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)currentSchema.getType().getStandardType());
        return BIGQUERY_TYPE_COERCER.coerceTo(targetClass, currentValue);
    }
}

