/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcParameter;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import java.sql.SQLException;
import java.util.ArrayList;
import shaded.bqjdbc.com.google.cloud.bigquery.QueryJobConfiguration;
import shaded.bqjdbc.com.google.cloud.bigquery.QueryParameterValue;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTypeName;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcException;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;

class BigQueryParameterHandler {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private int parametersArraySize;
    ArrayList<BigQueryJdbcParameter> parametersList = new ArrayList(this.parametersArraySize);
    private long highestIndex = 0L;

    public BigQueryParameterHandler(int parameterCount) {
        this.parametersArraySize = parameterCount;
    }

    BigQueryParameterHandler(int parameterCount, ArrayList<BigQueryJdbcParameter> parametersList) {
        this.parametersArraySize = parameterCount;
        this.parametersList = parametersList;
    }

    QueryJobConfiguration.Builder configureParameters(QueryJobConfiguration.Builder jobConfigurationBuilder) throws SQLException {
        block3: {
            this.LOG.finest("++enter++");
            try {
                for (int i = 1; i <= this.parametersArraySize; ++i) {
                    Object parameterValue = this.getParameter(i);
                    StandardSQLTypeName sqlType = this.getSqlType(i);
                    this.LOG.info(String.format("Parameter %s of type %s at index %s added to QueryJobConfiguration", new Object[]{parameterValue, sqlType, i}));
                    jobConfigurationBuilder.addPositionalParameter(QueryParameterValue.of(parameterValue, sqlType));
                }
            }
            catch (NullPointerException e) {
                if (!e.getMessage().contains("Null type")) break block3;
                throw new BigQueryJdbcException("One or more parameters missing in Prepared statement.", e);
            }
        }
        return jobConfigurationBuilder;
    }

    void setParameter(int parameterIndex, Object value, Class type) throws BigQueryJdbcSqlFeatureNotSupportedException {
        this.LOG.finest("++enter++");
        this.LOG.finest(String.format("setParameter called by : %s", type.getName()));
        this.checkValidIndex(parameterIndex);
        int arrayIndex = parameterIndex - 1;
        if ((long)parameterIndex >= this.highestIndex || this.parametersList.get(arrayIndex) == null) {
            this.parametersList.ensureCapacity(parameterIndex);
            while (this.parametersList.size() < parameterIndex) {
                this.parametersList.add(null);
            }
            this.parametersList.set(arrayIndex, new BigQueryJdbcParameter());
        }
        this.highestIndex = Math.max((long)parameterIndex, this.highestIndex);
        BigQueryJdbcParameter parameter = this.parametersList.get(arrayIndex);
        parameter.setIndex(parameterIndex);
        parameter.setValue(value);
        parameter.setType(type);
        parameter.setSqlType(BigQueryJdbcTypeMappings.classToType(type));
        parameter.setParamName("");
        parameter.setParamType(BigQueryStatementParameterType.UNSPECIFIED);
        parameter.setScale(-1);
        this.LOG.finest(String.format("Parameter set { %s }", parameter.toString()));
    }

    private void checkValidIndex(int parameterIndex) {
        if (parameterIndex > this.parametersArraySize) {
            throw new IndexOutOfBoundsException("All parameters already provided.");
        }
    }

    Object getParameter(int index) {
        int arrayIndex = index - 1;
        if (this.parametersList.size() <= arrayIndex || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).getValue();
    }

    Class<?> getType(int index) {
        int arrayIndex = index - 1;
        if (this.parametersList.size() <= arrayIndex || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).getType();
    }

    StandardSQLTypeName getSqlType(int index) {
        int arrayIndex = index - 1;
        if (this.parametersList.size() <= arrayIndex || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).getSqlType();
    }

    void clearParameters() {
        this.LOG.finest("++enter++");
        this.parametersList.clear();
        this.highestIndex = 0L;
    }

    void setParameter(String paramName, Object value, Class<?> type, BigQueryStatementParameterType paramType, int scale) throws BigQueryJdbcSqlFeatureNotSupportedException {
        this.LOG.finest("++enter++");
        this.LOG.finest(String.format("setParameter called by : %s", type.getName()));
        if (paramName == null || paramName.isEmpty()) {
            throw new IllegalArgumentException("paramName cannot be null or empty");
        }
        BigQueryJdbcParameter parameter = null;
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!paramName.equals(p.getParamName())) continue;
            parameter = p;
            break;
        }
        if (parameter == null) {
            parameter = new BigQueryJdbcParameter();
            parameter.setIndex(-1);
        }
        parameter.setValue(value);
        parameter.setType(type);
        parameter.setSqlType(BigQueryJdbcTypeMappings.classToType(type));
        parameter.setParamName(paramName);
        parameter.setParamType(paramType);
        parameter.setScale(scale);
        if (parameter.getIndex() == -1) {
            this.parametersList.add(parameter);
        }
        this.LOG.finest(String.format("Parameter set { %s }", parameter.toString()));
    }

    void setParameter(int parameterIndex, Object value, Class<?> type, BigQueryStatementParameterType paramType, int scale) throws BigQueryJdbcSqlFeatureNotSupportedException {
        this.LOG.finest("++enter++");
        this.LOG.finest(String.format("setParameter called by : %s", type.getName()));
        this.checkValidIndex(parameterIndex);
        int arrayIndex = parameterIndex - 1;
        if ((long)parameterIndex >= this.highestIndex || this.parametersList.get(arrayIndex) == null) {
            this.parametersList.ensureCapacity(parameterIndex);
            while (this.parametersList.size() < parameterIndex) {
                this.parametersList.add(null);
            }
            this.parametersList.set(arrayIndex, new BigQueryJdbcParameter());
        }
        this.highestIndex = Math.max((long)parameterIndex, this.highestIndex);
        BigQueryJdbcParameter parameter = this.parametersList.get(arrayIndex);
        parameter.setIndex(parameterIndex);
        parameter.setValue(value);
        parameter.setType(type);
        parameter.setSqlType(BigQueryJdbcTypeMappings.classToType(type));
        parameter.setParamName("");
        parameter.setParamType(paramType);
        parameter.setScale(scale);
        this.LOG.finest(String.format("Parameter set { %s }", parameter.toString()));
    }

    Object getParameter(String name) {
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!name.equals(p.getParamName())) continue;
            return p.getValue();
        }
        return null;
    }

    BigQueryStatementParameterType getParameterType(int index) {
        int arrayIndex = index - 1;
        if (this.parametersList.size() <= arrayIndex || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).getParamType();
    }

    BigQueryStatementParameterType getParameterType(String name) {
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!name.equals(p.getParamName())) continue;
            return p.getParamType();
        }
        return null;
    }

    int getParameterScale(int index) {
        int arrayIndex = index - 1;
        if (this.parametersList.size() <= arrayIndex || this.parametersList.get(arrayIndex) == null) {
            return -1;
        }
        return this.parametersList.get(arrayIndex).getScale();
    }

    int getParameterScale(String name) {
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!name.equals(p.getParamName())) continue;
            return p.getScale();
        }
        return -1;
    }

    Class<?> getType(String name) {
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!name.equals(p.getParamName())) continue;
            return p.getType();
        }
        return null;
    }

    StandardSQLTypeName getSqlType(String name) {
        for (BigQueryJdbcParameter p : this.parametersList) {
            if (!name.equals(p.getParamName())) continue;
            return p.getSqlType();
        }
        return null;
    }

    static enum BigQueryStatementParameterType {
        UNSPECIFIED,
        IN,
        OUT,
        INOUT;

    }
}

