/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;

class BigQueryPooledConnection
implements PooledConnection {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private String id;
    private Connection bqConnection;
    private boolean inUse = false;
    private Long listenerPoolSize = 10L;
    private LinkedBlockingDeque<ConnectionEventListener> listeners;

    BigQueryPooledConnection(Connection bqConnection) {
        this.bqConnection = bqConnection;
        this.id = UUID.randomUUID().toString();
        String connectionUrl = ((BigQueryConnection)bqConnection).getConnectionUrl();
        if (connectionUrl != null && !connectionUrl.isEmpty()) {
            this.listenerPoolSize = BigQueryJdbcUrlUtility.parseListenerPoolSize(connectionUrl, this.toString());
        }
        this.listeners = this.getListenerPoolSize() > 0L ? new LinkedBlockingDeque(this.getListenerPoolSize().intValue()) : new LinkedBlockingDeque();
    }

    Long getListenerPoolSize() {
        return this.listenerPoolSize;
    }

    @VisibleForTesting
    boolean inUse() {
        return this.inUse;
    }

    @VisibleForTesting
    boolean isListenerPooled(ConnectionEventListener l) {
        return this.listeners.contains(l);
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.LOG.finest("++enter++");
        if (this.inUse) {
            throw new SQLException("PooledConnection is already in use.");
        }
        this.inUse = true;
        return new BigQueryPooledConnectionWrapper(this.bqConnection, this);
    }

    @Override
    public synchronized void close() throws SQLException {
        this.LOG.finest("++enter++");
        ConnectionEvent event = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.listeners) {
            listener.connectionClosed(event);
        }
        this.inUse = false;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.LOG.finest("++enter++");
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.LOG.finest("++enter++");
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            return;
        }
        this.listeners.remove(listener);
    }

    public synchronized void connectionHandleClosed(BigQueryPooledConnectionWrapper handle) {
        this.LOG.finest("++enter++");
        this.inUse = false;
        ConnectionEvent event = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.listeners) {
            listener.connectionClosed(event);
        }
        this.LOG.finest("Connection handle returned to the pool.");
    }

    public synchronized void fireConnectionError(SQLException e) {
        this.LOG.finest("++enter++");
        this.inUse = false;
        ConnectionEvent event = new ConnectionEvent(this, e);
        for (ConnectionEventListener listener : this.listeners) {
            listener.connectionErrorOccurred(event);
        }
        this.LOG.finest(String.format("Connection handle removed from the pool due to error: %s", e.getMessage()));
        for (ConnectionEventListener listener : this.listeners) {
            this.removeConnectionEventListener(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener arg0) {
        throw new UnsupportedOperationException("Method 'addStatementEventListener' is not supported by the BQ Driver");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener arg0) {
        throw new UnsupportedOperationException("Method 'removeStatementEventListener' is not supported by the BQ Driver");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigQueryPooledConnection other = (BigQueryPooledConnection)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    static class BigQueryPooledConnectionWrapper
    implements Connection {
        private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
        private Connection bqConnectionDelegate;
        private BigQueryPooledConnection pooledConnection;
        private boolean closed = false;

        public BigQueryPooledConnectionWrapper(Connection bqConnectionDelegate, BigQueryPooledConnection pooledConnection) {
            this.bqConnectionDelegate = bqConnectionDelegate;
            this.pooledConnection = pooledConnection;
        }

        @Override
        public void close() throws SQLException {
            this.LOG.finest("++enter++");
            if (!this.closed) {
                this.pooledConnection.connectionHandleClosed(this);
                this.closed = true;
                this.LOG.finest("Logical connection closed (returned to pool).");
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed || this.bqConnectionDelegate.isClosed();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.bqConnectionDelegate.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.bqConnectionDelegate.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.bqConnectionDelegate.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.bqConnectionDelegate.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.bqConnectionDelegate.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.bqConnectionDelegate.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.bqConnectionDelegate.rollback();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.bqConnectionDelegate.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.bqConnectionDelegate.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.bqConnectionDelegate.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.bqConnectionDelegate.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.bqConnectionDelegate.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.bqConnectionDelegate.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.bqConnectionDelegate.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.bqConnectionDelegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.bqConnectionDelegate.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.bqConnectionDelegate.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.bqConnectionDelegate.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.bqConnectionDelegate.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.bqConnectionDelegate.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.bqConnectionDelegate.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.bqConnectionDelegate.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.bqConnectionDelegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.bqConnectionDelegate.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.bqConnectionDelegate.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.bqConnectionDelegate.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.bqConnectionDelegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.bqConnectionDelegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndices) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql, columnIndices);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.bqConnectionDelegate.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.bqConnectionDelegate.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.bqConnectionDelegate.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.bqConnectionDelegate.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.bqConnectionDelegate.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.bqConnectionDelegate.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.bqConnectionDelegate.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.bqConnectionDelegate.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.bqConnectionDelegate.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.bqConnectionDelegate.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.bqConnectionDelegate.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.bqConnectionDelegate.createStruct(typeName, attributes);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.bqConnectionDelegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.bqConnectionDelegate.isWrapperFor(iface);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.bqConnectionDelegate.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.bqConnectionDelegate.getSchema();
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.bqConnectionDelegate.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.bqConnectionDelegate.getNetworkTimeout();
        }

        @Override
        public void abort(Executor arg0) throws SQLException {
            this.LOG.finest("++enter++");
            if (!this.closed) {
                SQLException e = new SQLException("Connection is being terminated and aborted");
                this.pooledConnection.fireConnectionError(e);
                this.closed = true;
                this.LOG.finest("Logical connection aborted (removed from pool).");
            }
            this.bqConnectionDelegate.abort(arg0);
        }
    }
}

