/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import shaded.bqjdbc.com.google.cloud.bigquery.JobStatistics;

class BigQuerySqlTypeConverter {
    BigQuerySqlTypeConverter() {
    }

    static BigQueryStatement.SqlType getSqlTypeFromStatementType(JobStatistics.QueryStatistics.StatementType statementType) {
        switch (statementType.toString()) {
            case "SELECT": {
                return BigQueryStatement.SqlType.SELECT;
            }
            case "INSERT": 
            case "UPDATE": 
            case "DELETE": 
            case "MERGE": {
                return BigQueryStatement.SqlType.DML;
            }
            case "CALL": {
                return BigQueryStatement.SqlType.DML_EXTRA;
            }
            case "CREATE_TABLE": 
            case "CREATE_TABLE_AS_SELECT": 
            case "CREATE_VIEW": 
            case "CREATE_MODEL": 
            case "CREATE_MATERIALIZED_VIEW": 
            case "CREATE_FUNCTION": 
            case "CREATE_TABLE_FUNCTION": 
            case "CREATE_PROCEDURE": 
            case "CREATE_ROW_ACCESS_POLICY": 
            case "CREATE_SCHEMA": 
            case "CREATE_SNAPSHOT_TABLE": 
            case "CREATE_SEARCH_INDEX": 
            case "DROP_TABLE": 
            case "DROP_EXTERNAL_TABLE": 
            case "DROP_VIEW": 
            case "DROP_MODEL": 
            case "DROP_MATERIALIZED_VIEW": 
            case "DROP_FUNCTION": 
            case "DROP_TABLE_FUNCTION": 
            case "DROP_PROCEDURE": 
            case "DROP_SEARCH_INDEX": 
            case "DROP_SCHEMA": 
            case "DROP_SNAPSHOT_TABLE": 
            case "DROP_ROW_ACCESS_POLICY": 
            case "ALTER_TABLE": 
            case "ALTER_VIEW": 
            case "ALTER_MATERIALIZED_VIEW": 
            case "ALTER_SCHEMA": 
            case "TRUNCATE_TABLE": 
            case "CREATE_EXTERNAL_TABLE": {
                return BigQueryStatement.SqlType.DDL;
            }
            case "SCRIPT": {
                return BigQueryStatement.SqlType.SCRIPT;
            }
            case "BEGIN_TRANSACTION": 
            case "COMMIT_TRANSACTION": 
            case "ROLLBACK_TRANSACTION": {
                return BigQueryStatement.SqlType.TCL;
            }
        }
        return BigQueryStatement.SqlType.OTHER;
    }
}

