/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryCoercion;
import com.google.cloud.bigquery.jdbc.BigQueryDefaultCoercions;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercerBuilder;
import java.util.Map;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldValue;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcCoercionException;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcCoercionNotFoundException;

@InternalApi
class BigQueryTypeCoercer {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryTypeCoercer.class.getName());
    static BigQueryTypeCoercer INSTANCE = BigQueryDefaultCoercions.builder().build();
    private final Map<Class<?>, Map<Class<?>, BigQueryCoercion<?, ?>>> allCoercions;

    BigQueryTypeCoercer(Map<Class<?>, Map<Class<?>, BigQueryCoercion<?, ?>>> allCoercions) {
        this.allCoercions = allCoercions;
    }

    <T> T coerceTo(Class<T> targetClass, Object value) {
        Class sourceClass;
        Class clazz = sourceClass = value == null ? Void.class : value.getClass();
        if (sourceClass == FieldValue.class && ((FieldValue)FieldValue.class.cast(value)).isNull()) {
            sourceClass = Void.class;
        }
        if (sourceClass.equals(targetClass)) {
            return targetClass.cast(value);
        }
        BigQueryCoercion coercion = this.findCoercion(sourceClass, targetClass);
        LOG.finest(() -> String.format("%s coercion for %s", coercion, value));
        if (sourceClass == Void.class && coercion == null) {
            return null;
        }
        if (coercion == null) {
            if (targetClass.equals(String.class)) {
                return (T)value.toString();
            }
            throw new BigQueryJdbcCoercionNotFoundException(sourceClass, targetClass);
        }
        try {
            return coercion.coerce(sourceClass != Void.class ? value : null);
        }
        catch (Exception ex) {
            throw new BigQueryJdbcCoercionException(ex);
        }
    }

    static BigQueryTypeCoercerBuilder builder() {
        return BigQueryDefaultCoercions.builder();
    }

    private <T> BigQueryCoercion<Object, T> findCoercion(Class<?> sourceClass, Class<T> targetClass) {
        Map<Class<?>, BigQueryCoercion<?, ?>> bySourceMap = this.allCoercions.get(sourceClass);
        if (bySourceMap == null) {
            Class<?> registeredAbstractClass = sourceClass.getSuperclass();
            bySourceMap = this.allCoercions.get(registeredAbstractClass);
        }
        if (bySourceMap == null) {
            return null;
        }
        return bySourceMap.get(targetClass);
    }
}

