/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import com.google.cloud.bigquery.jdbc.BigQueryPooledConnection;
import com.google.cloud.bigquery.jdbc.DataSource;
import com.google.cloud.bigquery.jdbc.PooledConnectionListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;

public class PooledConnectionDataSource
extends DataSource
implements ConnectionPoolDataSource {
    private PooledConnectionListener connectionPoolManager = null;
    Connection bqConnection = null;

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.connectionPoolManager != null && !this.connectionPoolManager.isConnectionPoolEmpty()) {
            return this.connectionPoolManager.getPooledConnection();
        }
        if (this.bqConnection == null) {
            this.bqConnection = super.getConnection();
        }
        if (this.bqConnection == null) {
            throw new BigQueryJdbcRuntimeException("Cannot get pooled connection: unable to get underlying physical connection");
        }
        String connectionURl = ((BigQueryConnection)this.bqConnection).getConnectionUrl();
        Long connectionPoolSize = BigQueryJdbcUrlUtility.parseConnectionPoolSize(connectionURl, this.toString());
        if (this.connectionPoolManager == null) {
            this.connectionPoolManager = new PooledConnectionListener(connectionPoolSize);
        }
        BigQueryPooledConnection bqPooledConnection = new BigQueryPooledConnection(this.bqConnection);
        bqPooledConnection.addConnectionEventListener(this.connectionPoolManager);
        return bqPooledConnection;
    }

    @VisibleForTesting
    void setConnection(Connection connection) {
        this.bqConnection = connection;
    }

    @VisibleForTesting
    public PooledConnectionListener getConnectionPoolManager() {
        return this.connectionPoolManager;
    }

    @Override
    public PooledConnection getPooledConnection(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("This operation is not supported by the driver");
    }
}

