/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryPooledConnection;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionListener
implements ConnectionEventListener {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private String id = UUID.randomUUID().toString();
    private LinkedBlockingDeque<PooledConnection> connectionPool;
    private Long connectionPoolSize = 0L;

    public PooledConnectionListener(Long connPoolSize) {
        this.connectionPoolSize = connPoolSize;
        this.connectionPool = this.getConnectionPoolSize() > 0L ? new LinkedBlockingDeque(this.getConnectionPoolSize().intValue()) : new LinkedBlockingDeque();
    }

    public Long getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getConnectionPoolCurrentCapacity() {
        return this.connectionPool.size();
    }

    public boolean isConnectionPoolEmpty() {
        return this.connectionPool != null && this.connectionPool.isEmpty();
    }

    PooledConnection getPooledConnection() {
        if (this.isConnectionPoolEmpty()) {
            this.LOG.warning("Connection pool is empty");
            return null;
        }
        return this.connectionPool.getFirst();
    }

    void addConnection(PooledConnection connection) {
        this.LOG.finest("++enter++");
        if (connection == null) {
            this.LOG.warning("Connection passed in is null");
            return;
        }
        if (this.connectionPool.contains(connection)) {
            this.LOG.warning("Connection already in the pool");
            return;
        }
        this.connectionPool.add(connection);
    }

    void removeConnection(PooledConnection connection) {
        this.LOG.finest("++enter++");
        if (connection == null) {
            this.LOG.warning("Connection passed in is null");
            return;
        }
        if (!this.connectionPool.contains(connection)) {
            this.LOG.warning("Connection already in the pool");
            return;
        }
        this.connectionPool.remove(connection);
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.LOG.finest("++enter++");
        Object eventSource = event.getSource();
        if (eventSource == null || !(eventSource instanceof BigQueryPooledConnection) || !eventSource.getClass().isAssignableFrom(BigQueryPooledConnection.class)) {
            throw new IllegalArgumentException("Invalid ConnectionEvent source passed to connectionClosed. Expecting BigQueryPooledConnection.");
        }
        BigQueryPooledConnection bqPooledConnection = (BigQueryPooledConnection)eventSource;
        this.addConnection(bqPooledConnection);
        this.LOG.finest("Added pooled connection to connection pool");
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.LOG.finest("++enter++");
        Object eventSource = event.getSource();
        if (eventSource == null || !(eventSource instanceof BigQueryPooledConnection) || !eventSource.getClass().isAssignableFrom(BigQueryPooledConnection.class)) {
            throw new IllegalArgumentException("Invalid ConnectionEvent source passed to connectionClosed. Expecting BigQueryPooledConnection.");
        }
        BigQueryPooledConnection bqPooledConnection = (BigQueryPooledConnection)eventSource;
        this.removeConnection(bqPooledConnection);
        String errorMessage = event.getSQLException() != null ? event.getSQLException().getMessage() : "Connection error occured";
        this.LOG.finest(String.format("Removed pooled connection from connection pool due to error: %s", errorMessage));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PooledConnectionListener other = (PooledConnectionListener)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

