/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.auth.oauth2;

import java.io.IOException;
import shaded.bqjdbc.com.google.api.client.auth.oauth2.TokenErrorResponse;
import shaded.bqjdbc.com.google.api.client.http.HttpMediaType;
import shaded.bqjdbc.com.google.api.client.http.HttpResponse;
import shaded.bqjdbc.com.google.api.client.http.HttpResponseException;
import shaded.bqjdbc.com.google.api.client.json.JsonFactory;
import shaded.bqjdbc.com.google.api.client.json.JsonObjectParser;
import shaded.bqjdbc.com.google.api.client.util.Preconditions;
import shaded.bqjdbc.com.google.api.client.util.StringUtils;
import shaded.bqjdbc.com.google.api.client.util.Strings;

public class TokenResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 4020689092957439244L;
    private final transient TokenErrorResponse details;

    TokenResponseException(HttpResponseException.Builder builder, TokenErrorResponse details) {
        super(builder);
        this.details = details;
    }

    public final TokenErrorResponse getDetails() {
        return this.details;
    }

    public static TokenResponseException from(JsonFactory jsonFactory, HttpResponse response) {
        HttpResponseException.Builder builder = new HttpResponseException.Builder(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        Preconditions.checkNotNull(jsonFactory);
        TokenErrorResponse details = null;
        String detailString = null;
        String contentType = response.getContentType();
        try {
            if (!response.isSuccessStatusCode() && contentType != null && response.getContent() != null && HttpMediaType.equalsIgnoreParameters("application/json; charset=UTF-8", contentType)) {
                details = new JsonObjectParser(jsonFactory).parseAndClose(response.getContent(), response.getContentCharset(), TokenErrorResponse.class);
                detailString = details.toPrettyString();
            } else {
                detailString = response.parseAsString();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        StringBuilder message = HttpResponseException.computeMessageBuffer(response);
        if (!Strings.isNullOrEmpty(detailString)) {
            message.append(StringUtils.LINE_SEPARATOR).append(detailString);
            builder.setContent(detailString);
        }
        builder.setMessage(message.toString());
        return new TokenResponseException(builder, details);
    }
}

