/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.extensions.appengine.datastore;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import shaded.bqjdbc.com.google.api.client.util.IOUtils;
import shaded.bqjdbc.com.google.api.client.util.Lists;
import shaded.bqjdbc.com.google.api.client.util.Maps;
import shaded.bqjdbc.com.google.api.client.util.Preconditions;
import shaded.bqjdbc.com.google.api.client.util.Sets;
import shaded.bqjdbc.com.google.api.client.util.store.AbstractDataStore;
import shaded.bqjdbc.com.google.api.client.util.store.AbstractDataStoreFactory;
import shaded.bqjdbc.com.google.api.client.util.store.DataStore;
import shaded.bqjdbc.com.google.api.client.util.store.DataStoreUtils;
import shaded.bqjdbc.com.google.appengine.api.datastore.Blob;
import shaded.bqjdbc.com.google.appengine.api.datastore.DatastoreService;
import shaded.bqjdbc.com.google.appengine.api.datastore.DatastoreServiceFactory;
import shaded.bqjdbc.com.google.appengine.api.datastore.Entity;
import shaded.bqjdbc.com.google.appengine.api.datastore.EntityNotFoundException;
import shaded.bqjdbc.com.google.appengine.api.datastore.Key;
import shaded.bqjdbc.com.google.appengine.api.datastore.KeyFactory;
import shaded.bqjdbc.com.google.appengine.api.datastore.Query;
import shaded.bqjdbc.com.google.appengine.api.memcache.Expiration;
import shaded.bqjdbc.com.google.appengine.api.memcache.MemcacheService;
import shaded.bqjdbc.com.google.appengine.api.memcache.MemcacheServiceFactory;

public class AppEngineDataStoreFactory
extends AbstractDataStoreFactory {
    final boolean disableMemcache;
    final Expiration memcacheExpiration;

    @Override
    protected <V extends Serializable> DataStore<V> createDataStore(String id) throws IOException {
        return new AppEngineDataStore(this, id);
    }

    public AppEngineDataStoreFactory() {
        this(new Builder());
    }

    public AppEngineDataStoreFactory(Builder builder) {
        this.disableMemcache = builder.disableMemcache;
        this.memcacheExpiration = builder.memcacheExpiration;
    }

    public boolean getDisableMemcache() {
        return this.disableMemcache;
    }

    public static AppEngineDataStoreFactory getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static class Builder {
        boolean disableMemcache;
        Expiration memcacheExpiration;

        public final boolean getDisableMemcache() {
            return this.disableMemcache;
        }

        public Builder setDisableMemcache(boolean disableMemcache) {
            this.disableMemcache = disableMemcache;
            return this;
        }

        public final Expiration getMemcacheExpiration() {
            return this.memcacheExpiration;
        }

        public Builder setMemcacheExpiration(Expiration memcacheExpiration) {
            this.memcacheExpiration = memcacheExpiration;
            return this;
        }

        public AppEngineDataStoreFactory build() {
            return new AppEngineDataStoreFactory(this);
        }
    }

    static class AppEngineDataStore<V extends Serializable>
    extends AbstractDataStore<V> {
        private final Lock lock = new ReentrantLock();
        private static final String FIELD_VALUE = "value";
        private final MemcacheService memcache;
        private final DatastoreService dataStoreService;
        final Expiration memcacheExpiration;

        AppEngineDataStore(AppEngineDataStoreFactory dataStoreFactory, String id) {
            super(dataStoreFactory, id);
            this.memcache = dataStoreFactory.disableMemcache ? null : MemcacheServiceFactory.getMemcacheService((String)id);
            this.memcacheExpiration = dataStoreFactory.memcacheExpiration;
            this.dataStoreService = DatastoreServiceFactory.getDatastoreService();
        }

        private V deserialize(Entity entity) throws IOException {
            Blob blob = (Blob)entity.getProperty(FIELD_VALUE);
            return (V)IOUtils.deserialize(blob.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> keySet() throws IOException {
            this.lock.lock();
            try {
                HashSet<String> result = Sets.newHashSet();
                for (Entity entity : this.query(true)) {
                    result.add(entity.getKey().getName());
                }
                Set set = Collections.unmodifiableSet(result);
                return set;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() throws IOException {
            this.lock.lock();
            try {
                if (this.memcache != null) {
                    this.memcache.clearAll();
                }
                ArrayList<V> result = Lists.newArrayList();
                HashMap<String, V> map = this.memcache != null ? Maps.newHashMap() : null;
                for (Entity entity : this.query(false)) {
                    V value = this.deserialize(entity);
                    result.add(value);
                    if (map == null) continue;
                    map.put(entity.getKey().getName(), value);
                }
                if (this.memcache != null) {
                    this.memcache.putAll(map, this.memcacheExpiration);
                }
                List list = Collections.unmodifiableList(result);
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(String key) throws IOException {
            if (key == null) {
                return null;
            }
            this.lock.lock();
            try {
                Entity entity;
                if (this.memcache != null && this.memcache.contains((Object)key)) {
                    Serializable result;
                    Serializable serializable = result = (Serializable)this.memcache.get((Object)key);
                    return (V)serializable;
                }
                Key dataKey = KeyFactory.createKey((String)this.getId(), (String)key);
                try {
                    entity = this.dataStoreService.get(dataKey);
                }
                catch (EntityNotFoundException exception) {
                    if (this.memcache != null) {
                        this.memcache.delete((Object)key);
                    }
                    V v = null;
                    this.lock.unlock();
                    return v;
                }
                V result = this.deserialize(entity);
                if (this.memcache != null) {
                    this.memcache.put((Object)key, result, this.memcacheExpiration);
                }
                V v = result;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppEngineDataStore<V> set(String key, V value) throws IOException {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            this.lock.lock();
            try {
                Entity entity = new Entity(this.getId(), key);
                entity.setUnindexedProperty(FIELD_VALUE, (Object)new Blob(IOUtils.serialize(value)));
                this.dataStoreService.put(entity);
                if (this.memcache != null) {
                    this.memcache.put((Object)key, value, this.memcacheExpiration);
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public DataStore<V> delete(String key) throws IOException {
            if (key == null) {
                return this;
            }
            this.lock.lock();
            try {
                this.dataStoreService.delete(new Key[]{KeyFactory.createKey((String)this.getId(), (String)key)});
                if (this.memcache != null) {
                    this.memcache.delete((Object)key);
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppEngineDataStore<V> clear() throws IOException {
            this.lock.lock();
            try {
                if (this.memcache != null) {
                    this.memcache.clearAll();
                }
                ArrayList<Key> keys = Lists.newArrayList();
                for (Entity entity : this.query(true)) {
                    keys.add(entity.getKey());
                }
                this.dataStoreService.delete(keys);
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public AppEngineDataStoreFactory getDataStoreFactory() {
            return (AppEngineDataStoreFactory)super.getDataStoreFactory();
        }

        public String toString() {
            return DataStoreUtils.toString(this);
        }

        private Iterable<Entity> query(boolean keysOnly) {
            Query query = new Query(this.getId());
            if (keysOnly) {
                query.setKeysOnly();
            }
            return this.dataStoreService.prepare(query).asIterable();
        }
    }

    static class InstanceHolder {
        static final AppEngineDataStoreFactory INSTANCE = new AppEngineDataStoreFactory();

        InstanceHolder() {
        }
    }
}

