/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.extensions.appengine.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import shaded.bqjdbc.com.google.api.client.extensions.appengine.http.UrlFetchResponse;
import shaded.bqjdbc.com.google.api.client.http.LowLevelHttpRequest;
import shaded.bqjdbc.com.google.api.client.http.LowLevelHttpResponse;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.FetchOptions;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.HTTPHeader;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.HTTPMethod;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.HTTPRequest;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.HTTPResponse;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.URLFetchService;
import shaded.bqjdbc.com.google.appengine.api.urlfetch.URLFetchServiceFactory;

final class UrlFetchRequest
extends LowLevelHttpRequest {
    private final HTTPRequest request;

    UrlFetchRequest(FetchOptions fetchOptions, HTTPMethod method, String url) throws IOException {
        this.request = new HTTPRequest(new URL(url), method, fetchOptions);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(new HTTPHeader(name, value));
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) {
        this.request.getFetchOptions().setDeadline(Double.valueOf(connectTimeout == 0 || readTimeout == 0 ? Double.MAX_VALUE : (double)(connectTimeout + readTimeout) / 1000.0));
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            String contentEncoding;
            String contentType = this.getContentType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.getContentEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getStreamingContent().writeTo(out);
            byte[] payload = out.toByteArray();
            if (payload.length != 0) {
                this.request.setPayload(payload);
            }
        }
        URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        HTTPResponse response = service.fetch(this.request);
        return new UrlFetchResponse(response);
    }
}

