/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.googleapis.apache.v2;

import java.io.IOException;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import shaded.bqjdbc.com.google.api.client.googleapis.GoogleUtils;
import shaded.bqjdbc.com.google.api.client.googleapis.mtls.MtlsProvider;
import shaded.bqjdbc.com.google.api.client.googleapis.mtls.MtlsUtils;
import shaded.bqjdbc.com.google.api.client.http.apache.v2.ApacheHttpTransport;
import shaded.bqjdbc.com.google.api.client.util.Beta;
import shaded.bqjdbc.com.google.api.client.util.SslUtils;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.org.apache.http.config.Registry;
import shaded.bqjdbc.org.apache.http.config.RegistryBuilder;
import shaded.bqjdbc.org.apache.http.conn.socket.ConnectionSocketFactory;
import shaded.bqjdbc.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import shaded.bqjdbc.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.bqjdbc.org.apache.http.impl.client.CloseableHttpClient;
import shaded.bqjdbc.org.apache.http.impl.client.HttpClientBuilder;
import shaded.bqjdbc.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import shaded.bqjdbc.org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public final class GoogleApacheHttpTransport {
    public static ApacheHttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        return GoogleApacheHttpTransport.newTrustedTransport(MtlsUtils.getDefaultMtlsProvider());
    }

    @Beta
    public static ApacheHttpTransport newTrustedTransport(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
        SocketFactoryRegistryHandler handler = new SocketFactoryRegistryHandler(mtlsProvider);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(handler.getSocketFactoryRegistry(), null, null, null, -1L, TimeUnit.MILLISECONDS);
        connectionManager.setValidateAfterInactivity(-1);
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setMaxConnTotal(200).setMaxConnPerRoute(20).setRoutePlanner(new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setConnectionManager(connectionManager).disableRedirectHandling().disableAutomaticRetries().build();
        return new ApacheHttpTransport(client, handler.isMtls());
    }

    private GoogleApacheHttpTransport() {
    }

    @VisibleForTesting
    static class SocketFactoryRegistryHandler {
        private final Registry<ConnectionSocketFactory> socketFactoryRegistry;
        private final boolean isMtls;

        public SocketFactoryRegistryHandler(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
            KeyStore mtlsKeyStore = null;
            String mtlsKeyStorePassword = null;
            if (mtlsProvider.useMtlsClientCertificate()) {
                mtlsKeyStore = mtlsProvider.getKeyStore();
                mtlsKeyStorePassword = mtlsProvider.getKeyStorePassword();
            }
            KeyStore trustStore = GoogleUtils.getCertificateTrustStore();
            SSLContext sslContext = SslUtils.getTlsSslContext();
            if (mtlsKeyStore != null && mtlsKeyStorePassword != null) {
                this.isMtls = true;
                SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory(), mtlsKeyStore, mtlsKeyStorePassword, SslUtils.getDefaultKeyManagerFactory());
            } else {
                this.isMtls = false;
                SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory());
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
            this.socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)socketFactory)).build();
        }

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return this.socketFactoryRegistry;
        }

        public boolean isMtls() {
            return this.isMtls;
        }
    }
}

