/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.googleapis.batch;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import shaded.bqjdbc.com.google.api.client.http.AbstractHttpContent;
import shaded.bqjdbc.com.google.api.client.http.HttpContent;
import shaded.bqjdbc.com.google.api.client.http.HttpHeaders;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;

class HttpRequestContent
extends AbstractHttpContent {
    static final String NEWLINE = "\r\n";
    private final HttpRequest request;
    private static final String HTTP_VERSION = "HTTP/1.1";

    HttpRequestContent(HttpRequest request) {
        super("application/http");
        this.request = request;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.getCharset());
        writer.write(this.request.getRequestMethod());
        writer.write(" ");
        writer.write(this.request.getUrl().build());
        writer.write(" ");
        writer.write(HTTP_VERSION);
        writer.write(NEWLINE);
        HttpHeaders headers = new HttpHeaders();
        headers.fromHttpHeaders(this.request.getHeaders());
        headers.setAcceptEncoding(null).setUserAgent(null).setContentEncoding(null).setContentType(null).setContentLength(null);
        HttpContent content = this.request.getContent();
        if (content != null) {
            headers.setContentType(content.getType());
            long contentLength = content.getLength();
            if (contentLength != -1L) {
                headers.setContentLength(contentLength);
            }
        }
        HttpHeaders.serializeHeadersForMultipartRequests(headers, null, null, writer);
        writer.write(NEWLINE);
        ((Writer)writer).flush();
        if (content != null) {
            content.writeTo(out);
        }
    }
}

