/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.googleapis.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.bqjdbc.com.google.api.client.googleapis.GoogleUtils;
import shaded.bqjdbc.com.google.api.client.googleapis.MethodOverride;
import shaded.bqjdbc.com.google.api.client.googleapis.batch.BatchCallback;
import shaded.bqjdbc.com.google.api.client.googleapis.batch.BatchRequest;
import shaded.bqjdbc.com.google.api.client.googleapis.media.MediaHttpDownloader;
import shaded.bqjdbc.com.google.api.client.googleapis.media.MediaHttpUploader;
import shaded.bqjdbc.com.google.api.client.googleapis.services.AbstractGoogleClient;
import shaded.bqjdbc.com.google.api.client.http.AbstractInputStreamContent;
import shaded.bqjdbc.com.google.api.client.http.EmptyContent;
import shaded.bqjdbc.com.google.api.client.http.GZipEncoding;
import shaded.bqjdbc.com.google.api.client.http.GenericUrl;
import shaded.bqjdbc.com.google.api.client.http.HttpContent;
import shaded.bqjdbc.com.google.api.client.http.HttpHeaders;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;
import shaded.bqjdbc.com.google.api.client.http.HttpRequestFactory;
import shaded.bqjdbc.com.google.api.client.http.HttpRequestInitializer;
import shaded.bqjdbc.com.google.api.client.http.HttpResponse;
import shaded.bqjdbc.com.google.api.client.http.HttpResponseException;
import shaded.bqjdbc.com.google.api.client.http.HttpResponseInterceptor;
import shaded.bqjdbc.com.google.api.client.http.UriTemplate;
import shaded.bqjdbc.com.google.api.client.util.GenericData;
import shaded.bqjdbc.com.google.api.client.util.Preconditions;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.Joiner;
import shaded.bqjdbc.com.google.common.base.StandardSystemProperty;

public abstract class AbstractGoogleClientRequest<T>
extends GenericData {
    public static final String USER_AGENT_SUFFIX = "Google-API-Java-Client";
    private static final String API_CLIENT_HEADER = "X-Goog-Api-Client";
    protected static final String API_VERSION_HEADER = "X-Goog-Api-Version";
    private final AbstractGoogleClient abstractGoogleClient;
    private final String requestMethod;
    private final String uriTemplate;
    private final HttpContent httpContent;
    private HttpHeaders requestHeaders = new HttpHeaders();
    private HttpHeaders lastResponseHeaders;
    private int lastStatusCode = -1;
    private String lastStatusMessage;
    private boolean disableGZipContent;
    private boolean returnRawInputStream;
    private Class<T> responseClass;
    private MediaHttpUploader uploader;
    private MediaHttpDownloader downloader;

    protected AbstractGoogleClientRequest(AbstractGoogleClient abstractGoogleClient, String requestMethod, String uriTemplate, HttpContent httpContent, Class<T> responseClass) {
        this.responseClass = Preconditions.checkNotNull(responseClass);
        this.abstractGoogleClient = Preconditions.checkNotNull(abstractGoogleClient);
        this.requestMethod = Preconditions.checkNotNull(requestMethod);
        this.uriTemplate = Preconditions.checkNotNull(uriTemplate);
        this.httpContent = httpContent;
        String applicationName = abstractGoogleClient.getApplicationName();
        if (applicationName != null) {
            this.requestHeaders.setUserAgent(applicationName + " " + USER_AGENT_SUFFIX + "/" + GoogleUtils.VERSION);
        } else {
            this.requestHeaders.setUserAgent("Google-API-Java-Client/" + GoogleUtils.VERSION);
        }
        this.requestHeaders.set(API_CLIENT_HEADER, ApiClientVersion.DEFAULT_VERSION);
    }

    public final boolean getDisableGZipContent() {
        return this.disableGZipContent;
    }

    public final boolean getReturnRawInputSteam() {
        return this.returnRawInputStream;
    }

    public AbstractGoogleClientRequest<T> setDisableGZipContent(boolean disableGZipContent) {
        this.disableGZipContent = disableGZipContent;
        return this;
    }

    public AbstractGoogleClientRequest<T> setReturnRawInputStream(boolean returnRawInputStream) {
        this.returnRawInputStream = returnRawInputStream;
        return this;
    }

    public final String getRequestMethod() {
        return this.requestMethod;
    }

    public final String getUriTemplate() {
        return this.uriTemplate;
    }

    public final HttpContent getHttpContent() {
        return this.httpContent;
    }

    public AbstractGoogleClient getAbstractGoogleClient() {
        return this.abstractGoogleClient;
    }

    public final HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public AbstractGoogleClientRequest<T> setRequestHeaders(HttpHeaders headers) {
        this.requestHeaders = headers;
        return this;
    }

    @VisibleForTesting
    String getApiVersionHeader() {
        return (String)this.requestHeaders.get(API_VERSION_HEADER);
    }

    public final HttpHeaders getLastResponseHeaders() {
        return this.lastResponseHeaders;
    }

    public final int getLastStatusCode() {
        return this.lastStatusCode;
    }

    public final String getLastStatusMessage() {
        return this.lastStatusMessage;
    }

    public final Class<T> getResponseClass() {
        return this.responseClass;
    }

    public final MediaHttpUploader getMediaHttpUploader() {
        return this.uploader;
    }

    protected final void initializeMediaUpload(AbstractInputStreamContent mediaContent) {
        HttpRequestFactory requestFactory = this.abstractGoogleClient.getRequestFactory();
        String applicationName = this.abstractGoogleClient.getApplicationName();
        HttpRequestInitializer requestInitializer = AbstractGoogleClientRequest.mediaUploadRequestUserAgentInitializer(applicationName, requestFactory.getInitializer());
        this.uploader = new MediaHttpUploader(mediaContent, requestFactory.getTransport(), requestInitializer);
        this.uploader.setInitiationRequestMethod(this.requestMethod);
        if (this.httpContent != null) {
            this.uploader.setMetadata(this.httpContent);
        }
    }

    private static HttpRequestInitializer mediaUploadRequestUserAgentInitializer(final String applicationName, final HttpRequestInitializer originalInitializer) {
        if (applicationName == null) {
            return originalInitializer;
        }
        if (originalInitializer == null) {
            return new HttpRequestInitializer(){

                @Override
                public void initialize(HttpRequest request) {
                    HttpHeaders headers = request.getHeaders();
                    headers.setUserAgent(applicationName);
                }
            };
        }
        return new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) throws IOException {
                originalInitializer.initialize(request);
                HttpHeaders headers = request.getHeaders();
                headers.setUserAgent(applicationName);
            }
        };
    }

    public final MediaHttpDownloader getMediaHttpDownloader() {
        return this.downloader;
    }

    protected final void initializeMediaDownload() {
        HttpRequestFactory requestFactory = this.abstractGoogleClient.getRequestFactory();
        this.downloader = new MediaHttpDownloader(requestFactory.getTransport(), requestFactory.getInitializer());
    }

    public GenericUrl buildHttpRequestUrl() {
        return new GenericUrl(UriTemplate.expand(this.abstractGoogleClient.getBaseUrl(), this.uriTemplate, this, true));
    }

    public HttpRequest buildHttpRequest() throws IOException {
        return this.buildHttpRequest(false);
    }

    protected HttpRequest buildHttpRequestUsingHead() throws IOException {
        return this.buildHttpRequest(true);
    }

    private HttpRequest buildHttpRequest(boolean usingHead) throws IOException {
        Preconditions.checkArgument(this.uploader == null);
        Preconditions.checkArgument(!usingHead || this.requestMethod.equals("GET"));
        String requestMethodToUse = usingHead ? "HEAD" : this.requestMethod;
        final HttpRequest httpRequest = this.getAbstractGoogleClient().getRequestFactory().buildRequest(requestMethodToUse, this.buildHttpRequestUrl(), this.httpContent);
        new MethodOverride().intercept(httpRequest);
        httpRequest.setParser(this.getAbstractGoogleClient().getObjectParser());
        if (this.httpContent == null && (this.requestMethod.equals("POST") || this.requestMethod.equals("PUT") || this.requestMethod.equals("PATCH"))) {
            httpRequest.setContent(new EmptyContent());
        }
        httpRequest.getHeaders().putAll(this.requestHeaders);
        if (!this.disableGZipContent) {
            httpRequest.setEncoding(new GZipEncoding());
        }
        httpRequest.setResponseReturnRawInputStream(this.returnRawInputStream);
        final HttpResponseInterceptor responseInterceptor = httpRequest.getResponseInterceptor();
        httpRequest.setResponseInterceptor(new HttpResponseInterceptor(){

            @Override
            public void interceptResponse(HttpResponse response) throws IOException {
                if (responseInterceptor != null) {
                    responseInterceptor.interceptResponse(response);
                }
                if (!response.isSuccessStatusCode() && httpRequest.getThrowExceptionOnExecuteError()) {
                    throw AbstractGoogleClientRequest.this.newExceptionOnError(response);
                }
            }
        });
        return httpRequest;
    }

    public HttpResponse executeUnparsed() throws IOException {
        return this.executeUnparsed(false);
    }

    protected HttpResponse executeMedia() throws IOException {
        this.set("alt", "media");
        return this.executeUnparsed();
    }

    protected HttpResponse executeUsingHead() throws IOException {
        Preconditions.checkArgument(this.uploader == null);
        HttpResponse response = this.executeUnparsed(true);
        response.ignore();
        return response;
    }

    private HttpResponse executeUnparsed(boolean usingHead) throws IOException {
        HttpResponse response;
        if (this.uploader == null) {
            response = this.buildHttpRequest(usingHead).execute();
        } else {
            GenericUrl httpRequestUrl = this.buildHttpRequestUrl();
            HttpRequest httpRequest = this.getAbstractGoogleClient().getRequestFactory().buildRequest(this.requestMethod, httpRequestUrl, this.httpContent);
            boolean throwExceptionOnExecuteError = httpRequest.getThrowExceptionOnExecuteError();
            response = this.uploader.setInitiationHeaders(this.requestHeaders).setDisableGZipContent(this.disableGZipContent).upload(httpRequestUrl);
            response.getRequest().setParser(this.getAbstractGoogleClient().getObjectParser());
            if (throwExceptionOnExecuteError && !response.isSuccessStatusCode()) {
                throw this.newExceptionOnError(response);
            }
        }
        this.lastResponseHeaders = response.getHeaders();
        this.lastStatusCode = response.getStatusCode();
        this.lastStatusMessage = response.getStatusMessage();
        return response;
    }

    protected IOException newExceptionOnError(HttpResponse response) {
        return new HttpResponseException(response);
    }

    public T execute() throws IOException {
        return this.executeUnparsed().parseAs(this.responseClass);
    }

    public InputStream executeAsInputStream() throws IOException {
        return this.executeUnparsed().getContent();
    }

    protected InputStream executeMediaAsInputStream() throws IOException {
        return this.executeMedia().getContent();
    }

    public void executeAndDownloadTo(OutputStream outputStream) throws IOException {
        this.executeUnparsed().download(outputStream);
    }

    protected void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
        if (this.downloader == null) {
            this.executeMedia().download(outputStream);
        } else {
            this.downloader.download(this.buildHttpRequestUrl(), this.requestHeaders, outputStream);
        }
    }

    public final <E> void queue(BatchRequest batchRequest, Class<E> errorClass, BatchCallback<T, E> callback) throws IOException {
        Preconditions.checkArgument(this.uploader == null, "Batching media requests is not supported");
        batchRequest.queue(this.buildHttpRequest(), this.getResponseClass(), errorClass, callback);
    }

    @Override
    public AbstractGoogleClientRequest<T> set(String fieldName, Object value) {
        return (AbstractGoogleClientRequest)super.set(fieldName, value);
    }

    protected final void checkRequiredParameter(Object value, String name) {
        Preconditions.checkArgument(this.abstractGoogleClient.getSuppressRequiredParameterChecks() || value != null, "Required parameter %s must be specified", name);
    }

    static class ApiClientVersion {
        static final String DEFAULT_VERSION = new ApiClientVersion().toString();
        private final String versionString;

        ApiClientVersion() {
            this(ApiClientVersion.getJavaVersion(), StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_VERSION.value(), GoogleUtils.VERSION);
        }

        ApiClientVersion(String javaVersion, String osName, String osVersion, String clientVersion) {
            StringBuilder sb = new StringBuilder("gl-java/");
            sb.append(ApiClientVersion.formatSemver(javaVersion));
            sb.append(" gdcl/");
            sb.append(ApiClientVersion.formatSemver(clientVersion));
            if (osName != null && osVersion != null) {
                sb.append(" ");
                sb.append(ApiClientVersion.formatName(osName));
                sb.append("/");
                sb.append(ApiClientVersion.formatSemver(osVersion));
            }
            this.versionString = sb.toString();
        }

        public String toString() {
            Object[] tokens;
            String imageCode = System.getProperty("shaded.bqjdbc.org.graalvm.nativeimage.imagecode");
            if (imageCode != null && imageCode.equals("runtime") && (tokens = this.versionString.split(" ")).length > 0 && tokens[0].startsWith("gl-java")) {
                tokens[0] = tokens[0] + "-graalvm";
                return Joiner.on(" ").join(tokens);
            }
            return this.versionString;
        }

        private static String getJavaVersion() {
            String version = System.getProperty("java.version");
            if (version == null) {
                return null;
            }
            String formatted = ApiClientVersion.formatSemver(version, null);
            if (formatted != null) {
                return formatted;
            }
            Matcher m4 = Pattern.compile("^(\\d+)[^\\d]?").matcher(version);
            if (m4.find()) {
                return m4.group(1) + ".0.0";
            }
            return null;
        }

        private static String formatName(String name) {
            return name.toLowerCase().replaceAll("[^\\w\\d\\-]", "-");
        }

        private static String formatSemver(String version) {
            return ApiClientVersion.formatSemver(version, version);
        }

        private static String formatSemver(String version, String defaultValue) {
            if (version == null) {
                return null;
            }
            Matcher m4 = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*").matcher(version);
            if (m4.find()) {
                return m4.group(1);
            }
            return defaultValue;
        }
    }
}

