/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.http;

import java.io.IOException;
import shaded.bqjdbc.com.google.api.client.http.HttpIOExceptionHandler;
import shaded.bqjdbc.com.google.api.client.http.HttpRequest;
import shaded.bqjdbc.com.google.api.client.util.BackOff;
import shaded.bqjdbc.com.google.api.client.util.BackOffUtils;
import shaded.bqjdbc.com.google.api.client.util.Beta;
import shaded.bqjdbc.com.google.api.client.util.Preconditions;
import shaded.bqjdbc.com.google.api.client.util.Sleeper;

@Beta
public class HttpBackOffIOExceptionHandler
implements HttpIOExceptionHandler {
    private final BackOff backOff;
    private Sleeper sleeper = Sleeper.DEFAULT;

    public HttpBackOffIOExceptionHandler(BackOff backOff) {
        this.backOff = Preconditions.checkNotNull(backOff);
    }

    public final BackOff getBackOff() {
        return this.backOff;
    }

    public final Sleeper getSleeper() {
        return this.sleeper;
    }

    public HttpBackOffIOExceptionHandler setSleeper(Sleeper sleeper) {
        this.sleeper = Preconditions.checkNotNull(sleeper);
        return this;
    }

    @Override
    public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
        if (!supportsRetry) {
            return false;
        }
        try {
            return BackOffUtils.next(this.sleeper, this.backOff);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

