/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.http.apache.v2;

import java.io.IOException;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import shaded.bqjdbc.com.google.api.client.http.HttpTransport;
import shaded.bqjdbc.com.google.api.client.http.apache.v2.ApacheHttpRequest;
import shaded.bqjdbc.com.google.api.client.http.apache.v2.HttpExtensionMethod;
import shaded.bqjdbc.com.google.api.client.util.Beta;
import shaded.bqjdbc.org.apache.http.client.HttpClient;
import shaded.bqjdbc.org.apache.http.client.methods.HttpDelete;
import shaded.bqjdbc.org.apache.http.client.methods.HttpGet;
import shaded.bqjdbc.org.apache.http.client.methods.HttpHead;
import shaded.bqjdbc.org.apache.http.client.methods.HttpOptions;
import shaded.bqjdbc.org.apache.http.client.methods.HttpPatch;
import shaded.bqjdbc.org.apache.http.client.methods.HttpPost;
import shaded.bqjdbc.org.apache.http.client.methods.HttpPut;
import shaded.bqjdbc.org.apache.http.client.methods.HttpRequestBase;
import shaded.bqjdbc.org.apache.http.client.methods.HttpTrace;
import shaded.bqjdbc.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.bqjdbc.org.apache.http.impl.client.CloseableHttpClient;
import shaded.bqjdbc.org.apache.http.impl.client.HttpClientBuilder;
import shaded.bqjdbc.org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public final class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient httpClient;
    private final boolean isMtls;

    public ApacheHttpTransport() {
        this(ApacheHttpTransport.newDefaultHttpClient(), false);
    }

    public ApacheHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.isMtls = false;
    }

    @Beta
    public ApacheHttpTransport(HttpClient httpClient, boolean isMtls) {
        this.httpClient = httpClient;
        this.isMtls = isMtls;
    }

    public static HttpClient newDefaultHttpClient() {
        return ApacheHttpTransport.newDefaultHttpClientBuilder().build();
    }

    public static HttpClientBuilder newDefaultHttpClientBuilder() {
        return HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory(SSLConnectionSocketFactory.getSocketFactory()).setMaxConnTotal(200).setMaxConnPerRoute(20).setConnectionTimeToLive(-1L, TimeUnit.MILLISECONDS).setRoutePlanner(new SystemDefaultRoutePlanner(ProxySelector.getDefault())).disableRedirectHandling().disableAutomaticRetries();
    }

    @Override
    public boolean supportsMethod(String method) {
        return true;
    }

    @Override
    protected ApacheHttpRequest buildRequest(String method, String url) {
        HttpRequestBase requestBase = method.equals("DELETE") ? new HttpDelete(url) : (method.equals("GET") ? new HttpGet(url) : (method.equals("HEAD") ? new HttpHead(url) : (method.equals("PATCH") ? new HttpPatch(url) : (method.equals("POST") ? new HttpPost(url) : (method.equals("PUT") ? new HttpPut(url) : (method.equals("TRACE") ? new HttpTrace(url) : (method.equals("OPTIONS") ? new HttpOptions(url) : new HttpExtensionMethod(method, url))))))));
        return new ApacheHttpRequest(this.httpClient, requestBase);
    }

    @Override
    public void shutdown() throws IOException {
        if (this.httpClient instanceof CloseableHttpClient) {
            ((CloseableHttpClient)this.httpClient).close();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public boolean isMtls() {
        return this.isMtls;
    }
}

