/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.http.apache.v5;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shaded.bqjdbc.com.google.api.client.http.LowLevelHttpRequest;
import shaded.bqjdbc.com.google.api.client.http.LowLevelHttpResponse;
import shaded.bqjdbc.com.google.api.client.http.apache.v5.Apache5ContentEntity;
import shaded.bqjdbc.com.google.api.client.http.apache.v5.Apache5HttpResponse;
import shaded.bqjdbc.org.apache.hc.client5.http.ClientProtocolException;
import shaded.bqjdbc.org.apache.hc.client5.http.classic.HttpClient;
import shaded.bqjdbc.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import shaded.bqjdbc.org.apache.hc.client5.http.config.RequestConfig;
import shaded.bqjdbc.org.apache.hc.client5.http.routing.RoutingSupport;
import shaded.bqjdbc.org.apache.hc.core5.http.ClassicHttpResponse;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpException;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpHost;
import shaded.bqjdbc.org.apache.hc.core5.util.Timeout;

public final class Apache5HttpRequest
extends LowLevelHttpRequest {
    private final HttpUriRequestBase request;
    private final RequestConfig.Builder requestConfig;
    private final HttpClient httpClient;

    Apache5HttpRequest(HttpClient httpClient, HttpUriRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestConfig = RequestConfig.custom().setRedirectsEnabled(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        this.requestConfig.setConnectTimeout(Timeout.of(connectTimeout, TimeUnit.MILLISECONDS)).setResponseTimeout(Timeout.of(readTimeout, TimeUnit.MILLISECONDS));
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        HttpHost target;
        if (this.getStreamingContent() != null) {
            Apache5ContentEntity entity = new Apache5ContentEntity(this.getContentLength(), this.getStreamingContent(), this.getContentType(), this.getContentEncoding());
            this.request.setEntity(entity);
        }
        this.request.setConfig(this.requestConfig.build());
        try {
            target = RoutingSupport.determineHost(this.request);
        }
        catch (HttpException e) {
            throw new ClientProtocolException("The request's host is invalid.", e);
        }
        ClassicHttpResponse httpResponse = this.httpClient.executeOpen(target, this.request, null);
        return new Apache5HttpResponse(this.request, httpResponse);
    }
}

