/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.http.javanet;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import shaded.bqjdbc.com.google.api.client.http.LowLevelHttpResponse;

final class NetHttpResponse
extends LowLevelHttpResponse {
    private final HttpURLConnection connection;
    private final int responseCode;
    private final String responseMessage;
    private final ArrayList<String> headerNames = new ArrayList();
    private final ArrayList<String> headerValues = new ArrayList();

    NetHttpResponse(HttpURLConnection connection) throws IOException {
        this.connection = connection;
        int responseCode = connection.getResponseCode();
        this.responseCode = responseCode == -1 ? 0 : responseCode;
        this.responseMessage = connection.getResponseMessage();
        ArrayList<String> headerNames = this.headerNames;
        ArrayList<String> headerValues = this.headerValues;
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            for (String value : entry.getValue()) {
                if (value == null) continue;
                headerNames.add(key);
                headerValues.add(value);
            }
        }
    }

    @Override
    public int getStatusCode() {
        return this.responseCode;
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream in = null;
        try {
            in = this.connection.getInputStream();
        }
        catch (IOException ioe) {
            in = this.connection.getErrorStream();
        }
        return in == null ? null : new SizeValidatingInputStream(in);
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public long getContentLength() {
        String string = this.connection.getHeaderField("Content-Length");
        return string == null ? -1L : Long.parseLong(string);
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public String getReasonPhrase() {
        return this.responseMessage;
    }

    @Override
    public String getStatusLine() {
        String result = this.connection.getHeaderField(0);
        return result != null && result.startsWith("HTTP/1.") ? result : null;
    }

    @Override
    public int getHeaderCount() {
        return this.headerNames.size();
    }

    @Override
    public String getHeaderName(int index) {
        return this.headerNames.get(index);
    }

    @Override
    public String getHeaderValue(int index) {
        return this.headerValues.get(index);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    private final class SizeValidatingInputStream
    extends FilterInputStream {
        private long bytesRead;

        public SizeValidatingInputStream(InputStream in) {
            super(in);
            this.bytesRead = 0L;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n == -1) {
                this.throwIfFalseEOF();
            } else {
                this.bytesRead += (long)n;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n == -1) {
                this.throwIfFalseEOF();
            } else {
                ++this.bytesRead;
            }
            return n;
        }

        @Override
        public long skip(long len) throws IOException {
            long n = this.in.skip(len);
            this.bytesRead += n;
            return n;
        }

        private void throwIfFalseEOF() throws IOException {
            long contentLength = NetHttpResponse.this.getContentLength();
            if (contentLength == -1L) {
                return;
            }
            if (this.bytesRead != 0L && this.bytesRead < contentLength) {
                throw new IOException("Connection closed prematurely: bytesRead = " + this.bytesRead + ", Content-Length = " + contentLength);
            }
        }
    }
}

