/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.client.http.json;

import java.io.IOException;
import java.io.OutputStream;
import shaded.bqjdbc.com.google.api.client.http.AbstractHttpContent;
import shaded.bqjdbc.com.google.api.client.http.HttpMediaType;
import shaded.bqjdbc.com.google.api.client.json.JsonFactory;
import shaded.bqjdbc.com.google.api.client.json.JsonGenerator;
import shaded.bqjdbc.com.google.api.client.util.Preconditions;

public class JsonHttpContent
extends AbstractHttpContent {
    private final Object data;
    private final JsonFactory jsonFactory;
    private String wrapperKey;

    public JsonHttpContent(JsonFactory jsonFactory, Object data) {
        super("application/json; charset=UTF-8");
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.data = Preconditions.checkNotNull(data);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        JsonGenerator generator = this.jsonFactory.createJsonGenerator(out, this.getCharset());
        if (this.wrapperKey != null) {
            generator.writeStartObject();
            generator.writeFieldName(this.wrapperKey);
        }
        generator.serialize(this.data);
        if (this.wrapperKey != null) {
            generator.writeEndObject();
        }
        generator.flush();
    }

    @Override
    public JsonHttpContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final Object getData() {
        return this.data;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getWrapperKey() {
        return this.wrapperKey;
    }

    public JsonHttpContent setWrapperKey(String wrapperKey) {
        this.wrapperKey = wrapperKey;
        return this;
    }
}

