/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.grpc;

import java.util.Collections;
import java.util.Map;
import shaded.bqjdbc.com.google.api.gax.grpc.ResponseMetadataHandler;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.io.grpc.CallOptions;
import shaded.bqjdbc.io.grpc.Metadata;

class CallOptionsUtil {
    private static final CallOptions.Key<Map<Metadata.Key<String>, String>> DYNAMIC_HEADERS_CALL_OPTION_KEY = CallOptions.Key.createWithDefault("gax_dynamic_headers", Collections.emptyMap());
    static Metadata.Key<String> REQUEST_PARAMS_HEADER_KEY = Metadata.Key.of("x-goog-request-params", Metadata.ASCII_STRING_MARSHALLER);
    private static final CallOptions.Key<ResponseMetadataHandler> METADATA_HANDLER_CALL_OPTION_KEY = CallOptions.Key.createWithDefault("gax_metadata_handler", null);

    private CallOptionsUtil() {
    }

    static CallOptions putRequestParamsDynamicHeaderOption(CallOptions callOptions, String requestParams) {
        if (callOptions == null || requestParams.isEmpty()) {
            return callOptions;
        }
        Map<Metadata.Key<String>, String> dynamicHeadersOption = callOptions.getOption(DYNAMIC_HEADERS_CALL_OPTION_KEY);
        dynamicHeadersOption = ImmutableMap.builder().putAll(dynamicHeadersOption).put(REQUEST_PARAMS_HEADER_KEY, requestParams).build();
        return callOptions.withOption(DYNAMIC_HEADERS_CALL_OPTION_KEY, dynamicHeadersOption);
    }

    static Map<Metadata.Key<String>, String> getDynamicHeadersOption(CallOptions callOptions) {
        return callOptions.getOption(DYNAMIC_HEADERS_CALL_OPTION_KEY);
    }

    static CallOptions putMetadataHandlerOption(CallOptions callOptions, ResponseMetadataHandler handler) {
        Preconditions.checkNotNull(callOptions);
        Preconditions.checkNotNull(handler);
        return callOptions.withOption(METADATA_HANDLER_CALL_OPTION_KEY, handler);
    }

    public static ResponseMetadataHandler getMetadataHandlerOption(CallOptions callOptions) {
        return callOptions.getOption(METADATA_HANDLER_CALL_OPTION_KEY);
    }
}

