/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.grpc;

import java.util.UUID;
import shaded.bqjdbc.com.google.api.gax.grpc.GrpcCallContext;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracer;
import shaded.bqjdbc.io.grpc.CallOptions;
import shaded.bqjdbc.io.grpc.Channel;
import shaded.bqjdbc.io.grpc.ClientCall;
import shaded.bqjdbc.io.grpc.ClientInterceptor;
import shaded.bqjdbc.io.grpc.MethodDescriptor;

class GrpcChannelUUIDInterceptor
implements ClientInterceptor {
    private final String uuid = UUID.randomUUID().toString();

    GrpcChannelUUIDInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ApiTracer apiTracer = callOptions.getOption(GrpcCallContext.TRACER_KEY);
        if (apiTracer != null) {
            apiTracer.connectionSelected(this.uuid);
        }
        return channel.newCall(methodDescriptor, callOptions);
    }
}

