/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.grpc;

import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.core.ListenableFutureToApiFuture;
import shaded.bqjdbc.com.google.api.gax.grpc.GrpcClientCalls;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.io.grpc.ClientCall;
import shaded.bqjdbc.io.grpc.MethodDescriptor;
import shaded.bqjdbc.io.grpc.stub.ClientCalls;

@InternalApi
class GrpcDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;
    private final boolean awaitTrailers;

    GrpcDirectCallable(MethodDescriptor<RequestT, ResponseT> descriptor, boolean awaitTrailers) {
        this.descriptor = Preconditions.checkNotNull(descriptor);
        this.awaitTrailers = awaitTrailers;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(inputContext);
        ClientCall<RequestT, ResponseT> clientCall = GrpcClientCalls.newCall(this.descriptor, inputContext);
        if (this.awaitTrailers) {
            return new ListenableFutureToApiFuture<ResponseT>(ClientCalls.futureUnaryCall(clientCall, request));
        }
        return GrpcClientCalls.eagerFutureUnaryCall(clientCall, request);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

