/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.grpc;

import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.grpc.CallOptionsUtil;
import shaded.bqjdbc.com.google.api.gax.grpc.ResponseMetadataHandler;
import shaded.bqjdbc.io.grpc.CallOptions;
import shaded.bqjdbc.io.grpc.Channel;
import shaded.bqjdbc.io.grpc.ClientCall;
import shaded.bqjdbc.io.grpc.ClientInterceptor;
import shaded.bqjdbc.io.grpc.ForwardingClientCall;
import shaded.bqjdbc.io.grpc.ForwardingClientCallListener;
import shaded.bqjdbc.io.grpc.Metadata;
import shaded.bqjdbc.io.grpc.MethodDescriptor;
import shaded.bqjdbc.io.grpc.Status;

@InternalApi
class GrpcMetadataHandlerInterceptor
implements ClientInterceptor {
    GrpcMetadataHandlerInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall<ReqT, RespT> call = next.newCall(method, callOptions);
        final ResponseMetadataHandler metadataHandler = CallOptionsUtil.getMetadataHandlerOption(callOptions);
        if (metadataHandler == null) {
            return call;
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener forwardingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                        metadataHandler.onHeaders(headers);
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        metadataHandler.onTrailers(trailers);
                        super.onClose(status, trailers);
                    }
                };
                super.start(forwardingResponseListener, headers);
            }
        };
    }
}

