/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.grpc;

import shaded.bqjdbc.com.google.api.gax.grpc.GrpcCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestParamsExtractor;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestUrlParamsEncoder;
import shaded.bqjdbc.com.google.api.gax.rpc.ResponseObserver;
import shaded.bqjdbc.com.google.api.gax.rpc.ServerStreamingCallable;
import shaded.bqjdbc.com.google.common.base.Preconditions;

class GrpcServerStreamingRequestParamCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    GrpcServerStreamingRequestParamCallable(ServerStreamingCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder<RequestT>(Preconditions.checkNotNull(paramsExtractor));
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        this.callable.call(request, responseObserver, this.contextWithParamsEncoder(request, context));
    }

    private ApiCallContext contextWithParamsEncoder(RequestT request, ApiCallContext inputContext) {
        ApiCallContext newCallContext = inputContext;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = GrpcCallContext.createDefault().nullToSelf(inputContext).withRequestParamsDynamicHeaderOption(encodedHeader);
        }
        return newCallContext;
    }
}

