/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.httpjson;

import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.core.ObsoleteApi;
import shaded.bqjdbc.com.google.api.gax.httpjson.AutoValue_HttpJsonCallOptions;
import shaded.bqjdbc.com.google.api.gax.util.TimeConversionUtils;
import shaded.bqjdbc.com.google.auth.Credentials;
import shaded.bqjdbc.com.google.auto.value.AutoValue;
import shaded.bqjdbc.com.google.protobuf.TypeRegistry;
import shaded.bqjdbc.org.threeten.bp.Duration;
import shaded.bqjdbc.org.threeten.bp.Instant;

@AutoValue
public abstract class HttpJsonCallOptions {
    public static final HttpJsonCallOptions DEFAULT = HttpJsonCallOptions.newBuilder().build();

    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public final Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTimeoutDuration());
    }

    @Nullable
    public abstract java.time.Duration getTimeoutDuration();

    @Nullable
    @ObsoleteApi(value="Use getDeadlineInstant() instead")
    public final Instant getDeadline() {
        return TimeConversionUtils.toThreetenInstant(this.getDeadlineInstant());
    }

    @Nullable
    public abstract java.time.Instant getDeadlineInstant();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TypeRegistry getTypeRegistry();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_HttpJsonCallOptions.Builder();
    }

    public HttpJsonCallOptions merge(HttpJsonCallOptions inputOptions) {
        TypeRegistry newTypeRegistry;
        Credentials newCredentials;
        java.time.Duration newTimeout;
        if (inputOptions == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        java.time.Instant newDeadline = inputOptions.getDeadlineInstant();
        if (newDeadline != null) {
            builder.setDeadlineInstant(newDeadline);
        }
        if (inputOptions.getTimeout() != null && (newTimeout = inputOptions.getTimeoutDuration()) != null) {
            builder.setTimeoutDuration(newTimeout);
        }
        if ((newCredentials = inputOptions.getCredentials()) != null) {
            builder.setCredentials(newCredentials);
        }
        if ((newTypeRegistry = inputOptions.getTypeRegistry()) != null) {
            builder.setTypeRegistry(newTypeRegistry);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @ObsoleteApi(value="Use setTimeoutDuration(java.time.Duration) instead")
        public final Builder setTimeout(Duration value) {
            return this.setTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setTimeoutDuration(java.time.Duration var1);

        @ObsoleteApi(value="Use setDeadlineInstant(java.time.Instant) instead")
        public final Builder setDeadline(Instant value) {
            return this.setDeadlineInstant(TimeConversionUtils.toJavaTimeInstant(value));
        }

        public abstract Builder setDeadlineInstant(java.time.Instant var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTypeRegistry(TypeRegistry var1);

        public abstract HttpJsonCallOptions build();
    }
}

