/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.httpjson;

import java.util.Map;
import shaded.bqjdbc.com.google.api.gax.httpjson.ApiMethodDescriptor;
import shaded.bqjdbc.com.google.api.gax.httpjson.ForwardingHttpJsonClientCall;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonCallOptions;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonChannel;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonClientCall;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonClientInterceptor;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonMetadata;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;

class HttpJsonHeaderInterceptor
implements HttpJsonClientInterceptor {
    private final Map<String, String> staticHeaders;

    public HttpJsonHeaderInterceptor(Map<String, String> staticHeaders) {
        this.staticHeaders = staticHeaders;
    }

    @Override
    public <ReqT, RespT> HttpJsonClientCall<ReqT, RespT> interceptCall(ApiMethodDescriptor<ReqT, RespT> method, HttpJsonCallOptions callOptions, HttpJsonChannel next) {
        HttpJsonClientCall<ReqT, RespT> call = next.newCall(method, callOptions);
        return new ForwardingHttpJsonClientCall.SimpleForwardingHttpJsonClientCall<ReqT, RespT>(call){

            @Override
            public void start(HttpJsonClientCall.Listener<RespT> responseListener, HttpJsonMetadata headers) {
                ImmutableMap<String, Object> mergedHeaders = ImmutableMap.builder().putAll(headers.getHeaders()).putAll(HttpJsonHeaderInterceptor.this.staticHeaders).build();
                super.start(responseListener, headers.toBuilder().setHeaders(mergedHeaders).build());
            }
        };
    }
}

