/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.httpjson;

import java.util.HashMap;
import java.util.Map;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.httpjson.ApiMethodDescriptor;
import shaded.bqjdbc.com.google.api.gax.httpjson.ForwardingHttpJsonClientCall;
import shaded.bqjdbc.com.google.api.gax.httpjson.ForwardingHttpJsonClientCallListener;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonCallOptions;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonChannel;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonClientCall;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonClientInterceptor;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonMetadata;
import shaded.bqjdbc.com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import shaded.bqjdbc.com.google.api.gax.logging.LogData;
import shaded.bqjdbc.com.google.api.gax.logging.LoggerProvider;
import shaded.bqjdbc.com.google.api.gax.logging.LoggingUtils;

@InternalApi
public class HttpJsonLoggingInterceptor
implements HttpJsonClientInterceptor {
    private static final LoggerProvider LOGGER_PROVIDER = LoggerProvider.forClazz(HttpJsonLoggingInterceptor.class);

    @Override
    public <ReqT, RespT> HttpJsonClientCall<ReqT, RespT> interceptCall(final ApiMethodDescriptor<ReqT, RespT> method, HttpJsonCallOptions callOptions, HttpJsonChannel next) {
        final String endpoint = ((ManagedHttpJsonChannel)next).getEndpoint();
        return new ForwardingHttpJsonClientCall.SimpleForwardingHttpJsonClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            LogData.Builder logDataBuilder;
            {
                super(delegate);
                this.logDataBuilder = LogData.builder();
            }

            @Override
            public void start(HttpJsonClientCall.Listener<RespT> responseListener, HttpJsonMetadata headers) {
                LoggingUtils.recordServiceRpcAndRequestHeaders(null, method.getFullMethodName(), endpoint, HttpJsonLoggingInterceptor.httpJsonMetadataToMap(headers), this.logDataBuilder, LOGGER_PROVIDER);
                ForwardingHttpJsonClientCallListener.SimpleForwardingHttpJsonClientCallListener forwardingResponseListener = new ForwardingHttpJsonClientCallListener.SimpleForwardingHttpJsonClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(HttpJsonMetadata responseHeaders) {
                        LoggingUtils.recordResponseHeaders(HttpJsonLoggingInterceptor.httpJsonMetadataToMap(responseHeaders), logDataBuilder, LOGGER_PROVIDER);
                        super.onHeaders(responseHeaders);
                    }

                    @Override
                    public void onMessage(RespT message) {
                        LoggingUtils.recordResponsePayload(message, logDataBuilder, LOGGER_PROVIDER);
                        super.onMessage(message);
                    }

                    @Override
                    public void onClose(int statusCode, HttpJsonMetadata trailers) {
                        LoggingUtils.logResponse(String.valueOf(statusCode), logDataBuilder, LOGGER_PROVIDER);
                        super.onClose(statusCode, trailers);
                    }
                };
                super.start(forwardingResponseListener, headers);
            }

            @Override
            public void sendMessage(ReqT message) {
                LoggingUtils.logRequest(message, this.logDataBuilder, LOGGER_PROVIDER);
                super.sendMessage(message);
            }
        };
    }

    private static Map<String, String> httpJsonMetadataToMap(HttpJsonMetadata headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headers.getHeaders().forEach((key, value) -> headersMap.put((String)key, value.toString()));
        return headersMap;
    }
}

