/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.httpjson;

import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestParamsExtractor;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestUrlParamsEncoder;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;

class HttpJsonUnaryRequestParamCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    public HttpJsonUnaryRequestParamCallable(UnaryCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder<RequestT>(Preconditions.checkNotNull(paramsExtractor));
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
        ApiCallContext newCallContext = context;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = HttpJsonCallContext.createDefault().nullToSelf(context).withExtraHeaders(ImmutableMap.of("x-goog-request-params", ImmutableList.of(encodedHeader)));
        }
        return this.callable.futureCall(request, newCallContext);
    }
}

