/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.httpjson.longrunning.stub;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import shaded.bqjdbc.com.google.api.core.ApiFunction;
import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.gax.core.GaxProperties;
import shaded.bqjdbc.com.google.api.gax.core.GoogleCredentialsProvider;
import shaded.bqjdbc.com.google.api.gax.core.InstantiatingExecutorProvider;
import shaded.bqjdbc.com.google.api.gax.httpjson.GaxHttpJsonProperties;
import shaded.bqjdbc.com.google.api.gax.httpjson.HttpJsonTransportChannel;
import shaded.bqjdbc.com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import shaded.bqjdbc.com.google.api.gax.httpjson.longrunning.OperationsClient;
import shaded.bqjdbc.com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import shaded.bqjdbc.com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiClientHeaderProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.ClientContext;
import shaded.bqjdbc.com.google.api.gax.rpc.PageContext;
import shaded.bqjdbc.com.google.api.gax.rpc.PagedCallSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.PagedListDescriptor;
import shaded.bqjdbc.com.google.api.gax.rpc.PagedListResponseFactory;
import shaded.bqjdbc.com.google.api.gax.rpc.StatusCode;
import shaded.bqjdbc.com.google.api.gax.rpc.StubSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.TransportChannelProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.com.google.common.collect.ImmutableSet;
import shaded.bqjdbc.com.google.common.collect.Lists;
import shaded.bqjdbc.com.google.longrunning.CancelOperationRequest;
import shaded.bqjdbc.com.google.longrunning.DeleteOperationRequest;
import shaded.bqjdbc.com.google.longrunning.GetOperationRequest;
import shaded.bqjdbc.com.google.longrunning.ListOperationsRequest;
import shaded.bqjdbc.com.google.longrunning.ListOperationsResponse;
import shaded.bqjdbc.com.google.longrunning.Operation;
import shaded.bqjdbc.com.google.protobuf.Empty;

public class OperationsStubSettings
extends StubSettings<OperationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final PagedCallSettings<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings;
    private final UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings;
    private final UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private static final PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation> LIST_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListOperationsRequest injectToken(ListOperationsRequest payload, String token) {
            return ListOperationsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListOperationsRequest injectPageSize(ListOperationsRequest payload, int pageSize) {
            return ListOperationsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListOperationsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Operation> extractResources(ListOperationsResponse payload) {
            return payload.getOperationsList() == null ? ImmutableList.of() : payload.getOperationsList();
        }
    };
    private static final PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> LIST_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse>(){

        @Override
        public ApiFuture<OperationsClient.ListOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperationsRequest, ListOperationsResponse> callable, ListOperationsRequest request, ApiCallContext context, ApiFuture<ListOperationsResponse> futureResponse) {
            PageContext<ListOperationsRequest, ListOperationsResponse, Operation> pageContext = PageContext.create(callable, LIST_OPERATIONS_PAGE_STR_DESC, request, context);
            return OperationsClient.ListOperationsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public OperationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOperationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "longrunning.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "longrunning.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OperationsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OperationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OperationsStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OperationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings;
        private final UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings;
        private final UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listOperationsSettings = PagedCallSettings.newBuilder(LIST_OPERATIONS_PAGE_STR_FACT);
            this.getOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listOperationsSettings, this.getOperationSettings, this.deleteOperationSettings, this.cancelOperationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OperationsStubSettings settings) {
            super(settings);
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listOperationsSettings, this.getOperationSettings, this.deleteOperationSettings, this.cancelOperationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OperationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(OperationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(OperationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(OperationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(OperationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            ((PagedCallSettings.Builder)builder.listOperationsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.deleteOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.cancelOperationSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, OperationsClient.ListOperationsPagedResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public OperationsStubSettings build() throws IOException {
            return new OperationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(10000L)).setTotalTimeoutDuration(Duration.ofMillis(10000L)).build();
            definitions.put("retry_policy_0_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

