/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.logging;

import java.util.Map;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.logging.LoggingUtils;
import shaded.bqjdbc.com.google.api.gax.logging.Slf4jLoggingHelpers;
import shaded.bqjdbc.org.slf4j.ILoggerFactory;
import shaded.bqjdbc.org.slf4j.Logger;
import shaded.bqjdbc.org.slf4j.LoggerFactory;
import shaded.bqjdbc.org.slf4j.MDC;
import shaded.bqjdbc.org.slf4j.event.Level;
import shaded.bqjdbc.org.slf4j.helpers.NOPLogger;
import shaded.bqjdbc.org.slf4j.spi.LoggingEventBuilder;

@InternalApi
class Slf4jUtils {
    private static final Logger NO_OP_LOGGER = NOPLogger.NOP_LOGGER;
    private static final boolean loggingEnabled = LoggingUtils.isLoggingEnabled();
    private static final boolean isSLF4J2x = Slf4jUtils.checkIfClazzAvailable("shaded.bqjdbc.org.slf4j.event.KeyValuePair");

    static boolean checkIfClazzAvailable(String clazzName) {
        try {
            Class.forName(clazzName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static Logger getLogger(Class<?> clazz) {
        return Slf4jUtils.getLogger(clazz, new DefaultLoggerFactoryProvider());
    }

    static Logger getLogger(Class<?> clazz, LoggerFactoryProvider factoryProvider) {
        if (loggingEnabled) {
            ILoggerFactory loggerFactory = factoryProvider.getLoggerFactory();
            return loggerFactory.getLogger(clazz.getName());
        }
        return NO_OP_LOGGER;
    }

    static void log(Logger logger, Level level, Map<String, Object> contextMap, String message) {
        if (isSLF4J2x) {
            Slf4jUtils.logWithKeyValuePair(logger, level, contextMap, message);
        } else {
            Slf4jUtils.logWithMDC(logger, level, contextMap, message);
        }
    }

    static void logWithMDC(Logger logger, Level level, Map<String, Object> contextMap, String message) {
        if (!contextMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                MDC.put(key, value instanceof String ? (String)value : Slf4jLoggingHelpers.gson.toJson(value));
            }
        }
        switch (level) {
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                logger.debug(message);
            }
        }
        if (!contextMap.isEmpty()) {
            MDC.clear();
        }
    }

    private static void logWithKeyValuePair(Logger logger, Level level, Map<String, Object> contextMap, String message) {
        LoggingEventBuilder loggingEventBuilder;
        switch (level) {
            case TRACE: {
                loggingEventBuilder = logger.atTrace();
                break;
            }
            case DEBUG: {
                loggingEventBuilder = logger.atDebug();
                break;
            }
            case INFO: {
                loggingEventBuilder = logger.atInfo();
                break;
            }
            case WARN: {
                loggingEventBuilder = logger.atWarn();
                break;
            }
            case ERROR: {
                loggingEventBuilder = logger.atError();
                break;
            }
            default: {
                loggingEventBuilder = logger.atDebug();
            }
        }
        contextMap.forEach(loggingEventBuilder::addKeyValue);
        loggingEventBuilder.log(message);
    }

    private Slf4jUtils() {
    }

    static class DefaultLoggerFactoryProvider
    implements LoggerFactoryProvider {
        DefaultLoggerFactoryProvider() {
        }

        @Override
        public ILoggerFactory getLoggerFactory() {
            return LoggerFactory.getILoggerFactory();
        }
    }

    static interface LoggerFactoryProvider {
        public ILoggerFactory getLoggerFactory();
    }
}

