/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.retrying;

import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.time.Duration;
import java.util.concurrent.Callable;
import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.core.ApiFutures;
import shaded.bqjdbc.com.google.api.gax.retrying.BasicRetryingFuture;
import shaded.bqjdbc.com.google.api.gax.retrying.NoopRetryingContext;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryAlgorithm;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingContext;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingExecutorWithContext;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingFuture;
import shaded.bqjdbc.com.google.common.base.Preconditions;

public class DirectRetryingExecutor<ResponseT>
implements RetryingExecutorWithContext<ResponseT> {
    private final RetryAlgorithm<ResponseT> retryAlgorithm;

    public DirectRetryingExecutor(RetryAlgorithm<ResponseT> retryAlgorithm) {
        this.retryAlgorithm = Preconditions.checkNotNull(retryAlgorithm);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return this.createFuture(callable, NoopRetryingContext.create());
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable, RetryingContext context) {
        return new BasicRetryingFuture<ResponseT>(callable, this.retryAlgorithm, context);
    }

    @Override
    public ApiFuture<ResponseT> submit(RetryingFuture<ResponseT> retryingFuture) {
        while (!retryingFuture.isDone()) {
            try {
                this.sleep(retryingFuture.getAttemptSettings().getRandomizedRetryDelayDuration());
                ResponseT response = retryingFuture.getCallable().call();
                retryingFuture.setAttemptFuture(ApiFutures.immediateFuture(response));
            }
            catch (InterruptedIOException | InterruptedException | ClosedByInterruptException e) {
                Thread.currentThread().interrupt();
                retryingFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
            }
            catch (Exception e) {
                retryingFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
            }
        }
        return retryingFuture;
    }

    protected void sleep(Duration delay) throws InterruptedException {
        if (Duration.ZERO.compareTo(delay) < 0) {
            Thread.sleep(delay.toMillis());
        }
    }
}

