/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.retrying;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import shaded.bqjdbc.com.google.api.core.ApiClock;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingContext;
import shaded.bqjdbc.com.google.api.gax.retrying.TimedAttemptSettings;
import shaded.bqjdbc.com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import shaded.bqjdbc.com.google.common.base.Preconditions;

public class ExponentialRetryAlgorithm
implements TimedRetryAlgorithmWithContext {
    private final RetrySettings globalSettings;
    private final ApiClock clock;

    public ExponentialRetryAlgorithm(RetrySettings globalSettings, ApiClock clock) {
        this.globalSettings = Preconditions.checkNotNull(globalSettings);
        this.clock = Preconditions.checkNotNull(clock);
    }

    @Override
    public TimedAttemptSettings createFirstAttempt() {
        return TimedAttemptSettings.newBuilder().setGlobalSettings(this.globalSettings).setRetryDelayDuration(Duration.ZERO).setRpcTimeoutDuration(this.getInitialTimeout(this.globalSettings)).setRandomizedRetryDelayDuration(Duration.ZERO).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(this.clock.nanoTime()).build();
    }

    @Override
    public TimedAttemptSettings createFirstAttempt(RetryingContext context) {
        if (context.getRetrySettings() == null) {
            return this.createFirstAttempt();
        }
        RetrySettings retrySettings = context.getRetrySettings();
        return TimedAttemptSettings.newBuilder().setGlobalSettings(retrySettings).setRpcTimeoutDuration(this.getInitialTimeout(retrySettings)).setRetryDelayDuration(Duration.ZERO).setRandomizedRetryDelayDuration(Duration.ZERO).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(this.clock.nanoTime()).build();
    }

    @Override
    public TimedAttemptSettings createNextAttempt(TimedAttemptSettings previousSettings) {
        RetrySettings settings = previousSettings.getGlobalSettings();
        long newRetryDelay = settings.getInitialRetryDelayDuration().toMillis();
        if (previousSettings.getAttemptCount() > 0) {
            newRetryDelay = (long)(settings.getRetryDelayMultiplier() * (double)previousSettings.getRetryDelayDuration().toMillis());
            newRetryDelay = Math.min(newRetryDelay, settings.getMaxRetryDelayDuration().toMillis());
        }
        Duration randomDelay = Duration.ofMillis(this.nextRandomLong(newRetryDelay));
        long newRpcTimeout = (long)(settings.getRpcTimeoutMultiplier() * (double)previousSettings.getRpcTimeoutDuration().toMillis());
        newRpcTimeout = Math.min(newRpcTimeout, settings.getMaxRpcTimeoutDuration().toMillis());
        if (!settings.getTotalTimeoutDuration().isZero()) {
            Duration timeElapsed = Duration.ofNanos(this.clock.nanoTime()).minus(Duration.ofNanos(previousSettings.getFirstAttemptStartTimeNanos()));
            Duration timeLeft = settings.getTotalTimeoutDuration().minus(timeElapsed).minus(randomDelay);
            newRpcTimeout = Math.min(newRpcTimeout, timeLeft.toMillis());
        }
        return TimedAttemptSettings.newBuilder().setGlobalSettings(previousSettings.getGlobalSettings()).setRetryDelayDuration(Duration.ofMillis(newRetryDelay)).setRpcTimeoutDuration(Duration.ofMillis(newRpcTimeout)).setRandomizedRetryDelayDuration(randomDelay).setAttemptCount(previousSettings.getAttemptCount() + 1).setOverallAttemptCount(previousSettings.getOverallAttemptCount() + 1).setFirstAttemptStartTimeNanos(previousSettings.getFirstAttemptStartTimeNanos()).build();
    }

    @Override
    public TimedAttemptSettings createNextAttempt(RetryingContext context, TimedAttemptSettings previousSettings) {
        return this.createNextAttempt(previousSettings);
    }

    @Override
    public boolean shouldRetry(TimedAttemptSettings nextAttemptSettings) {
        RetrySettings globalSettings = nextAttemptSettings.getGlobalSettings();
        int maxAttempts = globalSettings.getMaxAttempts();
        Duration totalTimeout = globalSettings.getTotalTimeoutDuration();
        if (totalTimeout.isZero() && maxAttempts == 0) {
            return false;
        }
        long totalTimeSpentNanos = this.clock.nanoTime() - nextAttemptSettings.getFirstAttemptStartTimeNanos() + nextAttemptSettings.getRandomizedRetryDelayDuration().toNanos();
        Duration timeLeft = totalTimeout.minus(Duration.ofNanos(totalTimeSpentNanos));
        long timeLeftMs = timeLeft.toMillis();
        if (!totalTimeout.isZero() && this.shouldRPCTerminate(timeLeftMs)) {
            return false;
        }
        return maxAttempts <= 0 || nextAttemptSettings.getAttemptCount() < maxAttempts;
    }

    @InternalApi
    protected boolean shouldRPCTerminate(long timeLeftMs) {
        return timeLeftMs <= 0L;
    }

    @Override
    public boolean shouldRetry(RetryingContext context, TimedAttemptSettings nextAttemptSettings) {
        return this.shouldRetry(nextAttemptSettings);
    }

    protected long nextRandomLong(long bound) {
        return bound > 0L && this.globalSettings.isJittered() ? ThreadLocalRandom.current().nextLong(bound) : bound;
    }

    private Duration getInitialTimeout(RetrySettings retrySettings) {
        long totalTimeout = retrySettings.getTotalTimeout().toMillis();
        return totalTimeout == 0L ? retrySettings.getInitialRpcTimeoutDuration() : Duration.ofMillis(Math.min(retrySettings.getInitialRpcTimeout().toMillis(), totalTimeout));
    }
}

