/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.rpc;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import shaded.bqjdbc.com.google.api.client.util.Strings;
import shaded.bqjdbc.com.google.api.core.ApiClock;
import shaded.bqjdbc.com.google.api.core.BetaApi;
import shaded.bqjdbc.com.google.api.core.NanoClock;
import shaded.bqjdbc.com.google.api.core.ObsoleteApi;
import shaded.bqjdbc.com.google.api.gax.core.BackgroundResource;
import shaded.bqjdbc.com.google.api.gax.core.ExecutorAsBackgroundResource;
import shaded.bqjdbc.com.google.api.gax.core.ExecutorProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiClientHeaderProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.AutoValue_ClientContext;
import shaded.bqjdbc.com.google.api.gax.rpc.ClientSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.EndpointContext;
import shaded.bqjdbc.com.google.api.gax.rpc.StubSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.TransportChannel;
import shaded.bqjdbc.com.google.api.gax.rpc.TransportChannelProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.Watchdog;
import shaded.bqjdbc.com.google.api.gax.rpc.WatchdogProvider;
import shaded.bqjdbc.com.google.api.gax.rpc.internal.QuotaProjectIdHidingCredentials;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracerFactory;
import shaded.bqjdbc.com.google.api.gax.tracing.BaseApiTracerFactory;
import shaded.bqjdbc.com.google.api.gax.util.TimeConversionUtils;
import shaded.bqjdbc.com.google.auth.ApiKeyCredentials;
import shaded.bqjdbc.com.google.auth.CredentialTypeForMetrics;
import shaded.bqjdbc.com.google.auth.Credentials;
import shaded.bqjdbc.com.google.auth.oauth2.GdchCredentials;
import shaded.bqjdbc.com.google.auto.value.AutoValue;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.collect.ImmutableList;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.com.google.common.collect.Sets;
import shaded.bqjdbc.org.threeten.bp.Duration;

@AutoValue
public abstract class ClientContext {
    private static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";

    public abstract List<BackgroundResource> getBackgroundResources();

    public abstract ScheduledExecutorService getExecutor();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TransportChannel getTransportChannel();

    public abstract Map<String, String> getHeaders();

    protected abstract Map<String, String> getInternalHeaders();

    public abstract ApiClock getClock();

    public abstract ApiCallContext getDefaultCallContext();

    @Nullable
    public abstract Watchdog getStreamWatchdog();

    @Nonnull
    @ObsoleteApi(value="Use getStreamWatchdogCheckIntervalDuration() instead")
    public final Duration getStreamWatchdogCheckInterval() {
        return TimeConversionUtils.toThreetenDuration(this.getStreamWatchdogCheckIntervalDuration());
    }

    @Nonnull
    public abstract java.time.Duration getStreamWatchdogCheckIntervalDuration();

    @Nullable
    public abstract String getUniverseDomain();

    @Nullable
    public abstract String getEndpoint();

    @Nullable
    public abstract String getQuotaProjectId();

    abstract EndpointContext getEndpointContext();

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
    @Nonnull
    public abstract ApiTracerFactory getTracerFactory();

    @Nullable
    public abstract String getGdchApiAudience();

    public static Builder newBuilder() {
        return new AutoValue_ClientContext.Builder().setBackgroundResources(Collections.emptyList()).setExecutor(Executors.newScheduledThreadPool(0)).setHeaders(Collections.emptyMap()).setInternalHeaders(Collections.emptyMap()).setClock(NanoClock.getDefaultClock()).setStreamWatchdog(null).setStreamWatchdogCheckIntervalDuration(java.time.Duration.ZERO).setTracerFactory(BaseApiTracerFactory.getInstance()).setQuotaProjectId(null).setGdchApiAudience(null).setEndpointContext(EndpointContext.getDefaultInstance());
    }

    public abstract Builder toBuilder();

    public static ClientContext create(ClientSettings settings) throws IOException {
        return ClientContext.create(settings.getStubSettings());
    }

    public static ClientContext create(StubSettings settings) throws IOException {
        TransportChannelProvider transportChannelProvider;
        ApiClock clock = settings.getClock();
        ExecutorProvider backgroundExecutorProvider = settings.getBackgroundExecutorProvider();
        ScheduledExecutorService backgroundExecutor = backgroundExecutorProvider.getExecutor();
        EndpointContext endpointContext = settings.getEndpointContext();
        String endpoint = endpointContext.resolvedEndpoint();
        Credentials credentials = ClientContext.getCredentials(settings);
        String settingsGdchApiAudience = settings.getGdchApiAudience();
        boolean usingGDCH = credentials instanceof GdchCredentials;
        if (usingGDCH) {
            endpointContext = endpointContext.withGDCH();
            endpoint = endpointContext.resolvedEndpoint();
            credentials = ClientContext.getGdchCredentials(settingsGdchApiAudience, endpoint, credentials);
        } else if (!Strings.isNullOrEmpty(settingsGdchApiAudience)) {
            throw new IllegalArgumentException("GDC-H API audience can only be set when using GdchCredentials");
        }
        if (settings.getQuotaProjectId() != null && credentials != null) {
            credentials = new QuotaProjectIdHidingCredentials(credentials);
        }
        if ((transportChannelProvider = settings.getTransportChannelProvider()).needsExecutor() && settings.getExecutorProvider() != null) {
            transportChannelProvider = transportChannelProvider.withExecutor(backgroundExecutor);
        }
        Map<String, String> headers = ClientContext.getHeaders(settings, credentials);
        if (transportChannelProvider.needsHeaders()) {
            transportChannelProvider = transportChannelProvider.withHeaders(headers);
        }
        if (transportChannelProvider.needsCredentials() && credentials != null) {
            transportChannelProvider = transportChannelProvider.withCredentials(credentials);
        }
        if (transportChannelProvider.needsEndpoint()) {
            transportChannelProvider = transportChannelProvider.withEndpoint(endpoint);
        }
        if ((transportChannelProvider = transportChannelProvider.withUseS2A(endpointContext.useS2A())).needsMtlsEndpoint() && endpointContext.mtlsEndpoint() != null) {
            transportChannelProvider = transportChannelProvider.withMtlsEndpoint(endpointContext.mtlsEndpoint());
        }
        TransportChannel transportChannel = transportChannelProvider.getTransportChannel();
        ApiCallContext defaultCallContext = transportChannel.getEmptyCallContext().withTransportChannel(transportChannel);
        if (credentials != null) {
            defaultCallContext = defaultCallContext.withCredentials(credentials);
        }
        defaultCallContext = defaultCallContext.withEndpointContext(endpointContext);
        WatchdogProvider watchdogProvider = settings.getStreamWatchdogProvider();
        Watchdog watchdog = null;
        if (watchdogProvider != null) {
            if (watchdogProvider.needsCheckInterval()) {
                watchdogProvider = watchdogProvider.withCheckIntervalDuration(settings.getStreamWatchdogCheckIntervalDuration());
            }
            if (watchdogProvider.needsClock()) {
                watchdogProvider = watchdogProvider.withClock(clock);
            }
            if (watchdogProvider.needsExecutor()) {
                watchdogProvider = watchdogProvider.withExecutor(backgroundExecutor);
            }
            watchdog = watchdogProvider.getWatchdog();
        }
        ImmutableList.Builder backgroundResources = ImmutableList.builder();
        if (transportChannelProvider.shouldAutoClose()) {
            backgroundResources.add(transportChannel);
        }
        if (backgroundExecutorProvider.shouldAutoClose()) {
            backgroundResources.add(new ExecutorAsBackgroundResource(backgroundExecutor));
        }
        if (watchdogProvider != null && watchdogProvider.shouldAutoClose()) {
            backgroundResources.add(watchdog);
        }
        return ClientContext.newBuilder().setBackgroundResources((List<BackgroundResource>)((Object)backgroundResources.build())).setExecutor(backgroundExecutor).setCredentials(credentials).setTransportChannel(transportChannel).setHeaders(ImmutableMap.copyOf(settings.getHeaderProvider().getHeaders())).setInternalHeaders(ImmutableMap.copyOf(settings.getInternalHeaderProvider().getHeaders())).setClock(clock).setDefaultCallContext(defaultCallContext).setUniverseDomain(settings.getUniverseDomain()).setEndpoint(settings.getEndpoint()).setQuotaProjectId(settings.getQuotaProjectId()).setStreamWatchdog(watchdog).setStreamWatchdogCheckIntervalDuration(settings.getStreamWatchdogCheckIntervalDuration()).setTracerFactory(settings.getTracerFactory()).setEndpointContext(endpointContext).build();
    }

    private static Credentials getCredentials(StubSettings settings) throws IOException {
        Credentials credentials = settings.getApiKey() != null ? ApiKeyCredentials.create(settings.getApiKey()) : settings.getCredentialsProvider().getCredentials();
        return credentials;
    }

    @VisibleForTesting
    static GdchCredentials getGdchCredentials(String settingsGdchApiAudience, String endpoint, Credentials credentials) throws IOException {
        URI gdchAudienceUri;
        String audienceString;
        if (!Strings.isNullOrEmpty(settingsGdchApiAudience)) {
            audienceString = settingsGdchApiAudience;
        } else if (!Strings.isNullOrEmpty(endpoint)) {
            audienceString = endpoint;
        } else {
            throw new IllegalArgumentException("Could not infer GDCH api audience from settings");
        }
        try {
            gdchAudienceUri = URI.create(audienceString);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The GDC-H API audience string is not a valid URI", ex);
        }
        return ((GdchCredentials)credentials).createWithGdchAudience(gdchAudienceUri);
    }

    private static Map<String, String> getHeaders(StubSettings settings, Credentials credentials) {
        Map<String, String> userHeaders = settings.getHeaderProvider().getHeaders();
        Map<String, String> internalHeaders = settings.getInternalHeaderProvider().getHeaders();
        HashMap<String, String> conflictResolution = new HashMap<String, String>();
        Sets.SetView<String> conflicts = Sets.intersection(userHeaders.keySet(), internalHeaders.keySet());
        for (String key : conflicts) {
            if ("user-agent".equals(key)) {
                conflictResolution.put(key, userHeaders.get(key) + " " + internalHeaders.get(key));
                continue;
            }
            if (QUOTA_PROJECT_ID_HEADER_KEY.equals(key) && settings.getQuotaProjectId() != null) continue;
            throw new IllegalArgumentException("Header provider can't override the header: " + key);
        }
        if (settings.getQuotaProjectId() != null) {
            conflictResolution.put(QUOTA_PROJECT_ID_HEADER_KEY, settings.getQuotaProjectId());
        }
        HashMap<String, String> effectiveHeaders = new HashMap<String, String>();
        effectiveHeaders.putAll(internalHeaders);
        effectiveHeaders.putAll(userHeaders);
        effectiveHeaders.putAll(conflictResolution);
        return ClientContext.appendCredentialTypeToHeaderIfPresent(effectiveHeaders, credentials);
    }

    private static Map<String, String> appendCredentialTypeToHeaderIfPresent(Map<String, String> effectiveHeaders, Credentials credentials) {
        CredentialTypeForMetrics credentialTypeForMetrics;
        CredentialTypeForMetrics credentialTypeForMetrics2 = credentialTypeForMetrics = credentials == null ? CredentialTypeForMetrics.DO_NOT_SEND : credentials.getMetricsCredentialType();
        if (credentialTypeForMetrics != CredentialTypeForMetrics.DO_NOT_SEND) {
            effectiveHeaders.computeIfPresent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), (key, value) -> value + " cred-type/" + credentialTypeForMetrics.getLabel());
        }
        return ImmutableMap.copyOf(effectiveHeaders);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackgroundResources(List<BackgroundResource> var1);

        public abstract Builder setExecutor(ScheduledExecutorService var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTransportChannel(TransportChannel var1);

        public abstract Builder setHeaders(Map<String, String> var1);

        protected abstract Builder setInternalHeaders(Map<String, String> var1);

        public abstract Builder setClock(ApiClock var1);

        public abstract Builder setDefaultCallContext(ApiCallContext var1);

        public abstract Builder setUniverseDomain(String var1);

        public abstract Builder setEndpoint(String var1);

        public abstract Builder setQuotaProjectId(String var1);

        public abstract Builder setStreamWatchdog(Watchdog var1);

        @ObsoleteApi(value="Use setStreamWatchdogCheckIntervalDuration(java.time.Duration) instead")
        public final Builder setStreamWatchdogCheckInterval(Duration duration) {
            return this.setStreamWatchdogCheckIntervalDuration(TimeConversionUtils.toJavaTimeDuration(duration));
        }

        public abstract Builder setStreamWatchdogCheckIntervalDuration(java.time.Duration var1);

        @BetaApi(value="The surface for tracing is not stable yet and may change in the future.")
        public abstract Builder setTracerFactory(ApiTracerFactory var1);

        public abstract Builder setGdchApiAudience(String var1);

        abstract Builder setEndpointContext(EndpointContext var1);

        public abstract ClientContext build();
    }
}

