/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.rpc;

import shaded.bqjdbc.com.google.api.core.ApiFunction;
import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.gax.longrunning.OperationFuture;
import shaded.bqjdbc.com.google.api.gax.longrunning.OperationFutureImpl;
import shaded.bqjdbc.com.google.api.gax.longrunning.OperationSnapshot;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingExecutorWithContext;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingFuture;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.LongRunningClient;
import shaded.bqjdbc.com.google.api.gax.rpc.OperationCallSettings;
import shaded.bqjdbc.com.google.api.gax.rpc.OperationCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.OperationCheckingCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.RecheckingCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.common.base.Preconditions;

class OperationCallableImpl<RequestT, ResponseT, MetadataT>
extends OperationCallable<RequestT, ResponseT, MetadataT> {
    private final UnaryCallable<RequestT, OperationSnapshot> initialCallable;
    private final RetryingExecutorWithContext<OperationSnapshot> executor;
    private final LongRunningClient longRunningClient;
    private final ApiFunction<OperationSnapshot, ResponseT> responseTransformer;
    private final ApiFunction<OperationSnapshot, MetadataT> metadataTransformer;

    OperationCallableImpl(UnaryCallable<RequestT, OperationSnapshot> initialCallable, RetryingExecutorWithContext<OperationSnapshot> executor, LongRunningClient longRunningClient, OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings) {
        this.initialCallable = Preconditions.checkNotNull(initialCallable);
        this.executor = Preconditions.checkNotNull(executor);
        this.longRunningClient = Preconditions.checkNotNull(longRunningClient);
        this.responseTransformer = operationCallSettings.getResponseTransformer();
        this.metadataTransformer = operationCallSettings.getMetadataTransformer();
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> futureCall(RequestT request, ApiCallContext callContext) {
        ApiFuture<OperationSnapshot> initialFuture = this.initialCallable.futureCall(request, callContext);
        return this.futureCall(initialFuture, callContext);
    }

    @Override
    OperationFutureImpl<ResponseT, MetadataT> futureCall(ApiFuture<OperationSnapshot> initialFuture, ApiCallContext callContext) {
        RecheckingCallable callable = new RecheckingCallable(new OperationCheckingCallable(this.longRunningClient, initialFuture), this.executor);
        ApiFuture pollingFuture = callable.futureCall((Object)null, callContext);
        return new OperationFutureImpl<ResponseT, MetadataT>((RetryingFuture<OperationSnapshot>)pollingFuture, initialFuture, this.responseTransformer, this.metadataTransformer);
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> resumeFutureCall(String operationName, ApiCallContext callContext) {
        ApiFuture<OperationSnapshot> firstAttempt = this.longRunningClient.getOperationCallable().futureCall(operationName, callContext);
        return this.futureCall(firstAttempt, callContext);
    }

    @Override
    public ApiFuture<Void> cancel(String operationName, ApiCallContext callContext) {
        return this.longRunningClient.cancelOperationCallable().futureCall(operationName, callContext);
    }
}

