/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.rpc;

import shaded.bqjdbc.com.google.api.gax.retrying.RetryingExecutorWithContext;
import shaded.bqjdbc.com.google.api.gax.retrying.RetryingFuture;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.CheckingAttemptCallable;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.common.base.Preconditions;

class RecheckingCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RetryingExecutorWithContext<ResponseT> executor;

    RecheckingCallable(UnaryCallable<RequestT, ResponseT> callable, RetryingExecutorWithContext<ResponseT> executor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    public RetryingFuture<ResponseT> futureCall(RequestT ignored, ApiCallContext inputContext) {
        CheckingAttemptCallable<RequestT, ResponseT> checkingAttemptCallable = new CheckingAttemptCallable<RequestT, ResponseT>(this.callable, inputContext);
        RetryingFuture<ResponseT> retryingFuture = this.executor.createFuture(checkingAttemptCallable, inputContext);
        checkingAttemptCallable.setExternalFuture(retryingFuture);
        checkingAttemptCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("rechecking(%s)", this.callable);
    }
}

