/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.rpc;

import java.util.Map;
import shaded.bqjdbc.com.google.api.client.util.escape.PercentEscaper;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestParamsEncoder;
import shaded.bqjdbc.com.google.api.gax.rpc.RequestParamsExtractor;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.Preconditions;

@InternalApi(value="For use by transport-specific implementations")
public class RequestUrlParamsEncoder<RequestT>
implements RequestParamsEncoder<RequestT> {
    private static final PercentEscaper PERCENT_ESCAPER = new PercentEscaper("._-~");
    private final RequestParamsExtractor<RequestT> paramsExtractor;

    public RequestUrlParamsEncoder(RequestParamsExtractor<RequestT> paramsExtractor) {
        this.paramsExtractor = Preconditions.checkNotNull(paramsExtractor);
    }

    @Override
    public String encode(RequestT request) {
        Map<String, String> params = this.paramsExtractor.extract(request);
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            String encodedKey = this.percentEncodeString(entry.getKey());
            String encodedValue = this.percentEncodeString(entry.getValue());
            sb.append(encodedKey).append("=").append(encodedValue);
        }
        return sb.toString();
    }

    @VisibleForTesting
    String percentEncodeString(String value) {
        return PERCENT_ESCAPER.escape(value);
    }
}

