/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.rpc;

import java.util.Set;
import javax.annotation.Nonnull;
import shaded.bqjdbc.com.google.api.core.ObsoleteApi;
import shaded.bqjdbc.com.google.api.gax.retrying.RetrySettings;
import shaded.bqjdbc.com.google.api.gax.retrying.SimpleStreamResumptionStrategy;
import shaded.bqjdbc.com.google.api.gax.retrying.StreamResumptionStrategy;
import shaded.bqjdbc.com.google.api.gax.rpc.StatusCode;
import shaded.bqjdbc.com.google.api.gax.rpc.StreamingCallSettings;
import shaded.bqjdbc.com.google.api.gax.util.TimeConversionUtils;
import shaded.bqjdbc.com.google.common.base.MoreObjects;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.collect.ImmutableSet;
import shaded.bqjdbc.com.google.common.collect.Sets;
import shaded.bqjdbc.org.threeten.bp.Duration;

public final class ServerStreamingCallSettings<RequestT, ResponseT>
extends StreamingCallSettings<RequestT, ResponseT> {
    @Nonnull
    private final Set<StatusCode.Code> retryableCodes;
    @Nonnull
    private final RetrySettings retrySettings;
    @Nonnull
    private final StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy;
    @Nonnull
    private final java.time.Duration idleTimeout;
    @Nonnull
    private final java.time.Duration waitTimeout;

    private ServerStreamingCallSettings(Builder<RequestT, ResponseT> builder) {
        this.retryableCodes = ImmutableSet.copyOf(((Builder)builder).retryableCodes);
        this.retrySettings = ((Builder)builder).retrySettingsBuilder.build();
        this.resumptionStrategy = ((Builder)builder).resumptionStrategy;
        this.idleTimeout = ((Builder)builder).idleTimeout;
        this.waitTimeout = ((Builder)builder).waitTimeout;
    }

    @Nonnull
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Nonnull
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Nonnull
    public StreamResumptionStrategy<RequestT, ResponseT> getResumptionStrategy() {
        return this.resumptionStrategy;
    }

    @Nonnull
    @ObsoleteApi(value="Use getIdleTimeoutDuration() instead")
    public Duration getIdleTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getIdleTimeoutDuration());
    }

    @Nonnull
    public java.time.Duration getIdleTimeoutDuration() {
        return this.idleTimeout;
    }

    @Nonnull
    @ObsoleteApi(value="Use getWaitTimeoutDuration() instead")
    public Duration getWaitTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getWaitTimeoutDuration());
    }

    @Nonnull
    public java.time.Duration getWaitTimeoutDuration() {
        return this.waitTimeout;
    }

    @Override
    public Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("idleTimeout", this.idleTimeout).add("waitTimeout", this.waitTimeout).add("retryableCodes", this.retryableCodes).add("retrySettings", this.retrySettings).toString();
    }

    public static class Builder<RequestT, ResponseT>
    extends StreamingCallSettings.Builder<RequestT, ResponseT> {
        @Nonnull
        private Set<StatusCode.Code> retryableCodes;
        @Nonnull
        private RetrySettings.Builder retrySettingsBuilder;
        @Nonnull
        private StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy;
        @Nonnull
        private java.time.Duration idleTimeout;
        @Nonnull
        private java.time.Duration waitTimeout;

        private Builder() {
            this.retryableCodes = ImmutableSet.of();
            this.retrySettingsBuilder = RetrySettings.newBuilder();
            this.resumptionStrategy = new SimpleStreamResumptionStrategy();
            this.idleTimeout = java.time.Duration.ZERO;
            this.waitTimeout = java.time.Duration.ZERO;
        }

        private Builder(ServerStreamingCallSettings<RequestT, ResponseT> settings) {
            super(settings);
            this.retryableCodes = ((ServerStreamingCallSettings)settings).retryableCodes;
            this.retrySettingsBuilder = ((ServerStreamingCallSettings)settings).retrySettings.toBuilder();
            this.resumptionStrategy = ((ServerStreamingCallSettings)settings).resumptionStrategy;
            this.idleTimeout = ((ServerStreamingCallSettings)settings).idleTimeout;
            this.waitTimeout = ((ServerStreamingCallSettings)settings).waitTimeout;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(StatusCode.Code ... codes) {
            this.setRetryableCodes(Sets.newHashSet(codes));
            return this;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            Preconditions.checkNotNull(retryableCodes);
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        @Nonnull
        public Set<StatusCode.Code> getRetryableCodes() {
            return this.retryableCodes;
        }

        public RetrySettings.Builder retrySettings() {
            return this.retrySettingsBuilder;
        }

        public Builder<RequestT, ResponseT> setRetrySettings(@Nonnull RetrySettings retrySettings) {
            Preconditions.checkNotNull(retrySettings);
            this.retrySettingsBuilder = retrySettings.toBuilder();
            return this;
        }

        @Nonnull
        public RetrySettings getRetrySettings() {
            return this.retrySettingsBuilder.build();
        }

        @ObsoleteApi(value="Use setSimpleTimeoutNoRetriesDuration(java.time.Duration) instead")
        public Builder<RequestT, ResponseT> setSimpleTimeoutNoRetries(@Nonnull Duration timeout) {
            return this.setSimpleTimeoutNoRetriesDuration(TimeConversionUtils.toJavaTimeDuration(timeout));
        }

        public Builder<RequestT, ResponseT> setSimpleTimeoutNoRetriesDuration(@Nonnull java.time.Duration timeout) {
            this.setRetryableCodes(new StatusCode.Code[0]);
            this.setRetrySettings(RetrySettings.newBuilder().setTotalTimeoutDuration(timeout).setInitialRetryDelayDuration(java.time.Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelayDuration(java.time.Duration.ZERO).setInitialRpcTimeoutDuration(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(timeout).setMaxAttempts(1).build());
            return this;
        }

        public Builder<RequestT, ResponseT> setResumptionStrategy(@Nonnull StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy) {
            Preconditions.checkNotNull(resumptionStrategy);
            this.resumptionStrategy = Preconditions.checkNotNull(resumptionStrategy);
            return this;
        }

        @Nonnull
        public StreamResumptionStrategy<RequestT, ResponseT> getResumptionStrategy() {
            return this.resumptionStrategy;
        }

        @Nonnull
        @ObsoleteApi(value="Use getIdleTimeoutDuration() instead")
        public Duration getIdleTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getIdleTimeoutDuration());
        }

        @Nonnull
        public java.time.Duration getIdleTimeoutDuration() {
            return this.idleTimeout;
        }

        @ObsoleteApi(value="Use setIdleTimeoutDuration(java.time.Duration) instead")
        public Builder<RequestT, ResponseT> setIdleTimeout(@Nonnull Duration idleTimeout) {
            return this.setIdleTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(idleTimeout));
        }

        public Builder<RequestT, ResponseT> setIdleTimeoutDuration(@Nonnull java.time.Duration idleTimeout) {
            this.idleTimeout = Preconditions.checkNotNull(idleTimeout);
            return this;
        }

        @Nonnull
        @ObsoleteApi(value="Use getWaitTimeoutDuration() instead")
        public Duration getWaitTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getWaitTimeoutDuration());
        }

        @Nonnull
        public java.time.Duration getWaitTimeoutDuration() {
            return this.waitTimeout;
        }

        @ObsoleteApi(value="Use setWaitTimeoutDuration(java.time.Duration) instead")
        public Builder<RequestT, ResponseT> setWaitTimeout(@Nonnull Duration waitTimeout) {
            return this.setWaitTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(waitTimeout));
        }

        public Builder<RequestT, ResponseT> setWaitTimeoutDuration(@Nonnull java.time.Duration waitTimeout) {
            this.waitTimeout = waitTimeout;
            return this;
        }

        @Override
        public ServerStreamingCallSettings<RequestT, ResponseT> build() {
            return new ServerStreamingCallSettings(this);
        }
    }
}

