/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.tracing;

import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.core.ObsoleteApi;
import shaded.bqjdbc.com.google.api.gax.util.TimeConversionUtils;
import shaded.bqjdbc.org.threeten.bp.Duration;

@InternalApi
public interface ApiTracer {
    default public Scope inScope() {
        return () -> {};
    }

    default public void operationSucceeded() {
    }

    default public void operationCancelled() {
    }

    default public void operationFailed(Throwable error) {
    }

    default public void connectionSelected(String id) {
    }

    @Deprecated
    default public void attemptStarted(int attemptNumber) {
    }

    default public void attemptStarted(Object request, int attemptNumber) {
    }

    default public void attemptSucceeded() {
    }

    default public void attemptCancelled() {
    }

    @ObsoleteApi(value="Use attemptFailedDuration(Throwable, java.time.Duration) instead")
    default public void attemptFailed(Throwable error, Duration delay) {
    }

    default public void attemptFailedDuration(Throwable error, java.time.Duration delay) {
        this.attemptFailed(error, TimeConversionUtils.toThreetenDuration(delay));
    }

    default public void attemptFailedRetriesExhausted(Throwable error) {
    }

    default public void attemptPermanentFailure(Throwable error) {
    }

    default public void lroStartFailed(Throwable error) {
    }

    default public void lroStartSucceeded() {
    }

    default public void responseReceived() {
    }

    default public void requestSent() {
    }

    default public void batchRequestSent(long elementCount, long requestSize) {
    }

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

