/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.tracing;

import java.util.Map;
import javax.annotation.Nonnull;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracer;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracerFactory;
import shaded.bqjdbc.com.google.api.gax.tracing.BaseApiTracerFactory;
import shaded.bqjdbc.com.google.api.gax.tracing.OpencensusTracer;
import shaded.bqjdbc.com.google.api.gax.tracing.SpanName;
import shaded.bqjdbc.com.google.common.base.Objects;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.common.collect.ImmutableMap;
import shaded.bqjdbc.io.opencensus.trace.AttributeValue;
import shaded.bqjdbc.io.opencensus.trace.Span;
import shaded.bqjdbc.io.opencensus.trace.Tracer;
import shaded.bqjdbc.io.opencensus.trace.Tracing;

@InternalApi(value="For google-cloud-java client use only")
public final class OpencensusTracerFactory
extends BaseApiTracerFactory {
    @Nonnull
    private final Tracer internalTracer;
    @Nonnull
    private final Map<String, AttributeValue> spanAttributes;

    public OpencensusTracerFactory() {
        this(ImmutableMap.of());
    }

    public OpencensusTracerFactory(Map<String, String> spanAttributes) {
        this(Tracing.getTracer(), spanAttributes);
    }

    @InternalApi(value="Visible for testing")
    OpencensusTracerFactory(Tracer internalTracer, @Nonnull Map<String, String> spanAttributes) {
        this.internalTracer = Preconditions.checkNotNull(internalTracer, "internalTracer can't be null");
        ImmutableMap.Builder<String, AttributeValue> formattedSpanAttributes = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : spanAttributes.entrySet()) {
            formattedSpanAttributes.put(entry.getKey(), AttributeValue.stringAttributeValue(entry.getValue()));
        }
        this.spanAttributes = formattedSpanAttributes.build();
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        Span parentSpan = this.internalTracer.getCurrentSpan();
        if (parent instanceof OpencensusTracer) {
            parentSpan = ((OpencensusTracer)parent).getSpan();
        }
        Span span = this.internalTracer.spanBuilderWithExplicitParent(spanName.toString(), parentSpan).setRecordEvents(true).startSpan();
        span.putAttributes(this.spanAttributes);
        return new OpencensusTracer(this.internalTracer, span, operationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpencensusTracerFactory that = (OpencensusTracerFactory)o;
        return Objects.equal(this.internalTracer, that.internalTracer) && Objects.equal(this.spanAttributes, that.spanAttributes);
    }

    public int hashCode() {
        return Objects.hashCode(this.internalTracer, this.spanAttributes);
    }
}

