/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.tracing;

import java.util.concurrent.CancellationException;
import javax.annotation.Nonnull;
import shaded.bqjdbc.com.google.api.core.ApiFutureCallback;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracer;
import shaded.bqjdbc.com.google.common.base.Preconditions;

class TraceFinisher<T>
implements ApiFutureCallback<T> {
    private final ApiTracer tracer;

    TraceFinisher(@Nonnull ApiTracer tracer) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
    }

    @Override
    public void onFailure(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(throwable);
        }
    }

    @Override
    public void onSuccess(T responseT) {
        this.tracer.operationSucceeded();
    }
}

