/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.api.gax.tracing;

import shaded.bqjdbc.com.google.api.core.ApiFuture;
import shaded.bqjdbc.com.google.api.core.ApiFutureCallback;
import shaded.bqjdbc.com.google.api.core.ApiFutures;
import shaded.bqjdbc.com.google.api.gax.longrunning.OperationSnapshot;
import shaded.bqjdbc.com.google.api.gax.rpc.ApiCallContext;
import shaded.bqjdbc.com.google.api.gax.rpc.UnaryCallable;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracer;
import shaded.bqjdbc.com.google.api.gax.tracing.ApiTracerFactory;
import shaded.bqjdbc.com.google.api.gax.tracing.SpanName;
import shaded.bqjdbc.com.google.api.gax.tracing.TracedUnaryCallable;
import shaded.bqjdbc.com.google.common.util.concurrent.MoreExecutors;

public class TracedOperationInitialCallable<RequestT>
extends TracedUnaryCallable<RequestT, OperationSnapshot> {
    public TracedOperationInitialCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, ApiTracerFactory tracedFactory, SpanName spanName) {
        super(innerCallable, tracedFactory, spanName);
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(RequestT request, ApiCallContext context) {
        InitialCallableFinisher finisher = new InitialCallableFinisher(context.getTracer());
        try {
            ApiFuture<OperationSnapshot> future = super.futureCall(request, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    private static class InitialCallableFinisher
    implements ApiFutureCallback<OperationSnapshot> {
        private final ApiTracer operationTracer;

        private InitialCallableFinisher(ApiTracer operationTracer) {
            this.operationTracer = operationTracer;
        }

        @Override
        public void onSuccess(OperationSnapshot result) {
            this.operationTracer.lroStartSucceeded();
        }

        @Override
        public void onFailure(Throwable t2) {
            this.operationTracer.lroStartFailed(t2);
        }
    }
}

