/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.bqjdbc.com.google.auth.oauth2.ExternalAccountCredentials;

public class AwsCredentialSource
extends ExternalAccountCredentials.CredentialSource {
    static final String IMDSV2_SESSION_TOKEN_URL_FIELD_NAME = "imdsv2_session_token_url";
    static final long serialVersionUID = -4180558200808134436L;
    final String regionUrl;
    final String url;
    final String regionalCredentialVerificationUrl;
    final String imdsv2SessionTokenUrl;

    public AwsCredentialSource(Map<String, Object> credentialSourceMap) {
        super(credentialSourceMap);
        if (!credentialSourceMap.containsKey("regional_cred_verification_url")) {
            throw new IllegalArgumentException("A regional_cred_verification_url representing the GetCallerIdentity action URL must be specified.");
        }
        String environmentId = (String)credentialSourceMap.get("environment_id");
        Matcher matcher = Pattern.compile("(aws)([\\d]+)").matcher(environmentId);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid AWS environment ID.");
        }
        int environmentVersion = Integer.parseInt(matcher.group(2));
        if (environmentVersion != 1) {
            throw new IllegalArgumentException(String.format("AWS version %s is not supported in the current build.", environmentVersion));
        }
        this.regionUrl = (String)credentialSourceMap.get("region_url");
        this.url = (String)credentialSourceMap.get("url");
        this.regionalCredentialVerificationUrl = (String)credentialSourceMap.get("regional_cred_verification_url");
        this.imdsv2SessionTokenUrl = credentialSourceMap.containsKey(IMDSV2_SESSION_TOKEN_URL_FIELD_NAME) ? (String)credentialSourceMap.get(IMDSV2_SESSION_TOKEN_URL_FIELD_NAME) : null;
    }
}

