/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.io.IOException;
import shaded.bqjdbc.com.google.auth.http.HttpTransportFactory;
import shaded.bqjdbc.com.google.auth.oauth2.AccessToken;
import shaded.bqjdbc.com.google.auth.oauth2.CredentialAccessBoundary;
import shaded.bqjdbc.com.google.auth.oauth2.GoogleCredentials;
import shaded.bqjdbc.com.google.auth.oauth2.OAuth2Credentials;
import shaded.bqjdbc.com.google.auth.oauth2.OAuth2Utils;
import shaded.bqjdbc.com.google.auth.oauth2.StsRequestHandler;
import shaded.bqjdbc.com.google.auth.oauth2.StsTokenExchangeRequest;
import shaded.bqjdbc.com.google.common.annotations.VisibleForTesting;
import shaded.bqjdbc.com.google.common.base.MoreObjects;
import shaded.bqjdbc.com.google.common.base.Preconditions;
import shaded.bqjdbc.com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class DownscopedCredentials
extends OAuth2Credentials {
    private final GoogleCredentials sourceCredential;
    private final CredentialAccessBoundary credentialAccessBoundary;
    private final String universeDomain;
    private final transient HttpTransportFactory transportFactory;
    private final String tokenExchangeEndpoint;

    private DownscopedCredentials(Builder builder) {
        this.transportFactory = MoreObjects.firstNonNull(builder.transportFactory, DownscopedCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.sourceCredential = Preconditions.checkNotNull(builder.sourceCredential);
        this.credentialAccessBoundary = Preconditions.checkNotNull(builder.credentialAccessBoundary);
        this.universeDomain = builder.universeDomain == null || builder.universeDomain.trim().isEmpty() ? "googleapis.com" : builder.universeDomain;
        try {
            if (!this.universeDomain.equals(this.sourceCredential.getUniverseDomain())) {
                throw new IllegalArgumentException("The downscoped credential's universe domain must be the same as the source credential.");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occurred when attempting to retrieve source credential universe domain.", e);
        }
        this.tokenExchangeEndpoint = String.format("https://sts.%s/v1/token", this.universeDomain);
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        AccessToken sourceAccessToken;
        try {
            this.sourceCredential.refreshIfExpired();
        }
        catch (IOException e) {
            throw new IOException("Unable to refresh the provided source credential.", e);
        }
        StsTokenExchangeRequest request = StsTokenExchangeRequest.newBuilder(this.sourceCredential.getAccessToken().getTokenValue(), "urn:ietf:params:oauth:token-type:access_token").setRequestTokenType("urn:ietf:params:oauth:token-type:access_token").build();
        StsRequestHandler handler = StsRequestHandler.newBuilder(this.tokenExchangeEndpoint, request, this.transportFactory.create().createRequestFactory()).setInternalOptions(this.credentialAccessBoundary.toJson()).build();
        AccessToken downscopedAccessToken = handler.exchangeToken().getAccessToken();
        if (downscopedAccessToken.getExpirationTime() == null && (sourceAccessToken = this.sourceCredential.getAccessToken()).getExpirationTime() != null) {
            return new AccessToken(downscopedAccessToken.getTokenValue(), sourceAccessToken.getExpirationTime());
        }
        return downscopedAccessToken;
    }

    public GoogleCredentials getSourceCredentials() {
        return this.sourceCredential;
    }

    public CredentialAccessBoundary getCredentialAccessBoundary() {
        return this.credentialAccessBoundary;
    }

    @Override
    public String getUniverseDomain() {
        return this.universeDomain;
    }

    @VisibleForTesting
    HttpTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        private GoogleCredentials sourceCredential;
        private CredentialAccessBoundary credentialAccessBoundary;
        private HttpTransportFactory transportFactory;
        private String universeDomain;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setSourceCredential(GoogleCredentials sourceCredential) {
            this.sourceCredential = sourceCredential;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCredentialAccessBoundary(CredentialAccessBoundary credentialAccessBoundary) {
            this.credentialAccessBoundary = credentialAccessBoundary;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        @Override
        public DownscopedCredentials build() {
            return new DownscopedCredentials(this);
        }
    }
}

