/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.io.Serializable;
import shaded.bqjdbc.com.google.auth.oauth2.ExternalAccountCredentials;
import shaded.bqjdbc.com.google.auth.oauth2.MetricsUtils;

class ExternalAccountMetricsHandler
implements Serializable {
    private static final String SOURCE_KEY = "source";
    private static final String IMPERSONATION_KEY = "sa-impersonation";
    private static final String CONFIG_LIFETIME_KEY = "config-lifetime";
    private static final String BYOID_METRICS_SECTION = "google-byoid-sdk";
    private final boolean configLifetime;
    private final boolean saImpersonation;
    private ExternalAccountCredentials credentials;

    ExternalAccountMetricsHandler(ExternalAccountCredentials creds) {
        this.saImpersonation = creds.getServiceAccountImpersonationUrl() != null;
        this.configLifetime = creds.getServiceAccountImpersonationOptions().customTokenLifetimeRequested;
        this.credentials = creds;
    }

    String getExternalAccountMetricsHeader() {
        return String.format("%s %s %s/%s %s/%s %s/%s", MetricsUtils.getLanguageAndAuthLibraryVersions(), BYOID_METRICS_SECTION, SOURCE_KEY, this.credentials.getCredentialSourceType(), IMPERSONATION_KEY, this.saImpersonation, CONFIG_LIFETIME_KEY, this.configLifetime);
    }
}

