/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.com.google.auth.oauth2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import shaded.bqjdbc.com.google.api.client.json.GenericJson;
import shaded.bqjdbc.com.google.api.client.json.JsonObjectParser;
import shaded.bqjdbc.com.google.auth.oauth2.ExternalAccountSupplierContext;
import shaded.bqjdbc.com.google.auth.oauth2.IdentityPoolCredentialSource;
import shaded.bqjdbc.com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import shaded.bqjdbc.com.google.auth.oauth2.OAuth2Utils;
import shaded.bqjdbc.com.google.common.io.CharStreams;

class FileIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private final long serialVersionUID = 2475549052347431992L;
    private final IdentityPoolCredentialSource credentialSource;

    FileIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource) {
        this.credentialSource = credentialSource;
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        String credentialFilePath = this.credentialSource.getCredentialLocation();
        if (!Files.exists(Paths.get(credentialFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new IOException(String.format("Invalid credential location. The file at %s does not exist.", credentialFilePath));
        }
        try {
            return FileIdentityPoolSubjectTokenSupplier.parseToken(Files.newInputStream(new File(credentialFilePath).toPath(), new OpenOption[0]), this.credentialSource);
        }
        catch (IOException e) {
            throw new IOException("Error when attempting to read the subject token from the credential file.", e);
        }
    }

    static String parseToken(InputStream inputStream, IdentityPoolCredentialSource credentialSource) throws IOException {
        if (credentialSource.credentialFormatType == IdentityPoolCredentialSource.CredentialFormatType.TEXT) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return CharStreams.toString(reader);
        }
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(inputStream, StandardCharsets.UTF_8, GenericJson.class);
        if (!fileContents.containsKey(credentialSource.subjectTokenFieldName)) {
            throw new IOException("Invalid subject token field name. No subject token was found.");
        }
        return (String)fileContents.get(credentialSource.subjectTokenFieldName);
    }
}

